/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class BlockInvocationHandler
implements InvocationHandler {
    private transient Object m_object;
    private transient Object m_proxy;

    public void invalidate() {
        this.m_object = null;
        this.m_proxy = null;
    }

    public Object getProxy() {
        return this.m_proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.m_object != null) {
            try {
                return method.invoke(this.m_object, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        throw new IllegalStateException("Using a stale object reference to call a disposed Block.");
    }

    protected BlockInvocationHandler(Object object, Class[] interfaces) {
        ClassLoader classLoader = object.getClass().getClassLoader();
        this.m_object = object;
        this.m_proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)this);
    }
}

