/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import org.apache.avalon.phoenix.BlockEvent;
import org.apache.avalon.phoenix.BlockListener;

final class BlockListenerSupport {
    private BlockListener[] m_listeners = new BlockListener[0];

    public synchronized void addBlockListener(BlockListener listener) {
        BlockListener[] listeners = new BlockListener[1 + this.m_listeners.length];
        System.arraycopy(this.m_listeners, 0, listeners, 0, this.m_listeners.length);
        listeners[this.m_listeners.length] = listener;
        this.m_listeners = listeners;
    }

    public synchronized void removeBlockListener(BlockListener listener) {
        int index = 0;
        while (index < this.m_listeners.length) {
            if (this.m_listeners[index] == listener) break;
            ++index;
        }
        if (this.m_listeners.length != index) {
            BlockListener[] listeners = new BlockListener[this.m_listeners.length - 1];
            System.arraycopy(this.m_listeners, 0, listeners, 0, index);
            int length = this.m_listeners.length - index - 1;
            System.arraycopy(this.m_listeners, index + 1, listeners, index, length);
        }
    }

    public synchronized void blockAdded(BlockEvent event) {
        int i = 0;
        while (i < this.m_listeners.length) {
            this.m_listeners[i].blockAdded(event);
            ++i;
        }
    }

    public synchronized void blockRemoved(BlockEvent event) {
        int i = 0;
        while (i < this.m_listeners.length) {
            this.m_listeners[i].blockRemoved(event);
            ++i;
        }
    }

    BlockListenerSupport() {
    }
}

