/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.lang.ThreadContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block;
import org.apache.avalon.phoenix.components.application.BlockEntry;
import org.apache.avalon.phoenix.components.application.DependencyGraph;
import org.apache.avalon.phoenix.components.application.LifecycleHelper;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.metadata.BlockListenerMetaData;
import org.apache.avalon.phoenix.metadata.BlockMetaData;

public final class DefaultApplication
extends AbstractLogEnabled
implements Application {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$application$DefaultApplication != null ? class$Lorg$apache$avalon$phoenix$components$application$DefaultApplication : (class$Lorg$apache$avalon$phoenix$components$application$DefaultApplication = DefaultApplication.class$("org.apache.avalon.phoenix.components.application.DefaultApplication"))));
    private static final String PHASE_STARTUP = "startup";
    private static final String PHASE_SHUTDOWN = "shutdown";
    private ApplicationContext m_context;
    private LifecycleHelper m_lifecycle;
    private HashMap m_entrys = new HashMap();
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$application$DefaultApplication;

    public void setApplicationContext(ApplicationContext context) {
        this.m_context = context;
        this.m_lifecycle = new LifecycleHelper(this, this.m_context);
        this.setupLogger((Object)this.m_lifecycle, "lifecycle");
    }

    public String[] getBlockNames() {
        return this.m_entrys.keySet().toArray(new String[0]);
    }

    public Block getBlock(String name) {
        BlockEntry entry = (BlockEntry)this.m_entrys.get(name);
        if (entry == null) {
            return null;
        }
        return entry.getProxy();
    }

    public void initialize() throws Exception {
    }

    public void start() throws Exception {
        BlockMetaData[] blocks = this.m_context.getMetaData().getBlocks();
        int i = 0;
        while (i < blocks.length) {
            String blockName = blocks[i].getName();
            BlockEntry blockEntry = new BlockEntry(blocks[i]);
            this.m_entrys.put(blockName, blockEntry);
            ++i;
        }
        this.loadBlockListeners();
        this.runPhase(PHASE_STARTUP);
    }

    public void stop() throws Exception {
        this.runPhase(PHASE_SHUTDOWN);
    }

    public void dispose() {
        this.m_entrys.clear();
    }

    private void loadBlockListeners() throws Exception {
        ThreadContext.setThreadContext((ThreadContext)this.m_context.getThreadContext());
        BlockListenerMetaData[] listeners = this.m_context.getMetaData().getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                this.m_lifecycle.startupListener(listeners[i]);
            }
            catch (Exception e) {
                String name = listeners[i].getName();
                String message = REZ.getString("bad-listener", (Object)PHASE_STARTUP, (Object)name, (Object)e.getMessage());
                this.getLogger().error(message, (Throwable)e);
                throw e;
            }
            ++i;
        }
    }

    protected final void runPhase(String name) throws Exception {
        String message;
        BlockMetaData[] blocks = this.m_context.getMetaData().getBlocks();
        String[] order = DependencyGraph.walkGraph(PHASE_STARTUP == name, blocks);
        if (this.getLogger().isInfoEnabled()) {
            Integer count = new Integer(blocks.length);
            List<String> pathList = Arrays.asList(order);
            message = REZ.getString("blocks-processing", (Object)count, (Object)name, pathList);
            this.getLogger().info(message);
        }
        ThreadContext.setThreadContext((ThreadContext)this.m_context.getThreadContext());
        int i = 0;
        while (i < order.length) {
            String block = order[i];
            if (this.getLogger().isDebugEnabled()) {
                message = REZ.getString("process-block", (Object)block, (Object)name);
                this.getLogger().debug(message);
            }
            try {
                BlockEntry entry = (BlockEntry)this.m_entrys.get(block);
                if (PHASE_STARTUP == name) {
                    this.m_lifecycle.startup(entry);
                } else {
                    this.m_lifecycle.shutdown(entry);
                }
            }
            catch (Exception e) {
                String message2 = REZ.getString("app.error.run-phase", (Object)name, (Object)block, (Object)e.getMessage());
                this.getLogger().error(message2, (Throwable)e);
                throw e;
            }
            if (this.getLogger().isDebugEnabled()) {
                message = REZ.getString("processed-block", (Object)block, (Object)name);
                this.getLogger().debug(message);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

