/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.io.File;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.BlockContext;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.metadata.SarMetaData;

final class DefaultBlockContext
implements BlockContext,
LogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$application$DefaultBlockContext != null ? class$Lorg$apache$avalon$phoenix$components$application$DefaultBlockContext : (class$Lorg$apache$avalon$phoenix$components$application$DefaultBlockContext = DefaultBlockContext.class$("org.apache.avalon.phoenix.components.application.DefaultBlockContext"))));
    private String m_name;
    private ApplicationContext m_frame;
    private Logger m_logger;
    private boolean m_warningEmitted;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$application$DefaultBlockContext;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Object get(Object key) throws ContextException {
        SarMetaData metaData = this.m_frame.getMetaData();
        if ("app.name".equals(key)) {
            return metaData.getName();
        }
        if ("app.home".equals(key)) {
            return metaData.getHomeDirectory();
        }
        if ("block.name".equals(key)) {
            return this.m_name;
        }
        throw new ContextException("Unknown key: " + key);
    }

    public File getBaseDirectory() {
        return this.m_frame.getMetaData().getHomeDirectory();
    }

    public String getName() {
        return this.m_name;
    }

    public ThreadPool getThreadPool(String category) {
        if (!this.m_warningEmitted) {
            String message = REZ.getString("context.warn.threadpool", (Object)this.getName());
            this.m_logger.warn(message);
            System.err.println(message);
            this.m_warningEmitted = true;
        }
        return this.m_frame.getThreadPool(category);
    }

    public ThreadPool getDefaultThreadPool() {
        return this.getThreadPool("default");
    }

    public Logger getLogger(String name) {
        return new LogKitLogger(this.m_frame.getLogger(this.getName()).getChildLogger(name));
    }

    public Logger getBaseLogger() {
        return new LogKitLogger(this.m_frame.getLogger(this.getName()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected DefaultBlockContext(String name, ApplicationContext frame) {
        this.m_name = name;
        this.m_frame = frame;
    }
}

