/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.util.ArrayList;
import org.apache.avalon.phoenix.metadata.BlockMetaData;
import org.apache.avalon.phoenix.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.metainfo.DependencyDescriptor;

class DependencyGraph {
    public static String[] walkGraph(boolean forward, BlockMetaData[] blocks) {
        ArrayList result = new ArrayList();
        ArrayList done = new ArrayList();
        int i = 0;
        while (i < blocks.length) {
            DependencyGraph.visitBlock(blocks[i], blocks, forward, done, result);
            ++i;
        }
        return result.toArray(new String[0]);
    }

    private static void visitBlock(BlockMetaData block, BlockMetaData[] blocks, boolean forward, ArrayList done, ArrayList order) {
        String name = block.getName();
        if (done.contains(name)) {
            return;
        }
        done.add(name);
        if (forward) {
            DependencyGraph.visitDependencies(block, blocks, done, order);
        } else {
            DependencyGraph.visitReverseDependencies(block, blocks, done, order);
        }
        order.add(name);
    }

    private static void visitDependencies(BlockMetaData block, BlockMetaData[] blocks, ArrayList done, ArrayList order) {
        DependencyDescriptor[] descriptors = block.getBlockInfo().getDependencies();
        int i = 0;
        while (i < descriptors.length) {
            DependencyMetaData dependency = block.getDependency(descriptors[i].getRole());
            BlockMetaData other = DependencyGraph.getBlock(dependency.getName(), blocks);
            DependencyGraph.visitBlock(other, blocks, true, done, order);
            ++i;
        }
    }

    private static void visitReverseDependencies(BlockMetaData block, BlockMetaData[] blocks, ArrayList done, ArrayList order) {
        String name = block.getName();
        int i = 0;
        while (i < blocks.length) {
            BlockMetaData other = blocks[i];
            DependencyMetaData[] roles = other.getDependencies();
            int j = 0;
            while (j < roles.length) {
                String depends = roles[j].getName();
                if (depends.equals(name)) {
                    DependencyGraph.visitBlock(other, blocks, false, done, order);
                }
                ++j;
            }
            ++i;
        }
    }

    private static BlockMetaData getBlock(String name, BlockMetaData[] blocks) {
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i].getName().equals(name)) {
                return blocks[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private DependencyGraph() {
    }
}

