/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import org.apache.avalon.excalibur.container.State;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.DefaultComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.Block;
import org.apache.avalon.phoenix.BlockContext;
import org.apache.avalon.phoenix.BlockEvent;
import org.apache.avalon.phoenix.BlockListener;
import org.apache.avalon.phoenix.components.application.BlockEntry;
import org.apache.avalon.phoenix.components.application.BlockListenerSupport;
import org.apache.avalon.phoenix.components.application.DefaultBlockContext;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.metadata.BlockListenerMetaData;
import org.apache.avalon.phoenix.metadata.BlockMetaData;
import org.apache.avalon.phoenix.metadata.DependencyMetaData;

class LifecycleHelper
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$application$LifecycleHelper != null ? class$Lorg$apache$avalon$phoenix$components$application$LifecycleHelper : (class$Lorg$apache$avalon$phoenix$components$application$LifecycleHelper = LifecycleHelper.class$("org.apache.avalon.phoenix.components.application.LifecycleHelper"))));
    private static final int STAGE_CREATE = 0;
    private static final int STAGE_LOGGER = 1;
    private static final int STAGE_CONTEXT = 2;
    private static final int STAGE_COMPOSE = 3;
    private static final int STAGE_CONFIG = 4;
    private static final int STAGE_INIT = 5;
    private static final int STAGE_START = 6;
    private static final int STAGE_STOP = 7;
    private static final int STAGE_DISPOSE = 8;
    private static final int STAGE_DESTROY = 9;
    private static final int TYPE_BLOCK = 0;
    private static final int TYPE_LISTENER = 1;
    private ApplicationContext m_context;
    private Application m_application;
    private BlockListenerSupport m_listenerSupport = new BlockListenerSupport();
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$application$LifecycleHelper;

    public void startupListener(BlockListenerMetaData metaData) throws Exception {
        String name = metaData.getName();
        ClassLoader classLoader = this.m_context.getClassLoader();
        Class<?> clazz = classLoader.loadClass(metaData.getClassname());
        BlockListener listener = (BlockListener)clazz.newInstance();
        if (listener instanceof Configurable) {
            Configuration configuration = this.getConfiguration(name, 1);
            ((Configurable)listener).configure(configuration);
        }
        this.m_listenerSupport.addBlockListener(listener);
    }

    public void startup(BlockEntry entry) throws Exception {
        BlockMetaData metaData = entry.getMetaData();
        String name = metaData.getName();
        int stage = 0;
        try {
            stage = 0;
            this.notice(name, stage);
            Block block = this.createBlock(metaData);
            stage = 1;
            if (block instanceof Loggable) {
                this.notice(name, stage);
                ((Loggable)block).setLogger(this.m_context.getLogger(name));
            } else if (block instanceof LogEnabled) {
                this.notice(name, stage);
                LogKitLogger logger = new LogKitLogger(this.m_context.getLogger(name));
                ((LogEnabled)block).enableLogging((Logger)logger);
            }
            stage = 2;
            if (block instanceof Contextualizable) {
                this.notice(name, stage);
                BlockContext context = this.createBlockContext(name);
                ((Contextualizable)block).contextualize((Context)context);
            }
            stage = 3;
            if (block instanceof Composable) {
                this.notice(name, stage);
                ComponentManager componentManager = this.createComponentManager(metaData);
                ((Composable)block).compose(componentManager);
            }
            stage = 4;
            if (block instanceof Configurable) {
                this.notice(name, stage);
                Configuration configuration = this.getConfiguration(name, 0);
                ((Configurable)block).configure(configuration);
            }
            stage = 5;
            if (block instanceof Initializable) {
                this.notice(name, stage);
                ((Initializable)block).initialize();
            }
            stage = 6;
            if (block instanceof Startable) {
                this.notice(name, stage);
                ((Startable)block).start();
            }
            entry.setState(State.STARTED);
            entry.setBlock(block);
            BlockEvent event = new BlockEvent(name, entry.getProxy(), metaData.getBlockInfo());
            this.m_listenerSupport.blockAdded(event);
        }
        catch (Throwable t) {
            entry.setState(State.FAILED);
            this.fail(name, stage, t);
        }
    }

    public void shutdown(BlockEntry entry) {
        BlockMetaData metaData = entry.getMetaData();
        String name = metaData.getName();
        BlockEvent event = new BlockEvent(name, entry.getProxy(), metaData.getBlockInfo());
        this.m_listenerSupport.blockRemoved(event);
        Block block = entry.getBlock();
        entry.invalidate();
        if (block instanceof Startable) {
            this.notice(name, 7);
            try {
                entry.setState(State.STOPPING);
                ((Startable)block).stop();
                entry.setState(State.STOPPED);
            }
            catch (Throwable t) {
                entry.setState(State.FAILED);
                this.safeFail(name, 7, t);
            }
        }
        if (block instanceof Disposable) {
            this.notice(name, 8);
            try {
                entry.setState(State.DESTROYING);
                ((Disposable)block).dispose();
            }
            catch (Throwable t) {
                entry.setState(State.FAILED);
                this.safeFail(name, 8, t);
            }
        }
        this.notice(name, 9);
        entry.setState(State.DESTROYED);
    }

    private Block createBlock(BlockMetaData metaData) throws Exception {
        ClassLoader classLoader = this.m_context.getClassLoader();
        Class<?> clazz = classLoader.loadClass(metaData.getClassname());
        return (Block)clazz.newInstance();
    }

    private BlockContext createBlockContext(String name) {
        DefaultBlockContext context = new DefaultBlockContext(name, this.m_context);
        this.setupLogger(context);
        return context;
    }

    private Configuration getConfiguration(String name, int type) throws ConfigurationException {
        try {
            return this.m_context.getConfiguration(name);
        }
        catch (ConfigurationException ce) {
            String message = REZ.getString("missing-configuration", (Object)new Integer(type), (Object)name);
            throw new ConfigurationException(message, (Throwable)ce);
        }
    }

    private ComponentManager createComponentManager(BlockMetaData metaData) {
        DefaultComponentManager componentManager = new DefaultComponentManager();
        DependencyMetaData[] roles = metaData.getDependencies();
        int i = 0;
        while (i < roles.length) {
            DependencyMetaData role = roles[i];
            Block dependency = this.m_application.getBlock(role.getName());
            componentManager.put(role.getRole(), (Component)dependency);
            ++i;
        }
        return componentManager;
    }

    private void notice(String name, int stage) {
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("lifecycle-stage.notice", (Object)name, (Object)new Integer(stage));
            this.getLogger().debug(message);
        }
    }

    private void safeFail(String name, int stage, Throwable t) {
        String reason = t.toString();
        String message = REZ.getString("lifecycle-fail.error", (Object)name, (Object)new Integer(stage), (Object)reason);
        this.getLogger().error(message);
    }

    private void fail(String name, int stage, Throwable t) throws Exception {
        String reason = t.toString();
        String message = REZ.getString("lifecycle-fail.error", (Object)name, (Object)new Integer(stage), (Object)reason);
        this.getLogger().error(message);
        throw new CascadingException(message, t);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected LifecycleHelper(Application application, ApplicationContext context) {
        this.m_application = application;
        this.m_context = context;
    }
}

