/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

abstract class AbstractPolicy
extends Policy
implements Component,
LogEnabled {
    private final ArrayList m_entries = new ArrayList();
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        codeSource = this.normalize(codeSource);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getPermissions(" + codeSource.getLocation() + ");");
        }
        Permissions permissions = new Permissions();
        int size = this.m_entries.size();
        int i = 0;
        while (i < size) {
            PolicyEntry entry = (PolicyEntry)this.m_entries.get(i);
            if (entry.m_codeSource.implies(codeSource)) {
                this.copyPermissions(permissions, entry.m_permissions);
            }
            ++i;
        }
        return permissions;
    }

    public void refresh() {
    }

    protected Permissions createPermissionSetFor(String location, Certificate[] signers) throws MalformedURLException {
        return this.createPermissionSetFor(new URL(location), signers);
    }

    protected Permissions createPermissionSetFor(URL url, Certificate[] signers) {
        this.getLogger().debug("createPermissionSetFor(" + url + ");");
        PolicyEntry entry = new PolicyEntry();
        entry.m_codeSource = new CodeSource(url, signers);
        entry.m_codeSource = this.normalize(entry.m_codeSource);
        entry.m_permissions = new Permissions();
        this.m_entries.add(entry);
        return entry.m_permissions;
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    private CodeSource normalize(CodeSource codeSource) {
        URL initialLocation = codeSource.getLocation();
        if (initialLocation == null) {
            return codeSource;
        }
        String location = null;
        if (!initialLocation.getProtocol().equalsIgnoreCase("file")) {
            location = initialLocation.getFile();
            location = FileUtil.normalize((String)location);
        } else {
            File file = new File(initialLocation.getFile());
            location = file.getAbsoluteFile().toString().replace(File.separatorChar, '/');
            location = FileUtil.normalize((String)location);
        }
        URL finalLocation = null;
        try {
            finalLocation = new URL(initialLocation.getProtocol(), initialLocation.getHost(), initialLocation.getPort(), location);
        }
        catch (MalformedURLException mue) {
            this.getLogger().warn("Error building codeBase", (Throwable)mue);
        }
        return new CodeSource(finalLocation, codeSource.getCertificates());
    }

    private void copyPermissions(Permissions destination, Permissions source) {
        Enumeration<Permission> enumeration = source.elements();
        while (enumeration.hasMoreElements()) {
            destination.add(enumeration.nextElement());
        }
    }

    AbstractPolicy() {
    }

    private static class PolicyEntry {
        CodeSource m_codeSource;
        Permissions m_permissions;

        PolicyEntry() {
        }
    }
}

