/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Manifest;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.excalibur.extension.OptionalPackage;
import org.apache.avalon.excalibur.extension.PackageManager;
import org.apache.avalon.excalibur.extension.PackageRepository;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.components.classloader.DefaultPolicy;
import org.apache.avalon.phoenix.components.classloader.PolicyClassLoader;
import org.apache.avalon.phoenix.interfaces.ClassLoaderManager;

public class DefaultClassLoaderManager
extends AbstractLogEnabled
implements ClassLoaderManager,
Composable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$classloader$DefaultClassLoaderManager != null ? class$Lorg$apache$avalon$phoenix$components$classloader$DefaultClassLoaderManager : (class$Lorg$apache$avalon$phoenix$components$classloader$DefaultClassLoaderManager = DefaultClassLoaderManager.class$("org.apache.avalon.phoenix.components.classloader.DefaultClassLoaderManager"))));
    private PackageManager m_packageManager;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$classloader$DefaultClassLoaderManager;

    public void compose(ComponentManager componentManager) throws ComponentException {
        org.apache.avalon.phoenix.interfaces.PackageRepository packageRepository = (org.apache.avalon.phoenix.interfaces.PackageRepository)componentManager.lookup("org.apache.avalon.phoenix.components.classloader.PackageRepository");
        this.m_packageManager = new PackageManager((PackageRepository)packageRepository);
    }

    public ClassLoader createClassLoader(Configuration server, File source, File homeDirectory, String[] classPath) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("classpath-entries", Arrays.asList(classPath));
            this.getLogger().debug(message);
        }
        Configuration policyConfig = server.getChild("policy");
        Policy policy = this.configurePolicy(policyConfig, homeDirectory);
        File[] extensions = this.getOptionalPackagesFor(classPath);
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("optional-packages-added", Arrays.asList(extensions));
            this.getLogger().debug(message);
        }
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        PolicyClassLoader classLoader = new PolicyClassLoader(classPath, parentClassLoader, null, policy);
        this.setupLogger(classLoader, "classloader");
        int i = 0;
        while (i < extensions.length) {
            URL url = extensions[i].toURL();
            classLoader.addURL(url);
            ++i;
        }
        return classLoader;
    }

    private File[] getOptionalPackagesFor(String[] classPath) throws Exception {
        Manifest[] manifests = this.getManifests(classPath);
        Extension[] available = this.getAvailable(manifests);
        Extension[] required = this.getRequired(manifests);
        if (this.getLogger().isDebugEnabled()) {
            String message1 = REZ.getString("available-extensions", Arrays.asList(available));
            this.getLogger().debug(message1);
            String message2 = REZ.getString("required-extensions", Arrays.asList(required));
            this.getLogger().debug(message2);
        }
        ArrayList dependencies = new ArrayList();
        ArrayList unsatisfied = new ArrayList();
        this.m_packageManager.scanDependencies(required, available, dependencies, unsatisfied);
        if (unsatisfied.size() != 0) {
            int size = unsatisfied.size();
            int i = 0;
            while (i < size) {
                Extension extension = (Extension)unsatisfied.get(i);
                Object[] params = new Object[]{extension.getExtensionName(), extension.getSpecificationVendor(), extension.getSpecificationVersion(), extension.getImplementationVendor(), extension.getImplementationVendorId(), extension.getImplementationVersion(), extension.getImplementationURL()};
                String message = REZ.format("missing.extension", params);
                this.getLogger().warn(message);
                ++i;
            }
            String message = REZ.getString("unsatisfied.extensions", (Object)new Integer(size));
            throw new Exception(message);
        }
        OptionalPackage[] packages = dependencies.toArray(new OptionalPackage[0]);
        return OptionalPackage.toFiles((OptionalPackage[])packages);
    }

    private Extension[] getAvailable(Manifest[] manifests) {
        ArrayList<Extension> availableSet = new ArrayList<Extension>();
        int i = 0;
        while (i < manifests.length) {
            Extension[] available = Extension.getAvailable((Manifest)manifests[i]);
            int j = 0;
            while (j < available.length) {
                availableSet.add(available[j]);
                ++j;
            }
            ++i;
        }
        return availableSet.toArray(new Extension[0]);
    }

    private Extension[] getRequired(Manifest[] manifests) {
        ArrayList<Extension> availableSet = new ArrayList<Extension>();
        int i = 0;
        while (i < manifests.length) {
            Extension[] available = Extension.getRequired((Manifest)manifests[i]);
            int j = 0;
            while (j < available.length) {
                availableSet.add(available[j]);
                ++j;
            }
            ++i;
        }
        return availableSet.toArray(new Extension[0]);
    }

    private Manifest[] getManifests(String[] classPath) throws Exception {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        int i = 0;
        while (i < classPath.length) {
            String element = classPath[i];
            if (element.endsWith(".jar")) {
                try {
                    URL url = new URL("jar:" + element + "!/");
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    Manifest manifest = connection.getManifest();
                    manifests.add(manifest);
                }
                catch (IOException ioe) {
                    String message = REZ.getString("bad-classpath-entry", (Object)element);
                    this.getLogger().warn(message);
                    throw new Exception(message);
                }
            }
            ++i;
        }
        return manifests.toArray(new Manifest[0]);
    }

    private Policy configurePolicy(Configuration configuration, File baseDirectory) throws ConfigurationException {
        DefaultPolicy policy = new DefaultPolicy(baseDirectory);
        policy.enableLogging(this.getLogger());
        policy.configure(configuration);
        return policy;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

