/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.property.PropertyUtil;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.phoenix.components.classloader.AbstractPolicy;

class DefaultPolicy
extends AbstractPolicy
implements Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$classloader$DefaultPolicy != null ? class$Lorg$apache$avalon$phoenix$components$classloader$DefaultPolicy : (class$Lorg$apache$avalon$phoenix$components$classloader$DefaultPolicy = DefaultPolicy.class$("org.apache.avalon.phoenix.components.classloader.DefaultPolicy"))));
    private DefaultContext m_context = new DefaultContext((Map)System.getProperties());
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$classloader$DefaultPolicy;
    private static /* synthetic */ Class class$Ljava$lang$String;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.setupDefaultPermissions();
        Configuration[] keyStoreConfigurations = configuration.getChildren("keystore");
        HashMap keyStores = this.configureKeyStores(keyStoreConfigurations);
        Configuration[] grants = configuration.getChildren("grant");
        if (grants.length != 0) {
            this.configureGrants(grants, keyStores);
        } else {
            String message = REZ.getString("policy.notice.full-perms");
            this.getLogger().info(message);
            Permissions permissions = this.createPermissionSetFor(this.getInclusiveURL(), null);
            permissions.add(new AllPermission());
        }
    }

    private URL getInclusiveURL() {
        try {
            return new URL("file:/-");
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private void setupDefaultPermissions() {
        Permissions permissions = this.createPermissionSetFor(this.getInclusiveURL(), null);
        permissions.add(new PropertyPermission("os.name", "read"));
        permissions.add(new PropertyPermission("os.arch", "read"));
        permissions.add(new PropertyPermission("os.version", "read"));
        permissions.add(new PropertyPermission("file.separator", "read"));
        permissions.add(new PropertyPermission("path.separator", "read"));
        permissions.add(new PropertyPermission("line.separator", "read"));
        permissions.add(new PropertyPermission("java.version", "read"));
        permissions.add(new PropertyPermission("java.vendor", "read"));
        permissions.add(new PropertyPermission("java.vendor.url", "read"));
        permissions.add(new PropertyPermission("java.class.version", "read"));
        permissions.add(new PropertyPermission("java.vm.version", "read"));
        permissions.add(new PropertyPermission("java.vm.vendor", "read"));
        permissions.add(new PropertyPermission("java.vm.name", "read"));
        permissions.add(new PropertyPermission("java.specification.version", "read"));
        permissions.add(new PropertyPermission("java.specification.vendor", "read"));
        permissions.add(new PropertyPermission("java.specification.name", "read"));
        permissions.add(new PropertyPermission("java.vm.specification.version", "read"));
        permissions.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        permissions.add(new PropertyPermission("java.vm.specification.name", "read"));
    }

    private HashMap configureKeyStores(Configuration[] configurations) throws ConfigurationException {
        HashMap<String, KeyStore> keyStores = new HashMap<String, KeyStore>();
        int i = 0;
        while (i < configurations.length) {
            Configuration configuration = configurations[i];
            String type = configuration.getAttribute("type");
            String location = configuration.getAttribute("location");
            String name = configuration.getAttribute("name");
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                URL url = new URL(location);
                InputStream ins = url.openStream();
                keyStore.load(ins, null);
                keyStores.put(name, keyStore);
            }
            catch (Exception e) {
                String message = REZ.getString("policy.error.keystore.config", (Object)name);
                throw new ConfigurationException(message, (Throwable)e);
            }
            ++i;
        }
        return keyStores;
    }

    private void configureGrants(Configuration[] configurations, HashMap keyStores) throws ConfigurationException {
        int i = 0;
        while (i < configurations.length) {
            this.configureGrant(configurations[i], keyStores);
            ++i;
        }
    }

    private void configureGrant(Configuration configuration, HashMap keyStores) throws ConfigurationException {
        String signedBy = configuration.getAttribute("signed-by", null);
        String keyStoreName = configuration.getAttribute("key-store", null);
        String codeBase = configuration.getAttribute("code-base", null);
        if (codeBase != null) {
            codeBase = this.expand(codeBase);
        }
        Certificate[] signers = this.getSigners(signedBy, keyStoreName, keyStores);
        Permissions permissions = null;
        try {
            permissions = this.createPermissionSetFor(codeBase, signers);
        }
        catch (MalformedURLException mue) {
            String message = REZ.getString("policy.error.codebase.malformed", (Object)codeBase);
            throw new ConfigurationException(message, (Throwable)mue);
        }
        this.configurePermissions(configuration.getChildren("permission"), permissions, keyStores);
    }

    private void configurePermissions(Configuration[] configurations, Permissions permissions, HashMap keyStores) throws ConfigurationException {
        int i = 0;
        while (i < configurations.length) {
            this.configurePermission(configurations[i], permissions, keyStores);
            ++i;
        }
    }

    private void configurePermission(Configuration configuration, Permissions permissions, HashMap keyStores) throws ConfigurationException {
        String type = configuration.getAttribute("class");
        String actions = configuration.getAttribute("actions", null);
        String signedBy = configuration.getAttribute("signed-by", null);
        String keyStoreName = configuration.getAttribute("key-store", null);
        String target = configuration.getAttribute("target", null);
        if (target != null) {
            target = this.expand(target);
        }
        Certificate[] signers = this.getSigners(signedBy, keyStoreName, keyStores);
        Permission permission = this.createPermission(type, target, actions, signers);
        permissions.add(permission);
    }

    private String expand(String value) throws ConfigurationException {
        try {
            Object resolvedValue = PropertyUtil.resolveProperty((String)value, (Context)this.m_context, (boolean)false);
            return resolvedValue.toString();
        }
        catch (Exception e) {
            String message = REZ.getString("policy.error.property.resolve", (Object)value);
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    private Permission createPermission(String type, String target, String actions, Certificate[] signers) throws ConfigurationException {
        if (signers != null) {
            return this.createUnresolvedPermission(type, target, actions, signers);
        }
        try {
            Class<?> c = Class.forName(type);
            Class[] paramClasses = null;
            Object[] params = null;
            if (actions == null && target == null) {
                paramClasses = new Class[]{};
                params = new Object[]{};
            } else if (actions == null) {
                paramClasses = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = DefaultPolicy.class$("java.lang.String"))};
                params = new Object[]{target};
            } else {
                paramClasses = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = DefaultPolicy.class$("java.lang.String")), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = DefaultPolicy.class$("java.lang.String"))};
                params = new Object[]{target, actions};
            }
            Constructor<?> constructor = c.getConstructor(paramClasses);
            Object o = constructor.newInstance(params);
            return (Permission)o;
        }
        catch (ClassNotFoundException cnfe) {
            return this.createUnresolvedPermission(type, target, actions, signers);
        }
        catch (Exception e) {
            String message = REZ.getString("policy.error.permission.create", (Object)type);
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    private Permission createUnresolvedPermission(String type, String target, String actions, Certificate[] signers) {
        return new UnresolvedPermission(type, target, actions, signers);
    }

    private Certificate[] getSigners(String signedBy, String keyStoreName, HashMap keyStores) throws ConfigurationException {
        if (signedBy != null && keyStoreName == null) {
            keyStoreName = "default";
        }
        Certificate[] signers = null;
        if (signedBy != null) {
            signers = this.getCertificates(signedBy, keyStoreName, keyStores);
        }
        return signers;
    }

    private Certificate[] getCertificates(String signedBy, String keyStoreName, HashMap keyStores) throws ConfigurationException {
        KeyStore keyStore = (KeyStore)keyStores.get(keyStoreName);
        if (keyStore == null) {
            String message = REZ.getString("policy.error.keystore.aquire", (Object)keyStoreName);
            throw new ConfigurationException(message);
        }
        ArrayList<Certificate> certificateSet = new ArrayList<Certificate>();
        StringTokenizer tokenizer = new StringTokenizer(signedBy, ",");
        while (tokenizer.hasMoreTokens()) {
            String alias = tokenizer.nextToken().trim();
            Certificate certificate = null;
            try {
                certificate = keyStore.getCertificate(alias);
            }
            catch (KeyStoreException kse) {
                String message = REZ.getString("policy.error.certificate.aquire", (Object)alias);
                throw new ConfigurationException(message, (Throwable)kse);
            }
            if (certificate == null) {
                String message = REZ.getString("policy.error.alias.missing", (Object)alias, (Object)keyStoreName);
                throw new ConfigurationException(message);
            }
            if (certificateSet.contains(certificate)) continue;
            certificateSet.add(certificate);
        }
        return certificateSet.toArray(new Certificate[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected DefaultPolicy(File baseDirectory) {
        this.m_context.put((Object)"/", (Object)File.separator);
        this.m_context.put((Object)"app.home", (Object)baseDirectory);
    }
}

