/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

class PolicyClassLoader
extends URLClassLoader
implements LogEnabled {
    private final Policy m_policy;
    private final URLStreamHandlerFactory m_factory;
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected void addURL(URL url) {
        super.addURL(url);
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getPermissions(" + codeSource + ")");
        }
        return this.m_policy.getPermissions(codeSource);
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("findResources(" + name + ")");
        }
        return super.findResources(name);
    }

    public URL findResource(String name) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("findResource(" + name + ")");
        }
        URL url = super.findResource(name);
        if (this.getLogger().isDebugEnabled()) {
            if (url != null) {
                this.getLogger().debug("Resource " + name + " located (" + url + ")");
            } else {
                this.getLogger().debug("Resource " + name + " not located");
            }
        }
        return url;
    }

    private URL[] createURLs(String[] classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        int i = 0;
        while (i < classPath.length) {
            URL url = this.createURL(classPath[i]);
            urls.add(url);
            ++i;
        }
        return urls.toArray(new URL[0]);
    }

    private URL createURL(String url) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("url");
        }
        String scheme = this.parseScheme(url);
        URLStreamHandler handler = this.createHandler(scheme);
        return new URL(null, url, handler);
    }

    private URLStreamHandler createHandler(String scheme) throws MalformedURLException {
        if (this.m_factory != null) {
            return this.m_factory.createURLStreamHandler(scheme);
        }
        return null;
    }

    private String parseScheme(String url) throws MalformedURLException {
        int index = url.indexOf(58);
        if (-1 == index) {
            throw new MalformedURLException("No scheme specified for url " + url);
        }
        return url.substring(0, index);
    }

    PolicyClassLoader(String[] urls, ClassLoader parent, URLStreamHandlerFactory factory, Policy policy) throws MalformedURLException {
        super(new URL[0], parent, factory);
        if (policy == null) {
            throw new NullPointerException("policy");
        }
        this.m_policy = policy;
        this.m_factory = factory;
        int i = 0;
        while (i < urls.length) {
            URL url = this.createURL(urls[i]);
            this.addURL(url);
            ++i;
        }
    }
}

