/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.deployer;

import java.io.File;
import java.net.URL;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ClassLoaderManager;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.interfaces.Deployer;
import org.apache.avalon.phoenix.interfaces.DeploymentException;
import org.apache.avalon.phoenix.interfaces.DeploymentRecorder;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.LogManager;
import org.apache.avalon.phoenix.metadata.BlockListenerMetaData;
import org.apache.avalon.phoenix.metadata.BlockMetaData;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.avalon.phoenix.tools.assembler.Assembler;
import org.apache.avalon.phoenix.tools.assembler.AssemblyException;
import org.apache.avalon.phoenix.tools.installer.Installation;
import org.apache.avalon.phoenix.tools.installer.Installer;
import org.apache.avalon.phoenix.tools.verifier.SarVerifier;
import org.apache.log.Hierarchy;

public class DefaultDeployer
extends AbstractLogEnabled
implements Deployer,
Composable,
Initializable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$deployer$DefaultDeployer != null ? class$Lorg$apache$avalon$phoenix$components$deployer$DefaultDeployer : (class$Lorg$apache$avalon$phoenix$components$deployer$DefaultDeployer = DefaultDeployer.class$("org.apache.avalon.phoenix.components.deployer.DefaultDeployer"))));
    private final DefaultConfigurationBuilder m_builder = new DefaultConfigurationBuilder();
    private final Assembler m_assembler = new Assembler();
    private final SarVerifier m_verifier = new SarVerifier();
    private final Installer m_installer = new Installer();
    private LogManager m_logManager;
    private Kernel m_kernel;
    private ConfigurationRepository m_repository;
    private ClassLoaderManager m_classLoaderManager;
    private DeploymentRecorder m_recorder;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$deployer$DefaultDeployer;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_kernel = (Kernel)componentManager.lookup("org.apache.avalon.phoenix.interfaces.Kernel");
        this.m_repository = (ConfigurationRepository)componentManager.lookup("org.apache.avalon.phoenix.interfaces.ConfigurationRepository");
        this.m_classLoaderManager = (ClassLoaderManager)componentManager.lookup("org.apache.avalon.phoenix.interfaces.ClassLoaderManager");
        this.m_logManager = (LogManager)componentManager.lookup("org.apache.avalon.phoenix.interfaces.LogManager");
        this.m_recorder = (DeploymentRecorder)componentManager.lookup("org.apache.avalon.phoenix.interfaces.DeploymentRecorder");
    }

    public void initialize() throws Exception {
        this.setupLogger(this.m_installer);
        this.setupLogger(this.m_assembler);
        this.setupLogger(this.m_verifier);
    }

    public void undeploy(String name) throws DeploymentException {
        try {
            Application application = this.m_kernel.getApplication(name);
            String[] blocks = application.getBlockNames();
            this.m_kernel.removeApplication(name);
            int i = 0;
            while (i < blocks.length) {
                this.m_repository.storeConfiguration(name, blocks[i], null);
                ++i;
            }
            Installation installation = this.m_recorder.fetchInstallation(name);
            this.m_installer.uninstall(installation);
            this.m_recorder.recordInstallation(name, null);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deploy(String name, URL location) throws DeploymentException {
        try {
            Installation installation = this.m_recorder.fetchInstallation(name);
            if (installation == null) {
                installation = this.m_installer.install(location);
                this.m_recorder.recordInstallation(name, installation);
            }
            Configuration config = this.getConfigurationFor(installation.getConfig());
            Configuration server = this.getConfigurationFor(installation.getEnvironment());
            Configuration assembly = this.getConfigurationFor(installation.getAssembly());
            File directory = installation.getDirectory();
            ClassLoader classLoader = this.m_classLoaderManager.createClassLoader(server, installation.getSource(), directory, installation.getClassPath());
            SarMetaData metaData = this.m_assembler.assembleSar(name, assembly, directory, classLoader);
            this.m_verifier.verifySar(metaData, classLoader);
            this.setupConfiguration(name, metaData, config.getChildren());
            Configuration logs = server.getChild("logs");
            Hierarchy hierarchy = this.m_logManager.createHierarchy(metaData, logs);
            this.m_kernel.addApplication(metaData, classLoader, hierarchy, server);
            String message = REZ.getString("deploy.notice.sar.add", (Object)name, (Object)installation.getClassPath());
            this.getLogger().debug(message);
        }
        catch (DeploymentException de) {
            void ae;
            throw ae;
        }
        catch (AssemblyException ae) {
            throw new DeploymentException(ae.getMessage(), ae);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    private Configuration getConfigurationFor(String location) throws DeploymentException {
        try {
            return this.m_builder.build(location);
        }
        catch (Exception e) {
            String message = REZ.getString("deploy.error.config.create", (Object)location);
            throw new DeploymentException(message, e);
        }
    }

    private void setupConfiguration(String appName, SarMetaData metaData, Configuration[] configurations) throws DeploymentException {
        int i = 0;
        while (i < configurations.length) {
            Configuration configuration = configurations[i];
            String name = configuration.getName();
            if (!this.hasBlock(name, metaData.getBlocks()) && !this.hasBlockListener(name, metaData.getListeners())) {
                String message = REZ.getString("deploy.error.extra.config", (Object)name);
                throw new DeploymentException(message);
            }
            try {
                this.m_repository.storeConfiguration(appName, name, configuration);
            }
            catch (ConfigurationException ce) {
                throw new DeploymentException(ce.getMessage(), ce);
            }
            ++i;
        }
    }

    private boolean hasBlock(String name, BlockMetaData[] blocks) {
        int i = 0;
        while (i < blocks.length) {
            String other = blocks[i].getName();
            if (other.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasBlockListener(String name, BlockListenerMetaData[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

