/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.deployer;

import java.io.File;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.interfaces.DeploymentException;
import org.apache.avalon.phoenix.interfaces.DeploymentRecorder;
import org.apache.avalon.phoenix.tools.installer.FileDigest;
import org.apache.avalon.phoenix.tools.installer.Installation;

public class PersistentDeploymentRecorder
extends AbstractLogEnabled
implements DeploymentRecorder {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$deployer$PersistentDeploymentRecorder != null ? class$Lorg$apache$avalon$phoenix$components$deployer$PersistentDeploymentRecorder : (class$Lorg$apache$avalon$phoenix$components$deployer$PersistentDeploymentRecorder = PersistentDeploymentRecorder.class$("org.apache.avalon.phoenix.components.deployer.PersistentDeploymentRecorder"))));
    private static final String PHOENIX_HOME = System.getProperty("phoenix.home", "..");
    private static final String VAR_PATH = PHOENIX_HOME + File.separator + "conf" + File.separator + "installs";
    private static final String DIGEST_SUFFIX = "install.log";
    private static final String SOURCE = "source";
    private static final String DIRECTORY = "directory";
    private static final String CONFIG = "config";
    private static final String ASSEMBLY = "assembly";
    private static final String ENVIRONMENT = "environment";
    private static final String CLASSPATH = "classpath";
    private static final String PATH = "path";
    private static final String URL = "url";
    private static final String DIGESTS = "digests";
    private static final String DIGEST = "digest";
    private static final String TIMESTAMP = "timestamp";
    private static final String FILE = "file";
    private static final String CHECKSUM = "checksum";
    private final DefaultConfigurationBuilder m_builder = new DefaultConfigurationBuilder();
    private final DefaultConfigurationSerializer m_serializer = new DefaultConfigurationSerializer();
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$deployer$PersistentDeploymentRecorder;

    public synchronized void recordInstallation(String name, Installation installation) throws DeploymentException {
        File file = this.getDigestFile(name);
        if (installation == null) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        try {
            DefaultConfiguration configuration = new DefaultConfiguration("installation", null);
            configuration.setAttribute(SOURCE, installation.getSource().getCanonicalPath());
            configuration.setAttribute(DIRECTORY, installation.getDirectory().getCanonicalPath());
            configuration.setAttribute(CONFIG, installation.getConfig());
            configuration.setAttribute(ASSEMBLY, installation.getAssembly());
            configuration.setAttribute(ENVIRONMENT, installation.getEnvironment());
            configuration.setAttribute(TIMESTAMP, Long.toString(installation.getTimestamp()));
            DefaultConfiguration classpath = new DefaultConfiguration(CLASSPATH, null);
            String[] urls = installation.getClassPath();
            int i = 0;
            while (i < urls.length) {
                DefaultConfiguration path = new DefaultConfiguration(PATH, null);
                path.setAttribute(URL, urls[i]);
                classpath.addChild((Configuration)path);
                ++i;
            }
            configuration.addChild((Configuration)classpath);
            DefaultConfiguration digests = new DefaultConfiguration(DIGESTS, null);
            FileDigest[] fileDigests = installation.getFileDigests();
            int i2 = 0;
            while (i2 < fileDigests.length) {
                DefaultConfiguration digest = new DefaultConfiguration(DIGEST, null);
                digest.setAttribute(FILE, fileDigests[i2].getFile().getCanonicalPath());
                digest.setAttribute(CHECKSUM, String.valueOf(fileDigests[i2].getChecksum()));
                digests.addChild((Configuration)digest);
                ++i2;
            }
            configuration.addChild((Configuration)digests);
            File var = new File(VAR_PATH);
            if (!var.exists()) {
                var.mkdirs();
            }
            this.m_serializer.serializeToFile(file, (Configuration)configuration);
            String message = REZ.getString("recorder.notice.persist.successful", (Object)name, (Object)file);
            this.getLogger().debug(message);
        }
        catch (Exception e) {
            String message = REZ.getString("recorder.warn.persist.failed", (Object)name);
            this.getLogger().warn(message, (Throwable)e);
            file.delete();
        }
    }

    public synchronized Installation fetchInstallation(String name) throws DeploymentException {
        File file = this.getDigestFile(name);
        if (!file.exists()) {
            return null;
        }
        try {
            Configuration configuration = this.m_builder.buildFromFile(file);
            File source = new File(configuration.getAttribute(SOURCE));
            File directory = new File(configuration.getAttribute(DIRECTORY));
            String config = configuration.getAttribute(CONFIG);
            String assembly = configuration.getAttribute(ASSEMBLY);
            String environment = configuration.getAttribute(ENVIRONMENT);
            long timestamp = configuration.getAttributeAsLong(TIMESTAMP);
            Configuration[] paths = configuration.getChild(CLASSPATH, true).getChildren(PATH);
            String[] classPath = new String[paths.length];
            int i = 0;
            while (i < paths.length) {
                classPath[i] = paths[i].getAttribute(URL);
                ++i;
            }
            Configuration[] digests = configuration.getChild(DIGESTS, true).getChildren(DIGEST);
            FileDigest[] fileDigests = new FileDigest[digests.length];
            int i2 = 0;
            while (i2 < digests.length) {
                File installedFile = new File(digests[i2].getAttribute(FILE));
                long checksum = digests[i2].getAttributeAsLong(CHECKSUM);
                FileDigest fileDigest = new FileDigest(installedFile, checksum);
                ++i2;
            }
            String message = REZ.getString("recorder.notice.rebuild.successful", (Object)name, (Object)file);
            this.getLogger().debug(message);
            return new Installation(source, directory, config, assembly, environment, classPath, fileDigests, timestamp);
        }
        catch (Exception e) {
            String message = REZ.getString("recorder.warn.rebuild.failed", (Object)name);
            this.getLogger().warn(message, (Throwable)e);
            return null;
        }
    }

    private File getDigestFile(String name) {
        return new File(VAR_PATH, name + "-" + DIGEST_SUFFIX);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

