/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.embeddor;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.io.ExtensionFileFilter;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.DefaultComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.interfaces.ClassLoaderManager;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.interfaces.Deployer;
import org.apache.avalon.phoenix.interfaces.DeploymentRecorder;
import org.apache.avalon.phoenix.interfaces.Embeddor;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.LogManager;
import org.apache.avalon.phoenix.interfaces.PackageRepository;
import org.apache.avalon.phoenix.interfaces.SystemManager;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;

public class DefaultEmbeddor
extends AbstractLogEnabled
implements Embeddor,
Parameterizable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor != null ? class$Lorg$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor : (class$Lorg$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor = DefaultEmbeddor.class$("org.apache.avalon.phoenix.components.embeddor.DefaultEmbeddor"))));
    private static final String DEFAULT_LOG_FILE = "/logs/phoenix.log";
    private static final String DEFAULT_APPS_PATH = "/apps";
    private static final String DEFAULT_FORMAT = "%{time} [%7.7{priority}] (%{category}): %{message}\\n%{throwable}";
    private Parameters m_parameters;
    private String m_phoenixHome;
    private ClassLoaderManager m_classLoaderManager;
    private ConfigurationRepository m_repository;
    private Kernel m_kernel;
    private Deployer m_deployer;
    private DeploymentRecorder m_recorder;
    private LogManager m_logManager;
    private SystemManager m_systemManager;
    private PackageRepository m_packageRepository;
    private boolean m_shutdown;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$embeddor$DefaultEmbeddor;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$PackageRepository;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$ConfigurationRepository;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$LogManager;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$ClassLoaderManager;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$Deployer;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$DeploymentRecorder;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$SystemManager;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$Kernel;

    public synchronized void parameterize(Parameters parameters) throws ParameterException {
        this.m_parameters = this.createDefaultParameters();
        this.m_parameters.merge(parameters);
        this.m_phoenixHome = this.m_parameters.getParameter("phoenix.home");
    }

    public synchronized void initialize() throws Exception {
        try {
            this.createComponents();
            this.setupComponent(this.m_packageRepository, "packages");
            this.setupComponent(this.m_logManager, "logs");
            this.setupComponent(this.m_classLoaderManager, "classes");
            this.setupComponent(this.m_repository, "config");
            this.setupComponent(this.m_deployer, "deployer");
            this.setupComponent(this.m_recorder, "recorder");
            this.setupComponent(this.m_systemManager, "manager");
            this.setupComponent(this.m_kernel, "kernel");
        }
        catch (Exception e) {
            String message = REZ.getString("embeddor.error.start.failed");
            this.getLogger().fatalError(message, (Throwable)e);
            throw e;
        }
    }

    public void execute() throws Exception {
        this.deployDefaultApplications();
        while (!this.m_shutdown) {
            try {
                DefaultEmbeddor defaultEmbeddor = this;
                synchronized (defaultEmbeddor) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void dispose() {
        this.shutdown();
        try {
            this.shutdownComponent(this.m_systemManager);
            this.shutdownComponent(this.m_recorder);
            this.shutdownComponent(this.m_deployer);
            this.shutdownComponent(this.m_kernel);
            this.shutdownComponent(this.m_repository);
            this.shutdownComponent(this.m_logManager);
            this.shutdownComponent(this.m_classLoaderManager);
            this.shutdownComponent(this.m_packageRepository);
        }
        catch (Exception e) {
            String message = REZ.getString("embeddor.error.shutdown.failed");
            this.getLogger().fatalError(message, (Throwable)e);
        }
        this.m_packageRepository = null;
        this.m_systemManager = null;
        this.m_kernel = null;
        this.m_repository = null;
        this.m_classLoaderManager = null;
        this.m_logManager = null;
        this.m_deployer = null;
        System.gc();
    }

    public void shutdown() {
        this.m_shutdown = true;
        DefaultEmbeddor defaultEmbeddor = this;
        synchronized (defaultEmbeddor) {
            this.notifyAll();
        }
    }

    private synchronized void createComponents() throws Exception {
        org.apache.avalon.framework.logger.Logger logger = this.createLogger();
        this.enableLogging(logger);
        String component = null;
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.components.classloader.PackageRepository");
        this.m_packageRepository = (PackageRepository)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$PackageRepository != null ? class$Lorg$apache$avalon$phoenix$interfaces$PackageRepository : (class$Lorg$apache$avalon$phoenix$interfaces$PackageRepository = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.PackageRepository")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.ConfigurationRepository");
        this.m_repository = (ConfigurationRepository)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$ConfigurationRepository != null ? class$Lorg$apache$avalon$phoenix$interfaces$ConfigurationRepository : (class$Lorg$apache$avalon$phoenix$interfaces$ConfigurationRepository = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.ConfigurationRepository")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.LogManager");
        this.m_logManager = (LogManager)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$LogManager != null ? class$Lorg$apache$avalon$phoenix$interfaces$LogManager : (class$Lorg$apache$avalon$phoenix$interfaces$LogManager = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.LogManager")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.ClassLoaderManager");
        this.m_classLoaderManager = (ClassLoaderManager)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$ClassLoaderManager != null ? class$Lorg$apache$avalon$phoenix$interfaces$ClassLoaderManager : (class$Lorg$apache$avalon$phoenix$interfaces$ClassLoaderManager = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.ClassLoaderManager")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.Deployer");
        this.m_deployer = (Deployer)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$Deployer != null ? class$Lorg$apache$avalon$phoenix$interfaces$Deployer : (class$Lorg$apache$avalon$phoenix$interfaces$Deployer = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.Deployer")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.DeploymentRecorder");
        this.m_recorder = (DeploymentRecorder)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$DeploymentRecorder != null ? class$Lorg$apache$avalon$phoenix$interfaces$DeploymentRecorder : (class$Lorg$apache$avalon$phoenix$interfaces$DeploymentRecorder = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.DeploymentRecorder")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.SystemManager");
        this.m_systemManager = (SystemManager)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$SystemManager != null ? class$Lorg$apache$avalon$phoenix$interfaces$SystemManager : (class$Lorg$apache$avalon$phoenix$interfaces$SystemManager = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.SystemManager")));
        component = this.m_parameters.getParameter("org.apache.avalon.phoenix.interfaces.Kernel");
        this.m_kernel = (Kernel)this.createComponent(component, class$Lorg$apache$avalon$phoenix$interfaces$Kernel != null ? class$Lorg$apache$avalon$phoenix$interfaces$Kernel : (class$Lorg$apache$avalon$phoenix$interfaces$Kernel = DefaultEmbeddor.class$("org.apache.avalon.phoenix.interfaces.Kernel")));
    }

    private org.apache.avalon.framework.logger.Logger createLogger() throws Exception {
        String logDestination = this.m_parameters.getParameter("log-destination", this.m_phoenixHome + DEFAULT_LOG_FILE);
        String logPriority = this.m_parameters.getParameter("log-priority", "INFO");
        AvalonFormatter formatter = new AvalonFormatter(DEFAULT_FORMAT);
        File file = new File(logDestination);
        FileTarget logTarget = new FileTarget(file, false, (Formatter)formatter);
        Hierarchy hierarchy = new Hierarchy();
        Logger logger = hierarchy.getLoggerFor("Phoenix");
        logger.setLogTargets(new LogTarget[]{logTarget});
        logger.setPriority(Priority.getPriorityForName((String)logPriority));
        logger.info("Logger started");
        return new LogKitLogger(logger);
    }

    protected void deployDefaultApplications() throws Exception {
        ExtensionFileFilter filter;
        File directory;
        File[] files;
        String defaultAppsLocation;
        String application = this.m_parameters.getParameter("application-location", null);
        if (application != null) {
            File file = new File(application);
            this.deployFile(file);
        }
        if ((defaultAppsLocation = this.m_parameters.getParameter("applications-directory", this.m_phoenixHome + DEFAULT_APPS_PATH)) != null && (files = (directory = new File(defaultAppsLocation)).listFiles((FilenameFilter)(filter = new ExtensionFileFilter(".sar")))) != null) {
            this.deployFiles(files);
        }
    }

    private void deployFiles(File[] files) throws Exception {
        int i = 0;
        while (i < files.length) {
            this.deployFile(files[i]);
            ++i;
        }
    }

    private void deployFile(File file) throws Exception {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            index = filename.length();
        }
        String name = filename.substring(0, index);
        File canonicalFile = file.getCanonicalFile();
        this.deployFile(name, canonicalFile);
    }

    protected final synchronized void deployFile(String name, File file) throws Exception {
        this.m_deployer.deploy(name, file.toURL());
    }

    private void setupComponent(Component component, String loggerName) throws Exception {
        this.setupLogger(component, loggerName);
        if (component instanceof Composable) {
            ComponentManager componentManager = this.getComponentManager();
            ((Composable)component).compose(componentManager);
        }
        if (component instanceof Parameterizable) {
            ((Parameterizable)component).parameterize(this.m_parameters);
        }
        if (component instanceof Initializable) {
            ((Initializable)component).initialize();
        }
        if (component instanceof Startable) {
            ((Startable)component).start();
        }
    }

    private void shutdownComponent(Component component) throws Exception {
        if (component == null) {
            return;
        }
        if (component instanceof Startable) {
            ((Startable)component).stop();
        }
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object createComponent(String component, Class clazz) throws Exception {
        try {
            void iae;
            Object object = Class.forName(component).newInstance();
            if (!clazz.isInstance(object)) {
                String message = REZ.getString("bad-type.error", (Object)component, (Object)clazz.getName());
                throw new Exception(message);
            }
            return iae;
        }
        catch (IllegalAccessException iae) {
            String message = REZ.getString("bad-ctor.error", (Object)clazz.getName(), (Object)component);
            throw new CascadingException(message, (Throwable)iae);
        }
        catch (InstantiationException ie) {
            String message = REZ.getString("no-instantiate.error", (Object)clazz.getName(), (Object)component);
            throw new CascadingException(message, (Throwable)ie);
        }
        catch (ClassNotFoundException cnfe) {
            String message = REZ.getString("no-class.error", (Object)clazz.getName(), (Object)component);
            throw new CascadingException(message, (Throwable)cnfe);
        }
    }

    private ComponentManager getComponentManager() {
        DefaultComponentManager componentManager = new DefaultComponentManager();
        componentManager.put("org.apache.avalon.phoenix.interfaces.Embeddor", (Component)this);
        componentManager.put("org.apache.avalon.phoenix.interfaces.LogManager", (Component)this.m_logManager);
        componentManager.put("org.apache.avalon.phoenix.components.classloader.PackageRepository", (Component)this.m_packageRepository);
        componentManager.put("org.apache.avalon.phoenix.interfaces.ClassLoaderManager", (Component)this.m_classLoaderManager);
        componentManager.put("org.apache.avalon.phoenix.interfaces.ConfigurationRepository", (Component)this.m_repository);
        componentManager.put("org.apache.avalon.phoenix.interfaces.Deployer", (Component)this.m_deployer);
        componentManager.put("org.apache.avalon.phoenix.interfaces.DeploymentRecorder", (Component)this.m_recorder);
        componentManager.put("org.apache.avalon.phoenix.interfaces.SystemManager", (Component)this.m_systemManager);
        componentManager.put("org.apache.avalon.phoenix.interfaces.Kernel", (Component)this.m_kernel);
        return componentManager;
    }

    protected Parameters createDefaultParameters() {
        Parameters defaults = new Parameters();
        defaults.setParameter("phoenix.home", "..");
        String PREFIX = "org.apache.avalon.phoenix.components.";
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.Deployer", "org.apache.avalon.phoenix.components." + "deployer.DefaultDeployer");
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.DeploymentRecorder", "org.apache.avalon.phoenix.components." + "deployer.DefaultDeploymentRecorder");
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.LogManager", "org.apache.avalon.phoenix.components." + "logger.DefaultLogManager");
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.Kernel", "org.apache.avalon.phoenix.components." + "kernel.DefaultKernel");
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.SystemManager", "org.apache.avalon.phoenix.components." + "manager.NoopSystemManager");
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.ConfigurationRepository", "org.apache.avalon.phoenix.components." + "configuration.DefaultConfigurationRepository");
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.ClassLoaderManager", "org.apache.avalon.phoenix.components." + "classloader.DefaultClassLoaderManager");
        defaults.setParameter("org.apache.avalon.phoenix.components.classloader.PackageRepository", "org.apache.avalon.phoenix.components." + "extensions.PhoenixPackageRepository");
        return defaults;
    }

    protected final Kernel getKernel() {
        return this.m_kernel;
    }

    protected final Parameters getParameters() {
        return this.m_parameters;
    }

    private Configuration getConfigurationFor(String location) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        return builder.buildFromFile(location);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

