/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.embeddor;

import java.io.File;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.Block;
import org.apache.avalon.phoenix.components.embeddor.DefaultEmbeddor;
import org.apache.avalon.phoenix.interfaces.Application;

public class SingleAppEmbeddor
extends DefaultEmbeddor
implements ComponentManager {
    private Application m_application;

    protected Parameters createDefaultParameters() {
        Parameters defaults = super.createDefaultParameters();
        String PREFIX = "org.apache.avalon.phoenix.components.";
        defaults.setParameter("org.apache.avalon.phoenix.interfaces.ClassLoaderManager", "org.apache.avalon.phoenix.components." + "classloader.ContextClassLoaderManager");
        defaults.setParameter("org.apache.avalon.phoenix.components.classloader.PackageRepository", "org.apache.avalon.phoenix.components." + "extensions.NoopPackageRepository");
        return defaults;
    }

    protected void deployDefaultApplications() throws Exception {
        String applicationName = this.getParameters().getParameter("application-name", "default");
        String applicationLocation = this.getParameters().getParameter("application-location");
        File directory = new File(applicationLocation);
        this.deployFile(applicationName, directory);
        this.m_application = this.getKernel().getApplication(applicationName);
    }

    public String[] list() {
        return this.m_application.getBlockNames();
    }

    public Component lookup(String role) throws ComponentException {
        Block component = this.m_application.getBlock(role);
        if (component == null) {
            throw new ComponentException("Unable to get reference to component " + role);
        }
        return component;
    }

    public boolean hasComponent(String role) {
        return this.m_application.getBlock(role) != null;
    }

    public void release(Component component) {
    }
}

