/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.extensions;

import java.io.File;
import org.apache.avalon.excalibur.extension.DefaultPackageRepository;
import org.apache.avalon.excalibur.util.StringUtil;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.interfaces.PackageRepository;

public class PhoenixPackageRepository
extends DefaultPackageRepository
implements LogEnabled,
Parameterizable,
Initializable,
Disposable,
PackageRepository {
    private Logger m_logger;
    private String m_path;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        String phoenixHome = parameters.getParameter("phoenix.home");
        String defaultExtPath = phoenixHome + File.separator + "ext";
        this.m_path = parameters.getParameter("phoenix.ext.path", defaultExtPath);
    }

    public void initialize() throws Exception {
        String[] pathElements = StringUtil.split((String)this.m_path, (String)"|");
        File[] dirs = new File[pathElements.length];
        int i = 0;
        while (i < dirs.length) {
            dirs[i] = new File(pathElements[i]);
            ++i;
        }
        this.setPath(dirs);
        this.scanPath();
    }

    public void dispose() {
        this.clearCache();
    }

    protected void debug(String message) {
        this.m_logger.debug(message);
    }

    public PhoenixPackageRepository() {
        super(new File[0]);
    }
}

