/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.kernel;

import java.util.HashMap;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.lang.DefaultThreadContextPolicy;
import org.apache.avalon.excalibur.lang.ThreadContext;
import org.apache.avalon.excalibur.lang.ThreadContextPolicy;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.excalibur.thread.impl.DefaultThreadPool;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

class DefaultApplicationContext
extends AbstractLogEnabled
implements ApplicationContext,
Composable,
Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$kernel$DefaultApplicationContext != null ? class$Lorg$apache$avalon$phoenix$components$kernel$DefaultApplicationContext : (class$Lorg$apache$avalon$phoenix$components$kernel$DefaultApplicationContext = DefaultApplicationContext.class$("org.apache.avalon.phoenix.components.kernel.DefaultApplicationContext"))));
    private HashMap m_threadPools = new HashMap();
    private Hierarchy m_hierarchy;
    private ClassLoader m_classLoader;
    private ThreadContext m_threadContext;
    private ConfigurationRepository m_repository;
    private SarMetaData m_metaData;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$kernel$DefaultApplicationContext;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_repository = (ConfigurationRepository)componentManager.lookup("org.apache.avalon.phoenix.interfaces.ConfigurationRepository");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] groups = configuration.getChild("threads").getChildren("thread-group");
        if (groups.length > 0) {
            String message = REZ.getString("frame.warn.thread-pools");
            this.getLogger().warn(message);
            System.err.println(message);
        }
        int i = 0;
        while (i < groups.length) {
            this.configureThreadPool(groups[i]);
            ++i;
        }
    }

    public SarMetaData getMetaData() {
        return this.m_metaData;
    }

    public ThreadContext getThreadContext() {
        return this.m_threadContext;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public Logger getLogger(String category) {
        return this.m_hierarchy.getLoggerFor(category);
    }

    public Configuration getConfiguration(String component) throws ConfigurationException {
        return this.m_repository.getConfiguration(this.m_metaData.getName(), component);
    }

    public ThreadPool getThreadPool(String name) {
        ThreadPool threadPool = (ThreadPool)this.m_threadPools.get(name);
        if (threadPool == null) {
            String message = REZ.getString("frame.error.thread.missing", (Object)name);
            throw new IllegalArgumentException(message);
        }
        return threadPool;
    }

    private void configureThreadPool(Configuration configuration) throws ConfigurationException {
        String name = configuration.getChild("name").getValue();
        int priority = configuration.getChild("priority").getValueAsInteger(5);
        boolean isDaemon = configuration.getChild("is-daemon").getValueAsBoolean(false);
        int minThreads = configuration.getChild("min-threads").getValueAsInteger(5);
        int maxThreads = configuration.getChild("max-threads").getValueAsInteger(10);
        int minSpareThreads = configuration.getChild("min-spare-threads").getValueAsInteger(maxThreads - minThreads);
        try {
            DefaultThreadPool threadPool = new DefaultThreadPool(name, maxThreads, this.m_threadContext);
            threadPool.setDaemon(isDaemon);
            threadPool.enableLogging(this.getLogger());
            this.m_threadPools.put(name, threadPool);
        }
        catch (Exception e) {
            String message = REZ.getString("frame.error.thread.create", (Object)name);
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected DefaultApplicationContext(SarMetaData metaData, ClassLoader classLoader, Hierarchy hierarchy) {
        this.m_metaData = metaData;
        this.m_classLoader = classLoader;
        this.m_hierarchy = hierarchy;
        DefaultThreadContextPolicy policy = new DefaultThreadContextPolicy();
        HashMap<String, ClassLoader> map = new HashMap<String, ClassLoader>(1);
        map.put("ContextClassLoader", this.m_classLoader);
        this.m_threadContext = new ThreadContext((ThreadContextPolicy)policy, map);
    }
}

