/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.kernel;

import java.util.HashMap;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.DefaultComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.components.application.DefaultApplication;
import org.apache.avalon.phoenix.components.kernel.DefaultApplicationContext;
import org.apache.avalon.phoenix.components.kernel.SarEntry;
import org.apache.avalon.phoenix.interfaces.Application;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.SystemManager;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.log.Hierarchy;

public class DefaultKernel
extends AbstractLogEnabled
implements Kernel,
Composable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$kernel$DefaultKernel != null ? class$Lorg$apache$avalon$phoenix$components$kernel$DefaultKernel : (class$Lorg$apache$avalon$phoenix$components$kernel$DefaultKernel = DefaultKernel.class$("org.apache.avalon.phoenix.components.kernel.DefaultKernel"))));
    private SystemManager m_systemManager;
    private ConfigurationRepository m_repository;
    private HashMap m_entrys = new HashMap();
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$kernel$DefaultKernel;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_systemManager = (SystemManager)componentManager.lookup("org.apache.avalon.phoenix.interfaces.SystemManager");
        this.m_repository = (ConfigurationRepository)componentManager.lookup("org.apache.avalon.phoenix.interfaces.ConfigurationRepository");
    }

    public void initialize() throws Exception {
    }

    public void dispose() {
        String[] names = this.getApplicationNames();
        int i = 0;
        while (i < names.length) {
            try {
                SarEntry entry = (SarEntry)this.m_entrys.get(names[i]);
                this.shutdown(entry);
            }
            catch (Exception e) {
                String message = REZ.getString("kernel.error.entry.dispose", (Object)names[i]);
                this.getLogger().warn(message, (Throwable)e);
            }
            ++i;
        }
    }

    public String[] getApplicationNames() {
        return this.m_entrys.keySet().toArray(new String[0]);
    }

    public Application getApplication(String name) {
        SarEntry entry = (SarEntry)this.m_entrys.get(name);
        if (entry == null) {
            return null;
        }
        return entry.getApplication();
    }

    private void startup(SarEntry entry) throws Exception {
        String name = entry.getMetaData().getName();
        Application application = entry.getApplication();
        if (application == null) {
            try {
                application = new DefaultApplication();
                this.setupLogger(application, name);
                ApplicationContext context = this.createApplicationContext(entry);
                application.setApplicationContext(context);
                application.initialize();
                application.start();
                entry.setApplication(application);
            }
            catch (Throwable t) {
                entry.setApplication(null);
                String message = REZ.getString("kernel.error.entry.initialize", (Object)entry.getMetaData().getName());
                throw new CascadingException(message, t);
            }
        }
    }

    private void shutdown(SarEntry entry) throws Exception {
        Application application = entry.getApplication();
        if (application != null) {
            entry.setApplication(null);
            application.stop();
            application.dispose();
        } else {
            String message = REZ.getString("kernel.error.entry.nostop", (Object)entry.getMetaData().getName());
            this.getLogger().warn(message);
        }
    }

    public void addApplication(SarMetaData metaData, ClassLoader classLoader, Hierarchy hierarchy, Configuration server) throws Exception {
        String name = metaData.getName();
        SarEntry entry = new SarEntry(metaData, classLoader, hierarchy, server);
        this.m_entrys.put(name, entry);
        try {
            this.startup(entry);
        }
        catch (Exception e) {
            String message = REZ.getString("kernel.error.entry.start", (Object)name);
            this.getLogger().warn(message, (Throwable)e);
        }
    }

    private ApplicationContext createApplicationContext(SarEntry entry) throws Exception {
        DefaultApplicationContext context = new DefaultApplicationContext(entry.getMetaData(), entry.getClassLoader(), entry.getHierarchy());
        this.setupLogger(context, entry.getMetaData().getName() + ".frame");
        if (context instanceof Composable) {
            ComponentManager componentManager = this.createComponentManager();
            context.compose(componentManager);
        }
        context.configure(entry.getConfiguration());
        return context;
    }

    private ComponentManager createComponentManager() {
        DefaultComponentManager componentManager = new DefaultComponentManager();
        componentManager.put("org.apache.avalon.phoenix.interfaces.ConfigurationRepository", (Component)this.m_repository);
        componentManager.makeReadOnly();
        return componentManager;
    }

    public void removeApplication(String name) throws Exception {
        SarEntry entry = (SarEntry)this.m_entrys.get(name);
        if (entry != null) {
            this.shutdown(entry);
            this.m_entrys.remove(name);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

