/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import java.util.HashMap;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.interfaces.ManagerException;
import org.apache.avalon.phoenix.interfaces.SystemManager;

public abstract class AbstractSystemManager
extends AbstractLogEnabled
implements SystemManager {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$manager$AbstractSystemManager != null ? class$Lorg$apache$avalon$phoenix$components$manager$AbstractSystemManager : (class$Lorg$apache$avalon$phoenix$components$manager$AbstractSystemManager = AbstractSystemManager.class$("org.apache.avalon.phoenix.components.manager.AbstractSystemManager"))));
    private HashMap m_entrys = new HashMap();
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$manager$AbstractSystemManager;

    public synchronized void register(String name, Object object, Class[] interfaces) throws ManagerException, IllegalArgumentException {
        this.checkRegister(name, object);
        if (interfaces == null) {
            String message = REZ.getString("manager.error.interfaces.null", (Object)name);
            throw new IllegalArgumentException(message);
        }
        this.verifyInterfaces(object, interfaces);
        ManagedEntry entry = new ManagedEntry();
        entry.m_object = object;
        entry.m_interfaces = interfaces;
        entry.m_exportedObject = this.export(name, entry.m_object, interfaces);
        this.m_entrys.put(name, entry);
    }

    public synchronized void register(String name, Object object) throws ManagerException, IllegalArgumentException {
        this.checkRegister(name, object);
        ManagedEntry entry = new ManagedEntry();
        entry.m_object = object;
        entry.m_interfaces = null;
        entry.m_exportedObject = this.export(name, entry.m_object, null);
        this.m_entrys.put(name, entry);
    }

    public synchronized void unregister(String name) throws ManagerException {
        ManagedEntry entry = (ManagedEntry)this.m_entrys.remove(name);
        if (entry == null) {
            String message = REZ.getString("manager.error.unregister.noentry", (Object)name);
            throw new ManagerException(message);
        }
        this.unexport(name, entry.m_exportedObject);
    }

    protected abstract Object export(String var1, Object var2, Class[] var3) throws ManagerException;

    protected abstract void unexport(String var1, Object var2) throws ManagerException;

    protected abstract void verifyInterface(Class var1) throws ManagerException;

    private void verifyInterfaces(Object object, Class[] interfaces) throws ManagerException {
        int i = 0;
        while (i < interfaces.length) {
            Class clazz = interfaces[i];
            if (!clazz.isInterface()) {
                String message = REZ.getString("manager.error.verify.notinterface", (Object)clazz.getName());
                throw new ManagerException(message);
            }
            if (!clazz.isInstance(object)) {
                String message = REZ.getString("manager.error.verify.notinstance", (Object)clazz.getName());
                throw new ManagerException(message);
            }
            this.verifyInterface(clazz);
            ++i;
        }
    }

    private void checkRegister(String name, Object object) throws ManagerException, IllegalArgumentException {
        if (object == null) {
            throw new NullPointerException("object");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.m_entrys.get(name) != null) {
            String message = REZ.getString("manager.error.register.exists", (Object)name);
            throw new ManagerException(message);
        }
    }

    public abstract void initialize() throws Exception;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void dispose();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final class ManagedEntry {
        protected Object m_object;
        protected Class[] m_interfaces;
        protected Object m_exportedObject;

        ManagedEntry() {
        }
    }
}

