/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.components.kernel.DefaultKernel;
import org.apache.avalon.phoenix.components.kernel.DefaultKernelMBean;
import org.apache.avalon.phoenix.components.manager.AbstractSystemManager;
import org.apache.avalon.phoenix.interfaces.ClassLoaderManager;
import org.apache.avalon.phoenix.interfaces.ConfigurationRepository;
import org.apache.avalon.phoenix.interfaces.Deployer;
import org.apache.avalon.phoenix.interfaces.Embeddor;
import org.apache.avalon.phoenix.interfaces.Kernel;
import org.apache.avalon.phoenix.interfaces.LogManager;
import org.apache.avalon.phoenix.interfaces.ManagerException;
import org.apache.jmx.adaptor.RMIAdaptorImpl;
import org.apache.jmx.introspector.JavaBeanMBean;

public class DefaultManager
extends AbstractSystemManager
implements Parameterizable,
Composable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$components$manager$DefaultManager != null ? class$Lorg$apache$avalon$phoenix$components$manager$DefaultManager : (class$Lorg$apache$avalon$phoenix$components$manager$DefaultManager = DefaultManager.class$("org.apache.avalon.phoenix.components.manager.DefaultManager"))));
    private static final int DEFAULT_REGISTRY_PORT = Integer.getInteger("phoenix.port", 1111);
    private Parameters m_parameters;
    private MBeanServer m_mBeanServer;
    private RMIAdaptorImpl m_rmiAdaptor;
    private Registry m_rmiRegistry;
    private String m_name;
    private String m_domain = "Phoenix";
    private Embeddor m_embeddor;
    private Deployer m_deployer;
    private LogManager m_logManager;
    private Kernel m_kernel;
    private ConfigurationRepository m_repository;
    private ClassLoaderManager m_classLoaderManager;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$components$manager$DefaultManager;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$Embeddor;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$interfaces$Deployer;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.m_parameters = parameters;
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_embeddor = (Embeddor)componentManager.lookup("org.apache.avalon.phoenix.interfaces.Embeddor");
        this.m_kernel = (Kernel)componentManager.lookup("org.apache.avalon.phoenix.interfaces.Kernel");
        this.m_deployer = (Deployer)componentManager.lookup("org.apache.avalon.phoenix.interfaces.Deployer");
        this.m_repository = (ConfigurationRepository)componentManager.lookup("org.apache.avalon.phoenix.interfaces.ConfigurationRepository");
        this.m_classLoaderManager = (ClassLoaderManager)componentManager.lookup("org.apache.avalon.phoenix.interfaces.ClassLoaderManager");
        this.m_logManager = (LogManager)componentManager.lookup("org.apache.avalon.phoenix.interfaces.LogManager");
    }

    public void initialize() throws Exception {
        this.m_mBeanServer = this.createMBeanServer();
        this.m_rmiAdaptor = new RMIAdaptorImpl(this.m_mBeanServer);
        try {
            HtmlAdaptorServer html = new HtmlAdaptorServer();
            ObjectName name = new ObjectName("Adaptor:name=html,port=8082");
            System.out.println("Created HTML Adaptor " + name);
            this.m_mBeanServer.registerMBean(html, name);
            html.start();
        }
        catch (Exception e) {
            System.out.println("Could not create the HTML adaptor!!!");
            e.printStackTrace();
            throw e;
        }
        this.register("Kernel", this.m_kernel);
        this.register("Embeddor", this.m_embeddor, new Class[]{class$Lorg$apache$avalon$phoenix$interfaces$Embeddor != null ? class$Lorg$apache$avalon$phoenix$interfaces$Embeddor : (class$Lorg$apache$avalon$phoenix$interfaces$Embeddor = DefaultManager.class$("org.apache.avalon.phoenix.interfaces.Embeddor"))});
        this.register("Deployer", this.m_deployer, new Class[]{class$Lorg$apache$avalon$phoenix$interfaces$Deployer != null ? class$Lorg$apache$avalon$phoenix$interfaces$Deployer : (class$Lorg$apache$avalon$phoenix$interfaces$Deployer = DefaultManager.class$("org.apache.avalon.phoenix.interfaces.Deployer"))});
        this.register("LogManager", this.m_logManager);
        this.register("ConfigurationRepository", this.m_repository);
        this.register("ClassLoaderManager", this.m_classLoaderManager);
    }

    public void start() throws Exception {
        int port = this.m_parameters.getParameterAsInteger("manager-registry-port", DEFAULT_REGISTRY_PORT);
        this.m_name = this.m_parameters.getParameter("manager-name", "Phoenix.JMXAdaptor");
        this.m_rmiRegistry = LocateRegistry.createRegistry(port);
        RemoteStub exported = UnicastRemoteObject.exportObject((Remote)this.m_rmiAdaptor);
        Remote stub = RemoteObject.toStub(exported);
        this.m_rmiRegistry.bind(this.m_name, stub);
    }

    public void stop() throws Exception {
        this.m_rmiRegistry.unbind(this.m_name);
        UnicastRemoteObject.unexportObject((Remote)this.m_rmiAdaptor, true);
    }

    public void dispose() {
        this.m_rmiAdaptor = null;
        this.m_mBeanServer = null;
    }

    protected Object export(String name, Object object, Class[] interfaces) throws ManagerException {
        try {
            Object mBean = null;
            mBean = interfaces != null ? new JavaBeanMBean(object, interfaces) : this.createMBean(object);
            ObjectName objectName = new ObjectName(this.m_domain + ":type=" + name);
            this.m_mBeanServer.registerMBean(mBean, objectName);
            return mBean;
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.export.fail", (Object)name);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
    }

    private Object createMBean(Object object) throws ManagerException {
        if (object instanceof DefaultKernel) {
            return new DefaultKernelMBean((DefaultKernel)object);
        }
        return new JavaBeanMBean(object);
    }

    protected void unexport(String name, Object exportedObject) throws ManagerException {
        try {
            this.m_mBeanServer.unregisterMBean(new ObjectName(name));
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.unexport.fail", (Object)name);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
    }

    protected void verifyInterface(Class clazz) throws ManagerException {
    }

    private MBeanServer createMBeanServer() throws Exception {
        String className = this.m_parameters.getParameter("manager-mBeanServer-class", "org.apache.jmx.MBeanServerImpl");
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            return (MBeanServer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.mbeanserver.create", (Object)className);
            throw new ParameterException(message, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

