/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.frontends;

import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.components.embeddor.DefaultEmbeddor;
import org.apache.avalon.phoenix.frontends.CLISetup;
import org.apache.avalon.phoenix.frontends.ShutdownHook;
import org.apache.avalon.phoenix.interfaces.Embeddor;

public final class CLIMain {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$frontends$CLIMain != null ? class$Lorg$apache$avalon$phoenix$frontends$CLIMain : (class$Lorg$apache$avalon$phoenix$frontends$CLIMain = CLIMain.class$("org.apache.avalon.phoenix.frontends.CLIMain"))));
    private Embeddor m_embeddor;
    private int m_exitCode;
    private ShutdownHook m_hook;
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$frontends$CLIMain;

    public void main(String[] args) {
        CLIMain main = new CLIMain();
        try {
            String command = "java " + this.getClass().getName() + " [options]";
            CLISetup setup = new CLISetup(command);
            if (!setup.parseCommandLineOptions(args)) {
                return;
            }
            System.out.println();
            System.out.println("Phoenix" + " " + "4.0a4");
            System.out.println();
            Parameters parameters = setup.getParameters();
            String phoenixHome = System.getProperty("phoenix.home", "..");
            parameters.setParameter("phoenix.home", phoenixHome);
            main.execute(parameters);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        System.exit(this.m_exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(Parameters parameters) throws Exception {
        block9: {
            if (!this.startup(parameters)) {
                return;
            }
            boolean disableHook = parameters.getParameterAsBoolean("disable-hook", false);
            if (!disableHook) {
                this.m_hook = new ShutdownHook(this);
                Runtime.getRuntime().addShutdownHook(this.m_hook);
            }
            try {
                try {
                    this.m_embeddor.execute();
                }
                catch (Throwable throwable) {
                    this.handleException(throwable);
                    Object var4_4 = null;
                    if (this.m_hook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.m_hook);
                    }
                    this.shutdown();
                    return;
                }
                Object var4_3 = null;
                if (this.m_hook == null) break block9;
                Runtime.getRuntime().removeShutdownHook(this.m_hook);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.m_hook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.m_hook);
                }
                this.shutdown();
                throw throwable;
            }
        }
        this.shutdown();
    }

    protected synchronized boolean startup(Parameters parameters) {
        try {
            this.m_embeddor = new DefaultEmbeddor();
            if (this.m_embeddor instanceof Parameterizable) {
                ((Parameterizable)this.m_embeddor).parameterize(parameters);
            }
            this.m_embeddor.initialize();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return false;
        }
        return true;
    }

    protected void forceShutdown() {
        String message = REZ.getString("main.abnormal-exit.notice");
        System.out.println(message);
        System.out.flush();
        this.m_hook = null;
        this.shutdown();
    }

    private synchronized void shutdown() {
        if (this.m_embeddor != null) {
            try {
                try {
                    this.m_embeddor.dispose();
                }
                catch (Throwable throwable) {
                    this.handleException(throwable);
                    Object var2_2 = null;
                    this.m_embeddor = null;
                }
                Object var2_1 = null;
                this.m_embeddor = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.m_embeddor = null;
                throw throwable;
            }
        }
    }

    private void handleException(Throwable throwable) {
        System.out.println(REZ.getString("main.exception.header"));
        System.out.println("---------------------------------------------------------");
        System.out.println("--- Message ---");
        System.out.println(throwable.getMessage());
        System.out.println("--- Stack Trace ---");
        throwable.printStackTrace(System.out);
        System.out.println("---------------------------------------------------------");
        System.out.println(REZ.getString("main.exception.footer"));
        this.m_exitCode = 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

