/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmx.introspector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.jmx.introspector.AttributeEntry;
import org.apache.jmx.introspector.OperationEntry;

public abstract class AbstractMBean
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private final Object m_object;
    private MBeanInfo m_mBeanInfo;
    private String m_description;
    private AttributeEntry[] m_attributes;
    private OperationEntry[] m_operations;
    private MBeanNotificationInfo[] m_notifications;

    public final MBeanNotificationInfo[] getNotificationInfo() {
        return this.m_notifications;
    }

    public synchronized MBeanInfo getMBeanInfo() {
        return this.m_mBeanInfo;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeEntry entry = this.getAttributeEntry(attribute);
        Method method = entry.getReadMethod();
        if (method == null) {
            new AttributeNotFoundException(attribute);
        }
        try {
            return method.invoke(this.getObject(), EMPTY_OBJ_ARRAY);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList getAttributes(String[] names) {
        AttributeList atributes = new AttributeList();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            try {
                Object value = this.getAttribute(name);
                Attribute attribute = new Attribute(name, value);
                atributes.add(attribute);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return atributes;
    }

    public Object invoke(String action, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        OperationEntry entry = this.getOperationEntry(action, signature);
        Method method = entry.getMethod();
        try {
            return method.invoke(this.getObject(), params);
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeEntry entry = this.getAttributeEntry(attribute.getName());
        Method method = entry.getWriteMethod();
        if (method == null) {
            new AttributeNotFoundException(attribute.getName());
        }
        try {
            method.invoke(this.getObject(), attribute.getValue());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidAttributeValueException();
        }
        catch (InvocationTargetException ite) {
            throw new MBeanException(ite);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public AttributeList setAttributes(AttributeList input) {
        AttributeList atributes = new AttributeList();
        int size = input.size();
        int i = 0;
        while (i < size) {
            try {
                Attribute attribute = (Attribute)input.get(i);
                this.setAttribute(attribute);
                atributes.add(attribute);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return atributes;
    }

    protected final Object getObject() {
        return this.m_object;
    }

    protected synchronized void initialize() {
        this.m_description = this.createDescription();
        this.m_operations = this.createOperations();
        this.m_attributes = this.createAttributes();
        this.m_notifications = this.createNotificationInfos();
        this.m_mBeanInfo = this.createMBeanInfo();
    }

    protected synchronized String createDescription() {
        return null;
    }

    protected synchronized OperationEntry[] createOperations() {
        return new OperationEntry[0];
    }

    protected synchronized AttributeEntry[] createAttributes() {
        return new AttributeEntry[0];
    }

    protected synchronized MBeanNotificationInfo[] createNotificationInfos() {
        return new MBeanNotificationInfo[0];
    }

    private synchronized AttributeEntry getAttributeEntry(String name) throws AttributeNotFoundException {
        int i = 0;
        while (i < this.m_attributes.length) {
            String other = this.m_attributes[i].getInfo().getName();
            if (other.equals(name)) {
                return this.m_attributes[i];
            }
            ++i;
        }
        throw new AttributeNotFoundException();
    }

    private synchronized OperationEntry getOperationEntry(String action, String[] params) throws ReflectionException {
        int i = 0;
        while (i < this.m_operations.length) {
            MBeanOperationInfo info = this.m_operations[i].getInfo();
            MBeanParameterInfo[] paramInfos = info.getSignature();
            if (info.getName().equals(action) && paramInfos.length == params.length) {
                boolean found = true;
                int j = 0;
                while (j < paramInfos.length) {
                    String param = paramInfos[i].getType();
                    if (!params[j].equals(param)) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return this.m_operations[i];
                }
            }
            ++i;
        }
        throw new ReflectionException(new NoSuchMethodException(action));
    }

    private synchronized MBeanInfo createMBeanInfo() {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[this.m_attributes.length];
        int i = 0;
        while (i < attributes.length) {
            attributes[i] = this.m_attributes[i].getInfo();
            ++i;
        }
        MBeanOperationInfo[] operations = new MBeanOperationInfo[this.m_operations.length];
        int i2 = 0;
        while (i2 < operations.length) {
            operations[i2] = this.m_operations[i2].getInfo();
            ++i2;
        }
        return new MBeanInfo(this.getObject().getClass().getName(), this.m_description, attributes, null, operations, this.m_notifications);
    }

    protected AbstractMBean(Object object) {
        this.m_object = object;
    }
}

