/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmx.introspector;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.IntrospectionException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.jmx.introspector.AbstractMBean;
import org.apache.jmx.introspector.AttributeEntry;
import org.apache.jmx.introspector.JMXPermission;
import org.apache.jmx.introspector.OperationEntry;

public abstract class ConstructiveMBean
extends AbstractMBean {
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    protected static final int ACTION = 1;
    protected static final int ACTION_INFO = 2;
    protected static final int INFO = 0;
    protected static final int UNKNOWN = 3;
    private ArrayList m_operations = new ArrayList();
    private ArrayList m_attributes = new ArrayList();

    protected abstract void defineObject();

    protected final void addAttribute(String name) {
        this.addAttribute(name, true);
    }

    protected final void addAttribute(String name, boolean isWriteable) {
        this.addAttribute(name, isWriteable, null);
    }

    protected final void addAttribute(String name, boolean isWriteable, String description) {
        String property = Introspector.decapitalize(name);
        String methodPropertyName = property.substring(0, 1).toUpperCase() + property.substring(1);
        String getAccessorName = "get" + methodPropertyName;
        String isAccessorName = "is" + methodPropertyName;
        String mutatorName = "set" + methodPropertyName;
        Method accessor = null;
        Class<?> clazz = this.getObject().getClass();
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((1 & method.getModifiers()) != 0 && method.getParameterTypes().length == 0 && (method.getName().equals(getAccessorName) || method.getName().equals(isAccessorName))) {
                accessor = method;
                break;
            }
            ++i;
        }
        if (accessor == null) {
            throw new IllegalArgumentException("Unable to locate accessor for property " + name);
        }
        Method mutator = null;
        if (isWriteable) {
            Class[] params = new Class[]{accessor.getReturnType()};
            try {
                mutator = clazz.getMethod(mutatorName, params);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("Unable to locate mutator for property " + name);
            }
        }
        try {
            AttributeEntry entry = new AttributeEntry(name, description, accessor, mutator);
            this.m_attributes.add(entry);
        }
        catch (IntrospectionException ie) {
            throw new IllegalArgumentException("Unable to add attribute due to " + ie);
        }
    }

    protected final void addOperation(String name, int impact) {
        this.addOperation(name, impact, null);
    }

    protected final void addOperation(String name, int impact, String description) {
        this.addOperation(name, EMPTY_STR_ARRAY, impact, description, EMPTY_STR_ARRAY);
    }

    protected final void addOperation(String name, String[] params, int impact) {
        this.addOperation(name, params, impact, null);
    }

    protected final void addOperation(String name, String[] params, int impact, String description) {
        this.addOperation(name, params, impact, description, null);
    }

    protected final void addOperation(String name, String[] params, int impact, String description, String[] paramNames) {
        this.addOperation(name, params, impact, description, null, null);
    }

    protected final void addOperation(String name, String[] params, int impact, String description, String[] paramNames, String[] paramsDescription) {
        if (paramNames != null && params.length != paramNames.length) {
            String message = "Params length not match param names length";
            throw new IllegalArgumentException("Params length not match param names length");
        }
        if (paramsDescription != null && params.length != paramsDescription.length) {
            String message = "Params length not match params description length";
            throw new IllegalArgumentException("Params length not match params description length");
        }
        Class<?> clazz = this.getObject().getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class[] paramTypes = new Class[params.length];
        MBeanParameterInfo[] paramInfos = new MBeanParameterInfo[params.length];
        int i = 0;
        while (i < params.length) {
            String param = params[i];
            String paramName = paramNames != null ? paramNames[i] : "param" + i;
            String paramDescription = paramsDescription != null ? paramsDescription[i] : null;
            paramInfos[i] = new MBeanParameterInfo(paramName, param, paramDescription);
            try {
                paramTypes[i] = classLoader.loadClass(param);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error loading param type (" + param + ") due to " + e);
            }
            ++i;
        }
        Method method = null;
        try {
            method = clazz.getMethod(name, paramTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error retrieving method due to " + e);
        }
        String type = method.getReturnType().getName();
        MBeanOperationInfo info = new MBeanOperationInfo(name, description, paramInfos, type, impact);
        OperationEntry entry = new OperationEntry(info, method);
        this.m_operations.add(entry);
    }

    protected OperationEntry[] createOperations() {
        return this.m_operations.toArray(new OperationEntry[0]);
    }

    protected synchronized AttributeEntry[] createAttributes() throws IllegalArgumentException {
        return this.m_attributes.toArray(new AttributeEntry[0]);
    }

    public ConstructiveMBean(Object object) throws IllegalArgumentException {
        this(object, true);
    }

    public ConstructiveMBean(Object object, boolean secure) throws IllegalArgumentException {
        super(object);
        SecurityManager sm;
        if (secure && (sm = System.getSecurityManager()) != null) {
            String classname = object.getClass().getName();
            JMXPermission permission = new JMXPermission("create", classname);
            sm.checkPermission(permission);
        }
        this.defineObject();
        this.initialize();
        this.m_attributes.clear();
        this.m_operations.clear();
        this.m_attributes = null;
        this.m_operations = null;
    }
}

