/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmx.introspector;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.IntrospectionException;
import javax.management.MBeanOperationInfo;
import org.apache.jmx.introspector.AbstractMBean;
import org.apache.jmx.introspector.AttributeEntry;
import org.apache.jmx.introspector.OperationEntry;

public class JavaBeanMBean
extends AbstractMBean {
    private BeanInfo m_beanInfo;
    private MethodDescriptor[] m_allowedOperations;
    private PropertyDescriptor[] m_allowedAttributes;

    protected synchronized String createDescription() {
        return this.m_beanInfo.getBeanDescriptor().getShortDescription();
    }

    protected OperationEntry[] createOperations() {
        MethodDescriptor[] methods = this.m_beanInfo.getMethodDescriptors();
        ArrayList<OperationEntry> entrys = new ArrayList<OperationEntry>();
        int i = 0;
        while (i < methods.length) {
            MethodDescriptor descriptor = methods[i];
            if (this.isAllowedOperation(descriptor)) {
                Method method = descriptor.getMethod();
                MBeanOperationInfo info = new MBeanOperationInfo(descriptor.getShortDescription(), method);
                entrys.add(new OperationEntry(info, method));
            }
            ++i;
        }
        return entrys.toArray(new OperationEntry[0]);
    }

    protected synchronized AttributeEntry[] createAttributes() throws IllegalArgumentException {
        PropertyDescriptor[] propertys = this.m_beanInfo.getPropertyDescriptors();
        ArrayList<AttributeEntry> entrys = new ArrayList<AttributeEntry>();
        int i = 0;
        while (i < propertys.length) {
            PropertyDescriptor property = propertys[i];
            if (this.isAllowedAttribute(property)) {
                try {
                    AttributeEntry attribute = new AttributeEntry(property.getName(), property.getShortDescription(), property.getReadMethod(), property.getWriteMethod());
                    entrys.add(attribute);
                }
                catch (IntrospectionException ie) {
                    throw new IllegalArgumentException("Error introspecting properties.");
                }
            }
            ++i;
        }
        return entrys.toArray(new AttributeEntry[0]);
    }

    private MethodDescriptor[] getAllowedOperations(Class[] interfaces) throws IllegalArgumentException {
        if (interfaces == null) {
            return null;
        }
        ArrayList<MethodDescriptor> operations = new ArrayList<MethodDescriptor>();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < interfaces.length) {
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(interfaces[i]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The supplied interfaces are not all valid javabeans!");
            }
            MethodDescriptor[] methods = beanInfo.getMethodDescriptors();
            int j = 0;
            while (j < methods.length) {
                operations.add(methods[j]);
                names.add(methods[j].getName());
                ++j;
            }
            ++i;
        }
        return operations.toArray(new MethodDescriptor[0]);
    }

    private PropertyDescriptor[] getAllowedAttributes(Class[] interfaces) throws IllegalArgumentException {
        if (interfaces == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> attributes = new ArrayList<PropertyDescriptor>();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < interfaces.length) {
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(interfaces[i]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The supplied interfaces are not all valid javabeans!");
            }
            PropertyDescriptor[] propertys = beanInfo.getPropertyDescriptors();
            int j = 0;
            while (j < propertys.length) {
                attributes.add(propertys[j]);
                names.add(propertys[j].getName());
                ++j;
            }
            ++i;
        }
        return attributes.toArray(new PropertyDescriptor[0]);
    }

    private boolean isAllowedOperation(MethodDescriptor method) {
        if (this.m_allowedOperations == null) {
            return true;
        }
        ParameterDescriptor[] params = method.getParameterDescriptors();
        int i = 0;
        while (i < this.m_allowedOperations.length) {
            MethodDescriptor other = this.m_allowedOperations[i];
            ParameterDescriptor[] otherParams = other.getParameterDescriptors();
            if (other.getName().equals(method.getName())) {
                if (params == null && otherParams == null) {
                    return true;
                }
                if (otherParams.length == params.length) {
                    boolean found = true;
                    int j = 0;
                    while (j < otherParams.length) {
                        String type = params[j].getName();
                        String otherType = otherParams[j].getName();
                        if (!otherType.equals(type)) {
                            found = false;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isAllowedAttribute(PropertyDescriptor property) {
        if (this.m_allowedOperations == null) {
            return true;
        }
        int i = 0;
        while (i < this.m_allowedAttributes.length) {
            PropertyDescriptor other = this.m_allowedAttributes[i];
            if (other.getName().equals(property.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JavaBeanMBean(Object object) throws IllegalArgumentException {
        this(object, null);
    }

    public JavaBeanMBean(Object object, Class[] interfaces) throws IllegalArgumentException {
        super(object);
        Class<?> clazz = object.getClass();
        try {
            this.m_beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a compliant javabean!");
        }
        this.m_allowedOperations = this.getAllowedOperations(interfaces);
        this.m_allowedAttributes = this.getAllowedAttributes(interfaces);
        this.initialize();
        this.m_allowedOperations = null;
        this.m_allowedAttributes = null;
    }
}

