/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.Vector;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.XSLTAttributeDef;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.res.XSLMessages;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSLTElementProcessor {
    private XSLTElementDef m_elemDef;

    XSLTElementProcessor() {
    }

    public void characters(StylesheetHandler handler, char[] ch, int start, int length) throws SAXException {
        handler.error("Characters are not allowed at this point in the document!", null);
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
    }

    XSLTElementDef getElemDef() {
        return this.m_elemDef;
    }

    public void ignorableWhitespace(StylesheetHandler handler, char[] ch, int start, int length) throws SAXException {
    }

    public void notationDecl(StylesheetHandler handler, String name, String publicId, String systemId) {
    }

    public void processingInstruction(StylesheetHandler handler, String target, String data) throws SAXException {
    }

    public InputSource resolveEntity(StylesheetHandler handler, String publicId, String systemId) throws SAXException {
        return null;
    }

    void setElemDef(XSLTElementDef def) {
        this.m_elemDef = def;
    }

    void setPropertiesFromAttributes(StylesheetHandler handler, String rawName, Attributes attributes, Object target) throws SAXException {
        this.setPropertiesFromAttributes(handler, rawName, attributes, target, true);
    }

    Attributes setPropertiesFromAttributes(StylesheetHandler handler, String rawName, Attributes attributes, Object target, boolean throwError) throws SAXException {
        XSLTElementDef def = this.getElemDef();
        AttributesImpl undefines = throwError ? null : new AttributesImpl();
        Vector<XSLTAttributeDef> processedDefs = new Vector<XSLTAttributeDef>();
        int nAttrs = attributes.getLength();
        int i = 0;
        while (i < nAttrs) {
            String attrLocalName;
            XSLTAttributeDef attrDef;
            String attrUri = attributes.getURI(i);
            if (attrUri != null && attrUri.length() == 0 && (attributes.getQName(i).startsWith("xmlns:") || attributes.getQName(i).equals("xmlns"))) {
                attrUri = "http://www.w3.org/XML/1998/namespace";
            }
            if ((attrDef = def.getAttributeDef(attrUri, attrLocalName = attributes.getLocalName(i))) == null) {
                if (throwError) {
                    handler.error("\"" + attributes.getQName(i) + "\"" + " attribute is not allowed on the " + rawName + " element!", null);
                } else {
                    undefines.addAttribute(attrUri, attrLocalName, attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                }
            } else {
                processedDefs.addElement(attrDef);
                attrDef.setAttrValue(handler, attrUri, attrLocalName, attributes.getQName(i), attributes.getValue(i), target);
            }
            ++i;
        }
        XSLTAttributeDef[] attrDefs = def.getAttributes();
        int nAttrDefs = attrDefs.length;
        int i2 = 0;
        while (i2 < nAttrDefs) {
            XSLTAttributeDef attrDef = attrDefs[i2];
            String defVal = attrDef.getDefault();
            if (defVal != null && !processedDefs.contains(attrDef)) {
                attrDef.setDefAttrValue(handler, target);
            }
            if (attrDef.getRequired() && !processedDefs.contains(attrDef)) {
                handler.error(XSLMessages.createMessage(9, new Object[]{rawName, attrDef.getName()}), null);
            }
            ++i2;
        }
        return undefines;
    }

    public void skippedEntity(StylesheetHandler handler, String name) throws SAXException {
    }

    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
    }

    public void startNonText(StylesheetHandler handler) throws SAXException {
    }

    public void unparsedEntityDecl(StylesheetHandler handler, String name, String publicId, String systemId, String notationName) {
    }
}

