/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemUse;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemLiteralResult
extends ElemUse {
    private boolean isLiteralResultAsStylesheet = false;
    private Vector m_avts = null;
    private Vector m_xslAttr = null;
    private String m_namespace;
    private String m_localName;
    private String m_rawName;
    private StringVector m_ExtensionElementURIs;
    private String m_version;
    private StringVector m_excludeResultPrefixes;

    public void addLiteralResultAttribute(String att) {
        if (this.m_xslAttr == null) {
            this.m_xslAttr = new Vector();
        }
        this.m_xslAttr.addElement(att);
    }

    public void addLiteralResultAttribute(AVT avt) {
        if (this.m_avts == null) {
            this.m_avts = new Vector();
        }
        this.m_avts.addElement(avt);
    }

    public boolean containsExcludeResultPrefix(String prefix) {
        if (this.m_excludeResultPrefixes == null) {
            return super.containsExcludeResultPrefix(prefix);
        }
        if (prefix.length() == 0) {
            prefix = "#default";
        }
        if (this.m_excludeResultPrefixes.contains(prefix)) {
            return true;
        }
        return super.containsExcludeResultPrefix(prefix);
    }

    public boolean containsExtensionElementURI(String uri) {
        if (this.m_ExtensionElementURIs == null) {
            return false;
        }
        return this.m_ExtensionElementURIs.contains(uri);
    }

    public Enumeration enumerateLiteralResultAttributes() {
        return this.m_avts == null ? null : this.m_avts.elements();
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        return this.m_excludeResultPrefixes != null && this.m_excludeResultPrefixes.contains(prefix);
    }

    public void execute(TransformerImpl transformer, Node sourceNode, QName mode) throws TransformerException {
        try {
            ResultTreeHandler rhandler = transformer.getResultTreeHandler();
            this.executeNSDecls(transformer);
            rhandler.startElement(this.getNamespace(), this.getLocalName(), this.getRawName());
            try {
                super.execute(transformer, sourceNode, mode);
                if (this.m_avts != null) {
                    int nAttrs = this.m_avts.size();
                    int i = nAttrs - 1;
                    while (i >= 0) {
                        XPathContext xctxt;
                        AVT avt = (AVT)this.m_avts.elementAt(i);
                        String stringedValue = avt.evaluate(xctxt = transformer.getXPathContext(), sourceNode, this);
                        if (stringedValue != null) {
                            rhandler.addAttribute(avt.getURI(), avt.getName(), avt.getRawName(), "CDATA", stringedValue);
                        }
                        --i;
                    }
                }
                transformer.executeChildTemplates(this, sourceNode, mode);
                Object var6_12 = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                rhandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
                this.unexecuteNSDecls(transformer);
                throw throwable;
            }
            rhandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
            this.unexecuteNSDecls(transformer);
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public String getExtensionElementPrefix(int i) throws ArrayIndexOutOfBoundsException {
        if (this.m_ExtensionElementURIs == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_ExtensionElementURIs.elementAt(i);
    }

    public int getExtensionElementPrefixCount() {
        return this.m_ExtensionElementURIs != null ? this.m_ExtensionElementURIs.size() : 0;
    }

    public boolean getIsLiteralResultAsStylesheet() {
        return this.isLiteralResultAsStylesheet;
    }

    public AVT getLiteralResultAttribute(String name) {
        if (this.m_avts != null) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                AVT avt = (AVT)this.m_avts.elementAt(i);
                if (avt.getRawName().equals(name)) {
                    return avt;
                }
                --i;
            }
        }
        return null;
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getNodeName() {
        return this.m_rawName;
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public int getXSLToken() {
        return 77;
    }

    boolean needToCheckExclude() {
        if (this.m_excludeResultPrefixes == null && this.m_prefixTable == null) {
            return false;
        }
        if (this.m_prefixTable == null) {
            this.m_prefixTable = new Vector();
        }
        return true;
    }

    public void resolvePrefixTables() throws TransformerException {
        NamespaceAlias nsa;
        super.resolvePrefixTables();
        StylesheetRoot stylesheet = this.getStylesheetRoot();
        if (this.m_namespace != null && this.m_namespace.length() > 0 && (nsa = stylesheet.getNamespaceAliasComposed(this.m_namespace)) != null) {
            this.m_namespace = nsa.getResultNamespace();
            String resultPrefix = nsa.getStylesheetPrefix();
            this.m_rawName = resultPrefix != null && resultPrefix.length() > 0 ? String.valueOf(resultPrefix) + ":" + this.m_localName : this.m_localName;
        }
        if (this.m_avts != null) {
            int n = this.m_avts.size();
            int i = 0;
            while (i < n) {
                NamespaceAlias nsa2;
                AVT avt = (AVT)this.m_avts.elementAt(i);
                String ns = avt.getURI();
                if (ns != null && ns.length() > 0 && (nsa2 = stylesheet.getNamespaceAliasComposed(this.m_namespace)) != null) {
                    String namespace = nsa2.getResultNamespace();
                    String resultPrefix = nsa2.getStylesheetPrefix();
                    String rawName = avt.getName();
                    if (resultPrefix != null && resultPrefix.length() > 0) {
                        rawName = String.valueOf(resultPrefix) + ":" + rawName;
                    }
                    avt.setURI(namespace);
                    avt.setRawName(rawName);
                }
                ++i;
            }
        }
    }

    public void setExcludeResultPrefixes(StringVector v) {
        this.m_excludeResultPrefixes = v;
    }

    public void setExtensionElementPrefixes(StringVector v) {
        this.m_ExtensionElementURIs = v;
    }

    public void setIsLiteralResultAsStylesheet(boolean b) {
        this.isLiteralResultAsStylesheet = b;
    }

    public void setLocalName(String localName) {
        this.m_localName = localName;
    }

    public void setNamespace(String ns) {
        if (ns == null) {
            ns = "";
        }
        this.m_namespace = ns;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public void setVersion(String v) {
        this.m_version = v;
    }

    public void setXmlSpace(AVT avt) {
        this.addLiteralResultAttribute(avt);
        String val = avt.getSimpleString();
        if (val.equals("default")) {
            super.setXmlSpace(2);
        } else if (val.equals("preserve")) {
            super.setXmlSpace(1);
        }
    }
}

