/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.stree.Child;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AxesWalker
extends PredicatedNodeTest
implements Cloneable,
TreeWalker,
NodeFilter {
    static final boolean DEBUG = false;
    static final boolean DEBUG_WAITING = false;
    static final boolean DEBUG_TRAVERSAL = false;
    static final boolean DEBUG_LOCATED = false;
    static boolean m_didDumpAll = false;
    public static final String FEATURE_NODETESTFILTER = "NodeTestFilter";
    transient Node m_root;
    transient Node m_currentNode;
    transient Node m_prevReturned;
    private int m_argLen;
    private int m_stepType;
    private transient boolean m_didSwitch = false;
    transient boolean m_isDone = false;
    transient boolean m_isFresh;
    protected transient int m_nextLevelAmount;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;

    public AxesWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    private final void addToWaitList(AxesWalker walker) {
        this.m_lpi.addToWaitList(walker);
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        if (this.m_nextWalker != null) {
            return this.m_nextWalker.canTraverseOutsideSubtree();
        }
        return false;
    }

    AxesWalker checkNeedsToWait(AxesWalker walker) {
        AxesWalker prevWalker = walker.m_prevWalker;
        if (prevWalker != null && !this.checkOKToTraverse(prevWalker, walker, walker.m_currentNode, walker.m_nextLevelAmount)) {
            if (this.isWaiting(walker)) {
                try {
                    this.addToWaitList((AxesWalker)walker.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else {
                this.addToWaitList(walker);
            }
            walker = walker.m_prevWalker;
        }
        return walker;
    }

    protected boolean checkOKToTraverse(AxesWalker prevStepWalker, AxesWalker testWalker, Node currentTestNode, int nextLevelAmount) {
        short prevStepLevel;
        boolean isNodeAfter;
        DOMHelper dh = this.m_lpi.getDOMHelper();
        short level = dh.getLevel(currentTestNode);
        Node prevNode = prevStepWalker.m_currentNode;
        boolean ok = !prevStepWalker.m_isDone && prevStepWalker.getLevelMax() > level ? ((isNodeAfter = dh.isNodeAfter(prevNode, currentTestNode) ^ true) ? (prevStepLevel = dh.getLevel(prevNode)) <= level + nextLevelAmount : false) : true;
        return ok;
    }

    AxesWalker checkWaiting(AxesWalker walker) {
        if (walker != null && walker.m_currentNode == null) {
            return walker;
        }
        int nWaiting = this.m_lpi.getWaitingCount();
        int i = this.m_lpi.m_waitingBottom;
        while (i < nWaiting) {
            AxesWalker ws = this.m_lpi.getWaiting(i);
            AxesWalker prevStepWalker = ws.m_prevWalker;
            if (prevStepWalker != null && this.checkOKToTraverse(prevStepWalker, ws, ws.m_currentNode, ws.m_nextLevelAmount)) {
                AxesWalker deferedWalker;
                if (walker != null && !this.isWaiting(deferedWalker = walker)) {
                    this.addToWaitList(deferedWalker);
                }
                walker = ws;
                this.m_lpi.removeFromWaitList(walker);
                walker.printEntryDebug();
                this.m_didSwitch = true;
                break;
            }
            ++i;
        }
        return walker;
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker clone = (AxesWalker)super.clone();
        return clone;
    }

    AxesWalker cloneDeep(LocPathIterator cloneOwner, Vector cloneList) throws CloneNotSupportedException {
        AxesWalker clone = AxesWalker.findClone(this, cloneList);
        if (clone != null) {
            return clone;
        }
        clone = (AxesWalker)this.clone();
        clone.setLocPathIterator(cloneOwner);
        if (cloneList != null) {
            cloneList.addElement(this);
            cloneList.addElement(clone);
        }
        if (this.m_lpi.m_lastUsedWalker == this) {
            cloneOwner.m_lastUsedWalker = clone;
        }
        if (this.m_nextWalker != null) {
            clone.m_nextWalker = this.m_nextWalker.cloneDeep(cloneOwner, cloneList);
        }
        if (cloneList != null) {
            if (this.m_prevWalker != null) {
                clone.m_prevWalker = this.m_prevWalker.cloneDeep(cloneOwner, cloneList);
            }
        } else if (this.m_nextWalker != null) {
            clone.m_nextWalker.m_prevWalker = clone;
        }
        return clone;
    }

    private void dumpAll(Node node, int indent) {
        String value;
        int i = 0;
        while (i < indent) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(this.nodeToString(node));
        if (node.getNodeType() == 3 && (value = node.getNodeValue()) != null) {
            System.out.print("+= -->" + value.trim());
        }
        System.out.println("");
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int n = map.getLength();
            int i2 = 0;
            while (i2 < n) {
                int k = 0;
                while (k < indent) {
                    System.out.print(" ");
                    ++k;
                }
                System.out.print("attr -->");
                System.out.print(this.nodeToString(map.item(i2)));
                String value2 = map.item(i2).getNodeValue();
                if (value2 != null) {
                    System.out.print("+= -->" + value2.trim());
                }
                System.out.println("");
                ++i2;
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.dumpAll(child, indent + 1);
            child = child.getNextSibling();
        }
    }

    static AxesWalker findClone(AxesWalker key, Vector cloneList) {
        if (cloneList != null) {
            int n = cloneList.size();
            int i = 0;
            while (i < n) {
                if (key == cloneList.elementAt(i)) {
                    return (AxesWalker)cloneList.elementAt(i + 1);
                }
                i += 2;
            }
        }
        return null;
    }

    public Node firstChild() {
        return null;
    }

    protected int getArgLen() {
        return this.m_argLen;
    }

    public final Node getCurrentNode() {
        return this.m_currentNode;
    }

    private AxesWalker getEarliestWaiting() {
        DOMHelper dh = this.m_lpi.getDOMHelper();
        AxesWalker first = null;
        int nWaiting = this.m_lpi.getWaitingCount();
        int i = this.m_lpi.m_waitingBottom;
        while (i < nWaiting) {
            AxesWalker ws = this.m_lpi.getWaiting(i);
            if (first == null) {
                first = ws;
            } else if (!dh.isNodeAfter(ws.m_currentNode, first.m_currentNode)) {
                first = ws;
            }
            ++i;
        }
        if (first != null) {
            this.m_lpi.removeFromWaitList(first);
            super.printEntryDebug();
        }
        return first;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return this;
    }

    public int getLastPos(XPathContext xctxt) {
        AxesWalker walker;
        int pos = this.getProximityPosition();
        try {
            walker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        walker.setPredicateCount(walker.getPredicateCount() - 1);
        walker.setNextWalker(null);
        walker.setPrevWalker(null);
        LocPathIterator lpi = walker.getLocPathIterator();
        AxesWalker savedWalker = lpi.getLastUsedWalker();
        try {
            Node next;
            lpi.setLastUsedWalker(walker);
            while ((next = walker.nextNode()) != null) {
                ++pos;
            }
        }
        finally {
            Object var7_7 = null;
            lpi.setLastUsedWalker(savedWalker);
        }
        return pos;
    }

    protected int getLevelMax() {
        return 0;
    }

    protected int getNextLevelAmount() {
        return this.m_nextLevelAmount;
    }

    protected Node getNextNode() {
        Node current;
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if ((current = this.getCurrentNode()).isSupported(FEATURE_NODETESTFILTER, "1.0")) {
            ((NodeTestFilter)((Object)current)).setNodeTest(this);
        }
        Node next = this.firstChild();
        while (next == null) {
            Node p;
            next = this.nextSibling();
            if (next == null && (p = this.parentNode()) == null) break;
        }
        if (next == null) {
            this.m_isDone = true;
        }
        return next;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public Node getRoot() {
        return this.m_root;
    }

    protected int getStepType() {
        return this.m_stepType;
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        this.m_stepType = stepType;
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_argLen = compiler.getArgLength(opPos);
                break;
            }
            default: {
                this.m_argLen = compiler.getArgLengthOfStep(opPos);
            }
        }
        this.initPredicateInfo(compiler, opPos);
    }

    boolean isAncestorOfRootContext(Node n) {
        Node parent = this.m_root;
        while ((parent = parent.getParentNode()) != null) {
            if (!parent.equals(n)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFastWalker() {
        return false;
    }

    boolean isWaiting(AxesWalker walker) {
        int nWaiting = this.m_lpi.getWaitingCount();
        int i = this.m_lpi.m_waitingBottom;
        while (i < nWaiting) {
            AxesWalker ws = this.m_lpi.getWaiting(i);
            if (ws == walker) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Node lastChild() {
        throw new RuntimeException("lastChild not supported!");
    }

    public Node nextNode() {
        Node nextNode = null;
        AxesWalker walker = this.m_lpi.getLastUsedWalker();
        this.m_didSwitch = false;
        boolean processWaiters = true;
        while (true) {
            if (processWaiters) {
                AxesWalker waiting = this.checkWaiting(walker);
                if (this.m_didSwitch) {
                    this.m_didSwitch = false;
                    walker = waiting;
                } else if (walker != null && (waiting = this.checkNeedsToWait(walker)) != walker) {
                    walker = waiting;
                    continue;
                }
            } else {
                processWaiters = true;
            }
            if (walker != null) {
                nextNode = walker.getNextNode();
                if (nextNode == null) {
                    walker = walker.m_prevWalker;
                    if (walker != null) {
                        walker.printEntryDebug();
                        continue;
                    }
                    walker = this.getEarliestWaiting();
                    if (walker == null) continue;
                    processWaiters = false;
                    continue;
                }
                if (walker.acceptNode(nextNode) != 1) continue;
                if (walker.m_nextWalker == null) {
                    this.m_lpi.setLastUsedWalker(walker);
                } else {
                    AxesWalker prev = walker;
                    walker = walker.m_nextWalker;
                    if (this.isWaiting(walker)) {
                        try {
                            walker = (AxesWalker)walker.clone();
                            walker.setRoot(nextNode);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    } else {
                        walker.setRoot(nextNode);
                    }
                    walker.m_prevWalker = prev;
                    walker.printEntryDebug();
                    continue;
                }
            }
            if (nextNode == null || this.m_prevReturned == null || nextNode.getOwnerDocument() != this.m_prevReturned.getOwnerDocument() || !this.m_lpi.getDOMHelper().isNodeAfter(nextNode, this.m_prevReturned)) break;
        }
        this.m_prevReturned = nextNode;
        return nextNode;
    }

    public Node nextSibling() {
        return null;
    }

    public Node parentNode() {
        return null;
    }

    public Node previousNode() {
        throw new RuntimeException("previousNode not supported!");
    }

    public Node previousSibling() {
        throw new RuntimeException("previousSibling not supported!");
    }

    private void printDebug(String s) {
    }

    private void printDebugAdd(String s) {
    }

    private void printEntryDebug() {
    }

    private void printWaiters() {
    }

    private Node returnNextNode(Node n) {
        return n;
    }

    protected Node setCurrentIfNotNull(Node currentNode) throws DOMException {
        if (currentNode != null) {
            this.m_currentNode = currentNode;
        }
        return currentNode;
    }

    public void setCurrentNode(Node currentNode) throws DOMException {
        this.m_currentNode = currentNode;
    }

    public void setNextWalker(AxesWalker walker) {
        this.m_nextWalker = walker;
    }

    public void setPrevWalker(AxesWalker walker) {
        this.m_prevWalker = walker;
    }

    public void setRoot(Node root) {
        this.m_isFresh = true;
        this.m_isDone = false;
        this.m_root = root;
        this.m_currentNode = root;
        this.m_prevReturned = null;
        if (root == null) {
            throw new RuntimeException("\n !!!! Error! Setting the root of a walker to null!!!");
        }
        this.resetProximityPositions();
    }

    public String toString() {
        String currentNodeName;
        String rootName;
        Class<?> cl = this.getClass();
        String clName = cl.getName();
        StringTokenizer tokenizer = new StringTokenizer(clName, ".");
        while (tokenizer.hasMoreTokens()) {
            clName = tokenizer.nextToken();
        }
        try {
            rootName = this.m_root == null ? "null" : String.valueOf(this.m_root.getNodeName()) + "{" + ((Child)this.m_root).getUid() + "}";
            currentNodeName = this.m_root == null ? "null" : String.valueOf(this.m_currentNode.getNodeName()) + "{" + ((Child)this.m_currentNode).getUid() + "}";
        }
        catch (ClassCastException classCastException) {
            rootName = this.m_root == null ? "null" : this.m_root.getNodeName();
            currentNodeName = this.m_root == null ? "null" : this.m_currentNode.getNodeName();
        }
        return String.valueOf(clName) + "[" + rootName + "][" + currentNodeName + "]";
    }
}

