/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.ObjectPool;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class UnionPathIterator
extends Expression
implements Cloneable,
NodeIterator,
ContextNodeList {
    transient ObjectPool m_pool = new ObjectPool(this.getClass());
    transient NodeSet m_cachedNodes = null;
    protected transient int m_next = 0;
    transient Node m_lastFetched;
    protected transient boolean m_foundLast = false;
    protected transient XPathContext m_execContext;
    protected transient Node m_context;
    protected transient Node m_currentContextNode;
    protected LocPathIterator[] m_iterators;
    private transient int m_last = 0;

    public UnionPathIterator() {
        this.m_iterators = null;
    }

    public UnionPathIterator(Compiler compiler, int opPos) throws TransformerException {
        opPos = OpMap.getFirstChildPos(opPos);
        this.loadLocationPaths(compiler, opPos, 0);
    }

    public void addIterator(LocPathIterator iter) {
        if (this.m_iterators == null) {
            this.m_iterators = new LocPathIterator[1];
            this.m_iterators[0] = iter;
        } else {
            LocPathIterator[] iters = this.m_iterators;
            int len = this.m_iterators.length;
            this.m_iterators = new LocPathIterator[len + 1];
            System.arraycopy(iters, 0, this.m_iterators, 0, len);
            this.m_iterators[len] = iter;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)super.clone();
        int n = this.m_iterators.length;
        clone.m_iterators = new LocPathIterator[n];
        int i = 0;
        while (i < n) {
            clone.m_iterators[i] = (LocPathIterator)this.m_iterators[i].clone();
            ++i;
        }
        return clone;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)this.clone();
        clone.reset();
        return clone;
    }

    protected LocPathIterator createLocPathIterator(Compiler compiler, int opPos) throws TransformerException {
        LocPathIterator lpi = WalkerFactory.newLocPathIterator(compiler, opPos);
        if (compiler.getLocationPathDepth() <= 0) {
            lpi.setIsTopLevel(true);
        }
        return lpi;
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_context = null;
        int n = this.m_iterators.length;
        int i = 0;
        while (i < n) {
            this.m_iterators[i].detach();
            ++i;
        }
        this.m_pool.freeInstance(this);
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        try {
            UnionPathIterator clone = (UnionPathIterator)this.m_pool.getInstanceIfFree();
            if (clone == null) {
                clone = (UnionPathIterator)this.clone();
            }
            clone.initContext(xctxt);
            return new XNodeSet(clone);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public int getLast() {
        return this.m_last;
    }

    public Node getRoot() {
        return this.m_context;
    }

    public int getWhatToShow() {
        return -17;
    }

    public void initContext(XPathContext execContext) {
        this.m_execContext = execContext;
        this.m_currentContextNode = execContext.getCurrentExpressionNode();
        this.m_context = execContext.getCurrentNode();
        if (this.m_iterators != null) {
            int n = this.m_iterators.length;
            int i = 0;
            while (i < n) {
                this.m_iterators[i].initContext(execContext);
                this.m_iterators[i].nextNode();
                ++i;
            }
        }
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    protected void loadLocationPaths(Compiler compiler, int opPos, int count) throws TransformerException {
        int steptype = compiler.getOpMap()[opPos];
        if (steptype == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
            this.m_iterators[count] = this.createLocPathIterator(compiler, opPos);
        } else {
            switch (steptype) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
                    LocPathIterator iter = new LocPathIterator(compiler.getNamespaceContext());
                    if (compiler.getLocationPathDepth() <= 0) {
                        iter.setIsTopLevel(true);
                    }
                    iter.m_firstWalker = new FilterExprWalker(iter);
                    iter.m_firstWalker.init(compiler, opPos, steptype);
                    this.m_iterators[count] = iter;
                    break;
                }
                default: {
                    this.m_iterators = new LocPathIterator[count];
                }
            }
        }
    }

    public Node nextNode() throws DOMException {
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            return this.m_cachedNodes.nextNode();
        }
        if (this.m_foundLast) {
            return null;
        }
        Node earliestNode = null;
        if (this.m_iterators != null) {
            int n = this.m_iterators.length;
            int iteratorUsed = -1;
            int i = 0;
            while (i < n) {
                Node node = this.m_iterators[i].getCurrentNode();
                if (node != null) {
                    if (earliestNode == null) {
                        iteratorUsed = i;
                        earliestNode = node;
                    } else if (node.equals(earliestNode)) {
                        this.m_iterators[i].nextNode();
                    } else {
                        DOMHelper dh = this.m_execContext.getDOMHelper();
                        if (dh.isNodeAfter(node, earliestNode)) {
                            iteratorUsed = i;
                            earliestNode = node;
                        }
                    }
                }
                ++i;
            }
            if (earliestNode != null) {
                this.m_iterators[iteratorUsed].nextNode();
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(earliestNode);
                }
                ++this.m_next;
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = earliestNode;
        return earliestNode;
    }

    public Node previousNode() throws DOMException {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_next = 0;
        this.m_last = 0;
        this.m_lastFetched = null;
        int n = this.m_iterators.length;
        int i = 0;
        while (i < n) {
            this.m_iterators[i].reset();
            this.m_iterators[i].nextNode();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int index) {
        if (!this.m_foundLast && (index < 0 || index > this.m_next)) ** GOTO lbl-1000
        return;
        while (this.m_next < index) lbl-1000:
        // 2 sources

        {
            if ((n = this.nextNode()) == null) continue;
        }
    }

    public void setCurrentPos(int i) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = i;
        this.m_cachedNodes.setCurrentPos(i);
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public void setShouldCacheNodes(boolean b) {
        this.m_cachedNodes = b ? new NodeSet() : null;
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

