/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.assembler;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.metadata.BlockListenerMetaData;
import org.apache.avalon.phoenix.metadata.BlockMetaData;
import org.apache.avalon.phoenix.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.avalon.phoenix.metainfo.BlockInfo;
import org.apache.avalon.phoenix.tools.assembler.AssemblyException;
import org.apache.avalon.phoenix.tools.infobuilder.BlockInfoBuilder;

public class Assembler
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$tools$assembler$Assembler != null ? class$Lorg$apache$avalon$phoenix$tools$assembler$Assembler : (class$Lorg$apache$avalon$phoenix$tools$assembler$Assembler = Assembler.class$("org.apache.avalon.phoenix.tools.assembler.Assembler"))));
    private final BlockInfoBuilder m_builder = new BlockInfoBuilder();
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$tools$assembler$Assembler;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger((Object)this.m_builder);
    }

    public SarMetaData assembleSar(String name, Configuration assembly, File directory, ClassLoader classLoader) throws AssemblyException {
        Configuration[] blockConfig = assembly.getChildren("block");
        BlockMetaData[] blocks = this.buildBlocks(blockConfig, classLoader);
        Configuration[] listenerConfig = assembly.getChildren("block-listener");
        BlockListenerMetaData[] listeners = this.buildBlockListeners(listenerConfig);
        return new SarMetaData(name, directory, blocks, listeners);
    }

    private BlockMetaData[] buildBlocks(Configuration[] blocks, ClassLoader classLoader) throws AssemblyException {
        ArrayList<BlockMetaData> blockSet = new ArrayList<BlockMetaData>();
        int i = 0;
        while (i < blocks.length) {
            BlockMetaData blockMetaData = this.buildBlock(blocks[i], classLoader);
            blockSet.add(blockMetaData);
            ++i;
        }
        return blockSet.toArray(new BlockMetaData[0]);
    }

    private BlockMetaData buildBlock(Configuration block, ClassLoader classLoader) throws AssemblyException {
        try {
            String name = block.getAttribute("name");
            String classname = block.getAttribute("class");
            Configuration[] provides = block.getChildren("provide");
            DependencyMetaData[] roles = this.buildDependencyMetaDatas(provides);
            BlockInfo info = this.getBlockInfo(name, classname, classLoader);
            return new BlockMetaData(name, classname, roles, info);
        }
        catch (ConfigurationException ce) {
            String message = REZ.getString("block-entry-malformed", (Object)block.getLocation(), (Object)ce.getMessage());
            throw new AssemblyException(message);
        }
    }

    private BlockInfo getBlockInfo(String name, String classname, ClassLoader classLoader) throws AssemblyException {
        String resourceName = classname.replace('.', '/') + ".xinfo";
        String notice = REZ.getString("loading-blockinfo", (Object)resourceName);
        this.getLogger().debug(notice);
        URL resource = classLoader.getResource(resourceName);
        if (resource == null) {
            String message = REZ.getString("blockinfo-missing", (Object)name, (Object)resourceName);
            throw new AssemblyException(message);
        }
        DefaultConfigurationBuilder configBuilder = new DefaultConfigurationBuilder();
        try {
            Configuration info = configBuilder.build(resource.toString());
            return this.m_builder.build(classname, info);
        }
        catch (Exception e) {
            String message = REZ.getString("blockinfo-nocreate", (Object)name, (Object)resourceName, (Object)e.getMessage());
            throw new AssemblyException(message, e);
        }
    }

    private BlockListenerMetaData[] buildBlockListeners(Configuration[] listeners) throws AssemblyException {
        ArrayList<BlockListenerMetaData> listenersMetaData = new ArrayList<BlockListenerMetaData>();
        int i = 0;
        while (i < listeners.length) {
            BlockListenerMetaData listener = this.buildBlockListener(listeners[i]);
            listenersMetaData.add(listener);
            ++i;
        }
        return listenersMetaData.toArray(new BlockListenerMetaData[0]);
    }

    private BlockListenerMetaData buildBlockListener(Configuration listener) throws AssemblyException {
        try {
            String name = listener.getAttribute("name");
            String className = listener.getAttribute("class");
            return new BlockListenerMetaData(name, className);
        }
        catch (ConfigurationException ce) {
            String message = REZ.getString("listener-entry-malformed", (Object)listener.getLocation(), (Object)ce.getMessage());
            throw new AssemblyException(message);
        }
    }

    private DependencyMetaData[] buildDependencyMetaDatas(Configuration[] provides) throws ConfigurationException {
        ArrayList<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
        int j = 0;
        while (j < provides.length) {
            Configuration provide = provides[j];
            String requiredName = provide.getAttribute("name");
            String role = provide.getAttribute("role");
            dependencies.add(new DependencyMetaData(requiredName, role));
            ++j;
        }
        return dependencies.toArray(new DependencyMetaData[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

