/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.infobuilder;

import java.util.ArrayList;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.Version;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.metainfo.BlockDescriptor;
import org.apache.avalon.phoenix.metainfo.BlockInfo;
import org.apache.avalon.phoenix.metainfo.DependencyDescriptor;
import org.apache.avalon.phoenix.metainfo.ServiceDescriptor;

public final class BlockInfoBuilder
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$tools$infobuilder$BlockInfoBuilder != null ? class$Lorg$apache$avalon$phoenix$tools$infobuilder$BlockInfoBuilder : (class$Lorg$apache$avalon$phoenix$tools$infobuilder$BlockInfoBuilder = BlockInfoBuilder.class$("org.apache.avalon.phoenix.tools.infobuilder.BlockInfoBuilder"))));
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$tools$infobuilder$BlockInfoBuilder;

    public BlockInfo build(String classname, Configuration info) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("creating-blockinfo", (Object)classname);
            this.getLogger().debug(message);
        }
        Configuration configuration = null;
        configuration = info.getChild("services");
        ServiceDescriptor[] services = this.buildServices(configuration);
        configuration = info.getChild("dependencies");
        DependencyDescriptor[] dependencies = this.buildDependencies(classname, configuration);
        configuration = info.getChild("block");
        BlockDescriptor descriptor = this.buildBlockDescriptor(classname, configuration);
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("blockinfo-created", (Object)classname, (Object)new Integer(services.length), (Object)new Integer(dependencies.length));
            this.getLogger().debug(message);
        }
        return new BlockInfo(descriptor, services, dependencies);
    }

    private DependencyDescriptor[] buildDependencies(String classname, Configuration configuration) throws ConfigurationException {
        Configuration[] elements = configuration.getChildren("dependency");
        ArrayList<DependencyDescriptor> dependencies = new ArrayList<DependencyDescriptor>();
        int i = 0;
        while (i < elements.length) {
            DependencyDescriptor dependency = this.buildDependency(classname, elements[i]);
            dependencies.add(dependency);
            ++i;
        }
        return dependencies.toArray(new DependencyDescriptor[0]);
    }

    private DependencyDescriptor buildDependency(String classname, Configuration dependency) throws ConfigurationException {
        ServiceDescriptor service = this.buildService(dependency.getChild("service"));
        String role = dependency.getChild("role").getValue(null);
        if (role == null) {
            role = service.getName();
        } else if (role.equals(service.getName())) {
            String message = REZ.getString("redundent-role", (Object)classname, (Object)role);
            this.getLogger().warn(message);
        }
        return new DependencyDescriptor(role, service);
    }

    private ServiceDescriptor[] buildServices(Configuration servicesSet) throws ConfigurationException {
        Configuration[] elements = servicesSet.getChildren("service");
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        int i = 0;
        while (i < elements.length) {
            ServiceDescriptor service = this.buildService(elements[i]);
            services.add(service);
            ++i;
        }
        return services.toArray(new ServiceDescriptor[0]);
    }

    private ServiceDescriptor buildService(Configuration service) throws ConfigurationException {
        String name = service.getAttribute("name");
        Version version = this.buildVersion(service.getAttribute("version"));
        return new ServiceDescriptor(name, version);
    }

    private BlockDescriptor buildBlockDescriptor(String classname, Configuration block) throws ConfigurationException {
        if (block.getChildren().length == 0) {
            String message = REZ.getString("missing-block", (Object)classname);
            this.getLogger().warn(message);
            System.err.println(message);
            return null;
        }
        Version version = this.buildVersion(block.getChild("version").getValue());
        return new BlockDescriptor(classname, version);
    }

    private Version buildVersion(String version) throws ConfigurationException {
        return Version.getVersion((String)version);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

