/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.io.ExtensionFileFilter;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.tools.installer.FileDigest;
import org.apache.avalon.phoenix.tools.installer.Installation;
import org.apache.avalon.phoenix.tools.installer.InstallationException;

public class Installer
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$Lorg$apache$avalon$phoenix$tools$installer$Installer != null ? class$Lorg$apache$avalon$phoenix$tools$installer$Installer : (class$Lorg$apache$avalon$phoenix$tools$installer$Installer = Installer.class$("org.apache.avalon.phoenix.tools.installer.Installer"))));
    private static final String OLD_ASSEMBLY_XML = "conf" + File.separator + "assembly.xml";
    private static final String OLD_CONFIG_XML = "conf" + File.separator + "config.xml";
    private static final String OLD_SERVER_XML = "conf" + File.separator + "server.xml";
    private static final String OLD_BLOCKS = "blocks";
    private static final String OLD_LIB = "lib";
    private static final String META_INF = "META-INF";
    private static final String SAR_INF = "SAR-INF";
    private static final String LIB = "SAR-INF/lib";
    private static final String CLASSES = "SAR-INF/classes/";
    private static final String ASSEMBLY_XML = "SAR-INF/assembly.xml";
    private static final String CONFIG_XML = "SAR-INF/config.xml";
    private static final String SERVER_XML = "SAR-INF/server.xml";
    private static final String ENV_XML = "SAR-INF/environment.xml";
    private static final String FS_CONFIG_XML = "SAR-INF" + File.separator + "config.xml";
    private static final String FS_SERVER_XML = "SAR-INF" + File.separator + "server.xml";
    private static final String FS_ENV_XML = "SAR-INF" + File.separator + "environment.xml";
    private static /* synthetic */ Class class$Lorg$apache$avalon$phoenix$tools$installer$Installer;

    public void uninstall(Installation installation) throws InstallationException {
        FileDigest[] infos = installation.getFileDigests();
        CRC32 checksum = new CRC32();
        if (infos != null) {
            int i = 0;
            while (i < infos.length) {
                File file = infos[i].getFile();
                File parent = file.getParentFile();
                String message = REZ.getString("skip-removal", (Object)file);
                if (file.exists()) {
                    if (file.lastModified() <= installation.getTimestamp()) {
                        this.getLogger().debug(message);
                    } else {
                        this.checksum(file, checksum);
                        if (checksum.getValue() != infos[i].getChecksum()) {
                            this.getLogger().debug(message);
                        } else {
                            file.delete();
                            if (parent.list().length == 0) {
                                parent.delete();
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checksum(File file, Checksum checksum) {
        checksum.reset();
        CheckedInputStream input = null;
        try {
            try {
                input = new CheckedInputStream(new FileInputStream(file), checksum);
                IOUtil.toByteArray((InputStream)input);
            }
            catch (IOException ioe) {
                String message = REZ.getString("checksum-failure", (Object)file);
                this.getLogger().warn(message);
                Object var5_5 = null;
                IOUtil.shutdownStream((InputStream)input);
                return;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            IOUtil.shutdownStream(input);
            throw throwable;
        }
        IOUtil.shutdownStream((InputStream)input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Installation install(URL url) throws InstallationException {
        Installation installation;
        block7: {
            Installation installation2;
            block6: {
                this.lock();
                try {
                    try {
                        String notice = REZ.getString("installing-sar", (Object)url);
                        this.getLogger().info(notice);
                        File file = this.getFileFor(url);
                        if (file.isDirectory()) {
                            String message = REZ.getString("deprecated-sar-format", (Object)url);
                            System.err.println(message);
                            this.getLogger().warn(message);
                            Installation installation3 = this.installDeprecated(file);
                            Object var3_11 = null;
                            this.unlock();
                            return installation3;
                        }
                        ZipFile zipFile = new ZipFile(file);
                        if (this.isDeprecated(zipFile)) {
                            String message = REZ.getString("deprecated-sar-format", (Object)url);
                            System.err.println(message);
                            this.getLogger().warn(message);
                            installation2 = this.installDeprecated(url, file, zipFile);
                            break block6;
                        }
                        installation = this.install(url, file, zipFile);
                        break block7;
                    }
                    catch (IOException ioe) {
                        String message = REZ.getString("bad-zip-file", (Object)url);
                        throw new InstallationException(message, ioe);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_14 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            Object var3_12 = null;
            this.unlock();
            return installation2;
        }
        Object var3_13 = null;
        this.unlock();
        return installation;
    }

    private boolean isDeprecated(ZipFile zipFile) throws InstallationException {
        String message;
        boolean oldStyle = false;
        boolean newStyle = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = this.fixName(entry.getName());
            if (name.startsWith(OLD_BLOCKS) || name.startsWith(OLD_LIB) || name.equals("conf/assembly.xml") || name.equals("conf/config.xml") || name.equals("conf/server.xml")) {
                oldStyle = true;
            }
            if (!name.startsWith(SAR_INF)) continue;
            newStyle = true;
        }
        if (oldStyle && newStyle) {
            message = REZ.getString("mixed-sar");
            throw new InstallationException(message);
        }
        if (!oldStyle && !newStyle) {
            message = REZ.getString("invalid-sar");
            throw new InstallationException(message);
        }
        return oldStyle;
    }

    private void lock() {
    }

    private void unlock() {
    }

    private Installation install(URL url, File file, ZipFile zipFile) throws InstallationException {
        File directory = this.getDestinationFor(file);
        directory.mkdirs();
        String baseURL = "sar:/";
        ArrayList digests = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = this.fixName(entry.getName());
            boolean expand = true;
            boolean isJar = false;
            boolean classesAdded = false;
            if (name.startsWith(SAR_INF) && !name.equals(SERVER_XML) && !name.equals(ENV_XML) && !name.equals(CONFIG_XML)) {
                expand = false;
                if (!classesAdded && name.startsWith(CLASSES)) {
                    String classes = "jar:" + this.getURLAsString(file) + "!/" + CLASSES;
                    jars.add(classes);
                    expand = false;
                }
                if (name.startsWith(LIB) && name.endsWith(".jar") && LIB.length() == name.lastIndexOf("/")) {
                    isJar = true;
                    expand = true;
                }
            }
            if (name.startsWith(META_INF)) {
                expand = false;
            }
            if (!expand) continue;
            File destination = new File(directory, name);
            if (!destination.exists()) {
                this.expandZipEntry(zipFile, entry, destination, digests);
            } else {
                String message = REZ.getString("file-in-the-way", (Object)url, (Object)name, (Object)directory);
                this.getLogger().warn(message);
            }
            if (!isJar) continue;
            jars.add(this.getURLAsString(destination));
        }
        File envFile = new File(directory, FS_ENV_XML);
        if (!envFile.exists()) {
            String message = REZ.getString("deprecated-environment-xml", (Object)url);
            System.err.println(message);
            this.getLogger().warn(message);
            envFile = new File(directory, FS_SERVER_XML);
        }
        String[] classPath = jars.toArray(new String[0]);
        String assembly = "jar:" + this.getURLAsString(file) + "!/" + ASSEMBLY_XML;
        String config = this.getURLAsString(new File(directory, FS_CONFIG_XML));
        String environment = this.getURLAsString(envFile);
        FileDigest[] fileDigests = digests.toArray(new FileDigest[0]);
        long timestamp = System.currentTimeMillis();
        return new Installation(file, directory, config, assembly, environment, classPath, fileDigests, timestamp);
    }

    private String fixName(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private Installation installDeprecated(URL url, File file, ZipFile zipFile) throws InstallationException {
        ArrayList digests = new ArrayList();
        File directory = this.getDestinationFor(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String name;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = this.fixName(entry.getName())).startsWith(META_INF)) continue;
            File destination = new File(directory, name);
            if (!destination.exists()) {
                this.expandZipEntry(zipFile, entry, destination, digests);
                continue;
            }
            String message = REZ.getString("file-in-the-way", (Object)url, (Object)name, (Object)directory);
            this.getLogger().warn(message);
        }
        String[] classPath = this.getClassPathForDirectory(directory);
        String config = this.getURLAsString(new File(directory, OLD_CONFIG_XML));
        String assembly = this.getURLAsString(new File(directory, OLD_ASSEMBLY_XML));
        String server = this.getURLAsString(new File(directory, OLD_SERVER_XML));
        FileDigest[] fileDigests = digests.toArray(new FileDigest[0]);
        long timestamp = System.currentTimeMillis();
        return new Installation(file, directory, config, assembly, server, classPath, fileDigests, timestamp);
    }

    private Installation installDeprecated(File directory) throws InstallationException {
        String[] classPath = this.getClassPathForDirectory(directory);
        String config = this.getURLAsString(new File(directory, OLD_CONFIG_XML));
        String assembly = this.getURLAsString(new File(directory, OLD_ASSEMBLY_XML));
        String server = this.getURLAsString(new File(directory, OLD_SERVER_XML));
        long timestamp = System.currentTimeMillis();
        return new Installation(directory, directory, config, assembly, server, classPath, null, timestamp);
    }

    private File getFileFor(URL url) throws InstallationException {
        if (!url.getProtocol().equals("file")) {
            String message = REZ.getString("install-nonlocal", (Object)url);
            throw new InstallationException(message);
        }
        File file = new File(url.getFile());
        if (!(file = file.getAbsoluteFile()).exists()) {
            String message = REZ.getString("install-nourl", (Object)file);
            throw new InstallationException(message);
        }
        return file;
    }

    private void expandZipEntry(ZipFile zipFile, ZipEntry entry, File file, ArrayList digests) throws InstallationException {
        if (entry.isDirectory()) {
            return;
        }
        InputStream input = null;
        FileOutputStream output = null;
        try {
            try {
                file.getParentFile().mkdirs();
                output = new FileOutputStream(file);
                input = zipFile.getInputStream(entry);
                IOUtil.copy((InputStream)input, (OutputStream)output);
            }
            catch (IOException ioe) {
                String message = REZ.getString("failed-to-expand", (Object)entry.getName(), (Object)file, (Object)ioe.getMessage());
                throw new InstallationException(message, ioe);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            IOUtil.shutdownStream(input);
            IOUtil.shutdownStream(output);
            throw throwable;
        }
        IOUtil.shutdownStream((InputStream)input);
        IOUtil.shutdownStream((OutputStream)output);
        long checksum = entry.getCrc();
        long modified = file.lastModified();
        FileDigest info = new FileDigest(file, checksum);
        digests.add(info);
    }

    private File getDestinationFor(File file) {
        String base = FileUtil.removeExtension((String)FileUtil.removePath((String)file.getName()));
        return new File(file.getParentFile(), base).getAbsoluteFile();
    }

    private String[] getClassPathForDirectory(File directory) {
        File blockDir = new File(directory, OLD_BLOCKS);
        File libDir = new File(directory, OLD_LIB);
        ArrayList urls = new ArrayList();
        this.getURLsAsStrings(urls, blockDir, new String[]{".bar"});
        this.getURLsAsStrings(urls, libDir, new String[]{".jar", ".zip"});
        return urls.toArray(new String[0]);
    }

    private void getURLsAsStrings(ArrayList urls, File directory, String[] extensions) {
        ExtensionFileFilter filter = new ExtensionFileFilter(extensions);
        File[] files = directory.listFiles((FilenameFilter)filter);
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            urls.add(this.getURLAsString(files[i]));
            ++i;
        }
    }

    private String getURLAsString(File file) {
        try {
            return file.toURL().toExternalForm();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

