/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.util.Vector;
import org.media.mn8.ConceptConceptDefinition;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.FieldConcept;
import org.media.mn8.FieldDefinition;
import org.media.mn8.Helper;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.AttributeSeries;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TransparentElement;
import org.media.mn8.concepts.TypedSeries;
import org.media.mn8.event.AttributeNotFoundException;
import org.media.mn8.event.ElementNotFoundException;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8Method;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.util.ConceptNavPatterns;

public abstract class Concept {
    protected String _conceptLabel = null;
    protected boolean _isHidden = false;
    protected boolean _showEmpty = true;
    private Concept _errorHandler = null;

    public Concept getConceptNamed(StringConcept name) {
        return mn8Loader.instantiateConcept(name.toString());
    }

    public StringConcept getConceptLabel() {
        if (this._conceptLabel == null) {
            this._conceptLabel = this.getConceptDefinition().getConceptLabel().toString();
        }
        return new StringConcept(this._conceptLabel);
    }

    public void setConceptLabel(StringConcept label) {
        this._conceptLabel = label.toString();
    }

    public StringConcept getConceptType() {
        if (this.getConceptDefinition() != null) {
            return this.getConceptDefinition().getConceptType();
        }
        return new StringConcept("Concept");
    }

    public LogicalConcept isHidden() {
        return new LogicalConcept(this._isHidden);
    }

    public void setHidden(LogicalConcept isHidden) {
        this._isHidden = isHidden.getValue();
    }

    public LogicalConcept showEmpty() {
        return new LogicalConcept(this._showEmpty);
    }

    public void setShowEmpty(LogicalConcept showEmpty) {
        this._showEmpty = showEmpty.getValue();
    }

    public SeriesConcept getConceptAttributes() {
        AttributeSeries attributes = new AttributeSeries();
        Vector attributeFields = this.getConceptAttributeFields().getVector();
        int i = 0;
        while (i < attributeFields.size()) {
            attributes.add(this.getConceptAttribute(((FieldDefinition)attributeFields.elementAt(i)).getName()));
            ++i;
        }
        return attributes;
    }

    public LogicalConcept hasConceptAttribute(StringConcept attributeName) {
        return new LogicalConcept(this.hasConceptAttribute(attributeName.toString()));
    }

    public boolean hasConceptAttribute(String attributeName) {
        return this.getConceptDefinition().hasConceptAttribute(attributeName);
    }

    public Concept getConceptAttribute(StringConcept attributeName) {
        return this.getConceptAttribute(attributeName.toString());
    }

    public Concept getConceptAttribute(String attributeName) {
        FieldDefinition field;
        if (this.hasConceptAttribute(attributeName) && (field = this.getConceptAttributeField(attributeName)) != null) {
            return field.getValue(this);
        }
        throw new AttributeNotFoundException(this.getConceptType().toString(), attributeName);
    }

    public FieldDefinition getConceptAttributeField(StringConcept attributeName) {
        return this.getConceptAttributeField(attributeName.toString());
    }

    public FieldDefinition getConceptAttributeField(String attributeName) {
        return this.getConceptDefinition().getConceptAttributeField(attributeName);
    }

    public SeriesConcept getConceptAttributeFields() {
        return this.getConceptDefinition().getConceptAttributeFields();
    }

    public LogicalConcept hasConceptMethod(StringConcept methodSignature) {
        if (this.getConceptDefinition() != null) {
            return this.getConceptDefinition().hasConceptMethod(methodSignature);
        }
        return LogicalConcept.FALSE;
    }

    public SeriesConcept getConceptElements() {
        SeriesConcept elements = new SeriesConcept();
        Vector elementFields = this.getConceptElementFields().getVector();
        int i = 0;
        while (i < elementFields.size()) {
            elements.add(this.getConceptElement(((FieldDefinition)elementFields.elementAt(i)).getName()));
            ++i;
        }
        return elements;
    }

    public LogicalConcept hasConceptElement(StringConcept elementName) {
        return new LogicalConcept(this.hasConceptElement(elementName.toString()));
    }

    public boolean hasConceptElement(String elementName) {
        return this.getConceptDefinition().hasConceptElement(elementName);
    }

    public Concept getConceptElement(StringConcept elementName) {
        return this.getConceptElement(elementName.toString());
    }

    public Concept getConceptElement(String elementName) {
        if (this.hasConceptElement(elementName)) {
            FieldDefinition field = this.getConceptElementField(elementName);
            return field.getValue(this);
        }
        throw new ElementNotFoundException(this.getConceptType().toString(), elementName);
    }

    public FieldDefinition getConceptElementField(String elementName) {
        return this.getConceptDefinition().getConceptElementField(elementName);
    }

    public SeriesConcept getConceptElementFields() {
        return this.getConceptDefinition().getConceptElementFields();
    }

    public SeriesConcept getConceptMethods() {
        return this.getConceptDefinition().getConceptMethods();
    }

    public SeriesConcept getConceptConstructors() {
        return this.getConceptDefinition().getConceptConstructors();
    }

    public SeriesConcept getConceptOperators() {
        return this.getConceptDefinition().getConceptOperators();
    }

    public Concept getConceptInstance() {
        return this.getConceptDefinition().getConceptInstance();
    }

    public SeriesConcept getInheritedConcepts() {
        return this.getConceptDefinition().getInheritedConcepts();
    }

    public SeriesConcept getAllInheritedConcepts() {
        return this.getConceptDefinition().getAllInheritedConcepts();
    }

    public final LogicalConcept extendsConcept(StringConcept conceptType) {
        return this.getConceptDefinition().extendsConcept(conceptType);
    }

    public final mn8Method getConceptMethod(StringConcept methodSignature) {
        return this.getConceptDefinition().getConceptMethod(methodSignature);
    }

    public abstract StringConcept toXML();

    public abstract StringConcept toTXT();

    public ConceptDefinition getConceptDefinition() {
        return ConceptConceptDefinition.getReference();
    }

    public void loadContent(Concept from) {
        if (from == null) {
            return;
        }
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("--> in concept:" + Helper.getConceptInfo(this) + "->" + Helper.getConceptInfo(from));
        }
        Helper.loadAttributes(from, this);
        Vector elementes = from.getConceptElements().getVector();
        ElementConcept elem = null;
        Vector localElements = this.getConceptElements().getVector();
        ElementConcept localElem = null;
        int i = 0;
        while (i < elementes.size()) {
            elem = (ElementConcept)elementes.elementAt(i);
            int j = 0;
            while (j < localElements.size()) {
                localElem = (ElementConcept)localElements.elementAt(j);
                if (localElem.getLabel().toString().equalsIgnoreCase(elem.getLabel().getValue())) {
                    localElem.loadContent(elem);
                    localElements.set(j, localElem);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public LogicalConcept hasPath(StringConcept path) {
        return this.hasPath(path.toString());
    }

    public SeriesConcept getConceptsAtPath(StringConcept path) {
        return this.getConceptsAtPath(new SeriesConcept(), path.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SeriesConcept getConceptsAtPath(SeriesConcept holder, String fullpath) {
        String firstItem = ConceptNavPatterns.getFirstItem(fullpath);
        String remainingItems = ConceptNavPatterns.getRemainingItems(fullpath);
        if (ConceptNavPatterns.isAbsolutePath(firstItem)) {
            if (ConceptNavPatterns.isAttribute(firstItem)) {
                if (!this.hasConceptAttribute(ConceptNavPatterns.getAttributeName(firstItem))) return holder;
                if (remainingItems != null) return this.subAttributeGetConcept(holder, ConceptNavPatterns.getAttributeName(firstItem), remainingItems);
                holder.add(this.getAttributeValue(ConceptNavPatterns.getAttributeName(firstItem)));
                return holder;
            }
            if (!this.areThereMoreElemenents(ConceptNavPatterns.getElementName(firstItem))) return holder;
            Vector elm = this.getMeAllElements(ConceptNavPatterns.getElementName(firstItem));
            if (remainingItems == null) {
                int i = 0;
                while (i < elm.size()) {
                    holder.add((Concept)elm.elementAt(i));
                    ++i;
                }
                return holder;
            } else {
                int i = 0;
                while (i < elm.size()) {
                    holder = ((Concept)elm.elementAt(i)).getConceptsAtPath(holder, (remainingItems.indexOf("@") == 0 ? "/" : "") + remainingItems);
                    ++i;
                }
            }
            return holder;
        }
        if (ConceptNavPatterns.isAttribute(firstItem)) {
            if (!this.hasConceptAttribute(ConceptNavPatterns.getAttributeName(firstItem))) return this.searchDeeperForPath(holder, fullpath);
            if (remainingItems != null) return this.subAttributeGetConcept(holder, ConceptNavPatterns.getAttributeName(firstItem), remainingItems);
            holder.add(this.getAttributeValue(ConceptNavPatterns.getAttributeName(firstItem)));
            return holder;
        } else {
            if (!this.areThereMoreElemenents(ConceptNavPatterns.getElementName(firstItem))) return this.searchDeeperForPath(holder, fullpath);
            Vector elm = this.getMeAllElements(firstItem);
            if (remainingItems == null) {
                int i = 0;
                while (i < elm.size()) {
                    holder.add((Concept)elm.elementAt(i));
                    ++i;
                }
                return holder;
            } else {
                int i = 0;
                while (i < elm.size()) {
                    holder = ((Concept)elm.elementAt(i)).getConceptsAtPath(holder, (remainingItems.indexOf("@") == 0 ? "/" : "") + remainingItems);
                    ++i;
                }
            }
        }
        return holder;
    }

    public SeriesConcept searchDeeperForPath(SeriesConcept holder, String path) {
        SeriesConcept elms = this.getConceptElements();
        int i = 0;
        while (i < elms.getVector().size()) {
            holder = ((Concept)elms.getVector().elementAt(i)).getConceptsAtPath(holder, path);
            ++i;
        }
        return holder;
    }

    public SeriesConcept subElementGetConcepts(SeriesConcept holder, String elementName, String subPath) {
        return this.getConceptElement(elementName).getConceptsAtPath(holder, subPath);
    }

    public SeriesConcept subAttributeGetConcept(SeriesConcept holder, String attributeName, String subPath) {
        return this.getAttributeValue(attributeName).getConceptsAtPath(holder, subPath);
    }

    public LogicalConcept hasPath(String fullpath) {
        String firstItem = ConceptNavPatterns.getFirstItem(fullpath);
        String remainingItems = ConceptNavPatterns.getRemainingItems(fullpath);
        if (ConceptNavPatterns.isAbsolutePath(firstItem)) {
            if (ConceptNavPatterns.isAttribute(firstItem)) {
                if (!this.hasConceptAttribute(new StringConcept(ConceptNavPatterns.getAttributeName(firstItem))).getValue()) {
                    return LogicalConcept.FALSE;
                }
                if (remainingItems == null) {
                    return LogicalConcept.TRUE;
                }
                return this.subAttributeHasPath(ConceptNavPatterns.getAttributeName(firstItem), remainingItems);
            }
            if (!this.hasConceptElement(ConceptNavPatterns.getElementName(firstItem))) {
                return LogicalConcept.FALSE;
            }
            if (remainingItems == null) {
                return LogicalConcept.TRUE;
            }
            return this.subElementHasPath(ConceptNavPatterns.getElementName(firstItem), remainingItems);
        }
        if (ConceptNavPatterns.isAttribute(firstItem)) {
            if (this.hasConceptAttribute(new StringConcept(ConceptNavPatterns.getAttributeName(firstItem))).getValue() && remainingItems == null) {
                return LogicalConcept.TRUE;
            }
            return this.searchSubElements(fullpath);
        }
        if (this.hasConceptElement(ConceptNavPatterns.getElementName(firstItem))) {
            if (remainingItems == null) {
                return LogicalConcept.TRUE;
            }
            return this.subElementHasPath(ConceptNavPatterns.getElementName(firstItem), remainingItems);
        }
        return this.searchSubElements(fullpath);
    }

    protected LogicalConcept searchSubElements(String path) {
        SeriesConcept elements = this.getConceptElements();
        LogicalConcept result = LogicalConcept.FALSE;
        Object elem = null;
        int i = 0;
        while (i < elements.getVector().size()) {
            result = this.subElementHasPath(((ElementConcept)elements.getVector().elementAt(i)).getName().toString(), path);
            if (result.getValue()) {
                return result;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public LogicalConcept subElementHasPath(String elementName, String subPath) {
        void elem;
        if (!this.hasConceptElement(elementName)) {
            return LogicalConcept.FALSE;
        }
        ElementConcept elementConcept = (ElementConcept)this.getConceptElement(elementName);
        return elem.hasPath(subPath);
    }

    protected LogicalConcept subAttributeHasPath(String attribName, String subPath) {
        return this.getConceptAttribute(attribName).hasPath(subPath);
    }

    protected Concept getAttributeValue(String name) {
        Concept concept = this.getConceptAttribute(name);
        if (concept instanceof AttributeConcept) {
            return concept;
        }
        return new NilConcept();
    }

    public boolean areThereMoreElemenents(String path) {
        return this.hasConceptElement(new StringConcept(path)).getValue();
    }

    public Vector getMeAllElements(String path) {
        SeriesConcept elements;
        Concept result = this.getConceptElement(path);
        if (result instanceof TransparentElement && ((TransparentElement)result).getValue() instanceof SeriesConcept) {
            SeriesConcept seriesConcept = (SeriesConcept)((TransparentElement)result).getValue();
        } else {
            elements = new SeriesConcept();
            elements.add(result);
        }
        return elements.getVector();
    }

    public abstract Object clone();

    public Concept cloneConcept() {
        return (Concept)this.clone();
    }

    public void setErrorHandler(Concept handler) {
        this._errorHandler = handler;
    }

    public Concept getErrorHandler() {
        return this._errorHandler;
    }

    public void printFields() {
        this.printFields("", this);
    }

    public void printFields(String pre, Concept con) {
        pre = "  " + pre;
        FieldConcept field = null;
        ElementConcept elem = null;
        ElementConcept innerElem = null;
        int i = 0;
        while (i < con.getConceptElementFields().getVector().size()) {
            field = (FieldConcept)con.getConceptElementFields().getVector().elementAt(i);
            elem = (ElementConcept)con.getConceptElements().getVector().elementAt(i);
            String multi = "";
            if (elem.isMulti().getValue()) {
                multi = "*";
            }
            if (elem instanceof TransparentElement && !elem.getValueType().toString().equalsIgnoreCase("element")) {
                System.err.println(pre + field.toTXT().toString() + multi + "(" + elem.getClass().getName() + "|" + elem.getName() + "|" + elem.getLabel() + "|" + elem.getValueType() + "|" + elem.getValue().getClass().getName() + (elem.getValue() instanceof TypedSeries ? ((TypedSeries)elem.getValue()).getType().toString() : ""));
            } else if (elem.getValue() instanceof ElementConcept) {
                innerElem = (ElementConcept)elem.getValue();
                System.err.println(pre + field.toTXT().toString() + multi + "(" + innerElem.getClass().getName() + "|" + innerElem.getName() + "|" + innerElem.getLabel() + "|" + innerElem.getValueType() + "|" + innerElem.getValue().getClass().getName());
            }
            this.printFields(pre, elem.getValue());
            ++i;
        }
    }
}

