/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptConceptDefinition;
import org.media.mn8.FieldConcept;
import org.media.mn8.FieldDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.Element;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.event.AttributeNotFoundException;
import org.media.mn8.event.ElementNotFoundException;
import org.media.mn8.event.FieldNotFoundException;
import org.media.mn8.event.MethodNotFoundException;
import org.media.mn8.mn8JavaMethod;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8Method;

public abstract class ConceptDefinition {
    private Vector _inheritance = new Vector();
    private Hashtable _methodTable = new Hashtable();
    private Hashtable _cameleonMethodTable;
    private Hashtable _constructorTable = new Hashtable();
    private Hashtable _operationTable = new Hashtable();
    private Vector _elementTable = new Vector();
    private Vector _elementNameTable = new Vector();
    private Hashtable _attributeTable = new Hashtable();

    public abstract StringConcept getConceptLabel();

    public abstract StringConcept getConceptType();

    public abstract SeriesConcept getInheritedConcepts();

    public LogicalConcept hasConceptAttribute(StringConcept attributeName) {
        return new LogicalConcept(this.hasConceptAttribute(attributeName.toString()));
    }

    public boolean hasConceptAttribute(String attributeName) {
        if ((attributeName = attributeName.toLowerCase()).trim().startsWith("@")) {
            attributeName = attributeName.substring(1);
        }
        return this._attributeTable.containsKey(attributeName);
    }

    public Concept getConceptAttribute(Concept on, StringConcept attributeName) {
        if (this._attributeTable.containsKey((attributeName = attributeName.toLowerCase()).getValue())) {
            FieldConcept attribute = (FieldConcept)this._attributeTable.get(attributeName.getValue());
            AttributeConcept attr = (AttributeConcept)attribute.getValue(on);
            return attr;
        }
        throw new AttributeNotFoundException(on.getConceptType().toString(), attributeName.toString());
    }

    public SeriesConcept getConceptElementFields() {
        return new SeriesConcept(this._elementTable);
    }

    public Vector getConceptElementsFieldName() {
        return this._elementNameTable;
    }

    public SeriesConcept getConceptAttributeFields() {
        return new SeriesConcept(new Vector(this._attributeTable.values()));
    }

    public Hashtable getConceptAttributeFieldsAsHashtable() {
        return this._attributeTable;
    }

    public FieldDefinition getConceptAttributeField(StringConcept attributeName) {
        attributeName = attributeName.toLowerCase();
        return this.getConceptAttributeField(attributeName.toString());
    }

    public FieldDefinition getConceptAttributeField(String attributeName) {
        if (this._attributeTable.containsKey(attributeName = attributeName.toLowerCase())) {
            return (FieldDefinition)this._attributeTable.get(attributeName);
        }
        throw new FieldNotFoundException(this.getConceptType().toString(), attributeName);
    }

    public LogicalConcept hasConceptElement(StringConcept elementName) {
        return new LogicalConcept(this.hasConceptElement(elementName.toString()));
    }

    public boolean hasConceptElement(String elementName) {
        return this._elementNameTable.contains(elementName.toLowerCase());
    }

    public Concept getConceptElement(Concept on, StringConcept elementName) {
        if (this._elementNameTable.contains(elementName.getValue().toLowerCase())) {
            FieldConcept element = (FieldConcept)this._elementTable.elementAt(this._elementNameTable.indexOf(elementName.getValue().toLowerCase()));
            Element elem = (Element)((Object)element.getValue(on));
            return elem.getElementValue();
        }
        throw new ElementNotFoundException(on.getConceptType().toString(), elementName.toString());
    }

    public SeriesConcept getConceptMethods() {
        return new SeriesConcept(new Vector(this._methodTable.values()));
    }

    public SeriesConcept getCameleonConceptMethods() {
        if (this._cameleonMethodTable == null) {
            this.initializeCameleonMethodTable();
        }
        return new SeriesConcept(new Vector(this._cameleonMethodTable.values()));
    }

    public SeriesConcept getConceptConstructors() {
        return new SeriesConcept(new Vector(this._constructorTable.values()));
    }

    public SeriesConcept getConceptOperators() {
        return new SeriesConcept(new Vector(this._operationTable.values()));
    }

    public Concept getConceptInstance() {
        return new JavaConcept();
    }

    public Vector getInheritanceList() {
        return this._inheritance;
    }

    public final void putOperator(mn8Method method) {
        this._operationTable.remove(method.getSignature());
        this._operationTable.put(method.getSignature(), method);
    }

    public final void putMethod(mn8Method method) {
        if (method.getName().getValue().toLowerCase().equals("create")) {
            this._constructorTable.remove(method.getSignature().toLowerCase());
            this._constructorTable.put(method.getSignature().toLowerCase(), method);
        } else {
            this._methodTable.remove(method.getSignature().toLowerCase());
            this._methodTable.put(method.getSignature().toLowerCase(), method);
        }
    }

    public final void removeMethod(String methodSignature) {
        if (methodSignature.startsWith("create:")) {
            this._constructorTable.remove(methodSignature);
        } else if (methodSignature.startsWith("op")) {
            this._operationTable.remove(methodSignature);
        } else {
            this._methodTable.remove(methodSignature);
        }
    }

    public mn8Method getConstructor(String methodSignature) {
        return (mn8Method)this._constructorTable.get(methodSignature.toLowerCase());
    }

    public Hashtable getInheritanceMethods() {
        Hashtable result = new Hashtable(this._operationTable);
        result.putAll(this._methodTable);
        return result;
    }

    public void putAttribute(FieldConcept attributeDef) {
        this._attributeTable.put(attributeDef.getName().toLowerCase(), attributeDef);
    }

    public void removeAttribute(String attribName) {
        attribName = attribName.toLowerCase();
        this._attributeTable.remove(attribName);
    }

    public FieldDefinition getAttribute(String attribName) {
        attribName = attribName.toLowerCase();
        return (FieldDefinition)this._attributeTable.get(attribName);
    }

    public FieldDefinition getAttributeField(String attribName) {
        attribName = attribName.toLowerCase();
        return (FieldDefinition)this._attributeTable.get(attribName);
    }

    public void putElement(FieldConcept elementDef) {
        this._elementTable.add(elementDef);
        this._elementNameTable.add(elementDef.getName().toLowerCase());
    }

    public FieldDefinition getElement(String elementName) {
        int idx = this._elementNameTable.indexOf(elementName.toLowerCase());
        if (idx != -1) {
            return (FieldDefinition)this._elementTable.elementAt(idx);
        }
        return null;
    }

    public FieldDefinition getConceptElementField(StringConcept elementName) {
        return this.getConceptElementField(elementName.toString());
    }

    public FieldDefinition getConceptElementField(String elementName) {
        int idx = this._elementNameTable.indexOf(elementName.toLowerCase());
        if (idx != -1) {
            return (FieldDefinition)this._elementTable.elementAt(idx);
        }
        throw new FieldNotFoundException(this.getConceptType().toString(), elementName);
    }

    public final mn8Method getConceptOperator(StringConcept methodSignature) {
        return this.getConceptOperator(methodSignature.getValue());
    }

    public final mn8Method getConceptOperator(String methodSignature) {
        mn8Method result = null;
        result = (mn8Method)this._operationTable.get(methodSignature);
        if (result != null) {
            return result;
        }
        result = mn8JavaMethod.getMethodUsingInheritance(methodSignature, this.getConceptOperators().getValue());
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Unable to find operator with signature: " + methodSignature + " in concept type: " + this.getConceptType());
    }

    public final mn8Method getConceptMethod(StringConcept methodSignature) {
        return this.getConceptMethod(methodSignature.getValue());
    }

    public LogicalConcept hasConceptMethod(StringConcept methodSignature) {
        try {
            if (this.getConceptMethod(methodSignature) != null) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
        catch (RuntimeException ex) {
            return new LogicalConcept(false);
        }
    }

    public final mn8Method getConceptMethod(String methodSignature) {
        methodSignature = methodSignature.toLowerCase();
        mn8Method result = null;
        result = (mn8Method)this._methodTable.get(methodSignature);
        if (result != null) {
            return result;
        }
        result = mn8JavaMethod.getMethodUsingInheritance(methodSignature, this.getConceptMethods().getValue());
        if (result != null) {
            return result;
        }
        throw new MethodNotFoundException(this.getConceptType().toString(), methodSignature);
    }

    public final mn8Method getConceptConstructor(StringConcept methodSignature) {
        return this.getConceptConstructor(methodSignature.toString());
    }

    public final mn8Method getConceptConstructor(String methodSignature) {
        mn8Method result = null;
        result = (mn8Method)this._constructorTable.get(methodSignature);
        if (result != null) {
            return result;
        }
        result = mn8JavaMethod.getMethodUsingInheritance(methodSignature, this.getConceptConstructors().getValue());
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Unable to find constructor with signature: " + methodSignature);
    }

    public final LogicalConcept extendsConcept(StringConcept conceptType) {
        if (conceptType.getValue().toLowerCase().equals("concept")) {
            return new LogicalConcept(true);
        }
        if (conceptType.getValue().toLowerCase().equals(this.getConceptType().getValue().toLowerCase())) {
            return new LogicalConcept(true);
        }
        SeriesConcept select = this.getInheritedConcepts().selectSIMEXP(conceptType.getValue());
        if (select.getValue().size() > 0) {
            return new LogicalConcept(true);
        }
        return new LogicalConcept(false);
    }

    public static void main(String[] args) {
        try {
            Class<?> _class = Class.forName(args[0]);
            Method reference = _class.getDeclaredMethod("getReference", null);
            ConceptConceptDefinition instance = (ConceptConceptDefinition)reference.invoke((Object)reference, null);
            System.out.println("--" + instance.getClass().getName());
            System.out.println(instance.getConceptMethods().toTXT().getValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SeriesConcept getAllInheritedConcepts() {
        Vector<StringConcept> allInheritedConcepts = new Vector<StringConcept>();
        Vector newSet = null;
        allInheritedConcepts.addAll(this.getInheritedConcepts().getVector());
        allInheritedConcepts.remove(new StringConcept("Concept"));
        int cnt = 0;
        while (cnt < allInheritedConcepts.size()) {
            newSet = this.addInheritedConcepts((StringConcept)allInheritedConcepts.elementAt(cnt));
            if (newSet != null && newSet.size() > 0) {
                newSet.remove(new StringConcept("Concept"));
                allInheritedConcepts.addAll(newSet);
            }
            ++cnt;
        }
        allInheritedConcepts.add(new StringConcept("Concept"));
        return new SeriesConcept(allInheritedConcepts);
    }

    private final Vector addInheritedConcepts(StringConcept ofConcept) {
        Vector result = mn8Loader.getConceptDefinition(ofConcept.toString()).getInheritedConcepts().getVector();
        if (result != null && result.size() > 0) {
            return result;
        }
        return null;
    }

    protected void initializeCameleonMethodTable() {
        Enumeration methods = this._methodTable.elements();
        mn8Method method = null;
        this._cameleonMethodTable = new Hashtable();
        while (methods.hasMoreElements()) {
            method = (mn8Method)methods.nextElement();
            if (!(method instanceof mn8JavaMethod) || !method.getDeclaringConcept().toString().equals(this.getConceptType().toString())) continue;
            this._cameleonMethodTable.put(method.getSignature(), method);
        }
    }
}

