/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.util.Enumeration;
import java.util.Hashtable;
import org.media.mn8.Concept;
import org.media.mn8.conf.SystemConceptsTable;
import org.media.mn8.mn8RuntimeFlags;

public class ConceptRegister {
    private static ConceptRegister _instance = new ConceptRegister();
    private static Hashtable _register;

    public static void initialize() {
        _instance = new ConceptRegister();
    }

    public static void cleanAll() {
        _register.clear();
    }

    public static ConceptRegister getReference() {
        return _instance;
    }

    public void register(String name, Object concept) {
        _register.put(name.toLowerCase(), concept);
    }

    public void unregister(String name) {
        _register.remove(name.toLowerCase());
    }

    public Object lookup(String name) {
        return _register.get(name.toLowerCase());
    }

    public Enumeration listConceptsName() {
        return _register.keys();
    }

    public Enumeration listConcepts() {
        return _register.elements();
    }

    public boolean isConceptNamed(String name) {
        return _register.containsKey(name.toLowerCase());
    }

    public String resolveClass(String className) {
        Enumeration keys = _register.keys();
        Object obj = null;
        String conceptName = null;
        Class<?> classInst = null;
        String assumedConceptName = null;
        while (keys.hasMoreElements()) {
            conceptName = (String)keys.nextElement();
            if (!_register.get(conceptName).getClass().getName().equals(className)) continue;
            return ((Concept)_register.get(conceptName)).getConceptType().getValue();
        }
        try {
            classInst = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            if (className.equals("long") || className.equals("float") | className.equals("boolean") || className.equals("char") || className.equals("int")) {
                return null;
            }
            ex.printStackTrace();
            return null;
        }
        assumedConceptName = className.substring(className.lastIndexOf(".") + 1);
        obj = this.lookup(assumedConceptName);
        if (obj != null && classInst.isAssignableFrom(obj.getClass())) {
            return assumedConceptName;
        }
        return null;
    }

    private ConceptRegister() {
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("Making ConceptRegister");
        }
        _register = new Hashtable(SystemConceptsTable.getSystemConcepts());
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("Loaded " + _register.size() + " system concepts into ConceptRegister");
        }
    }
}

