/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.util.EmptyStackException;
import java.util.Stack;
import org.media.mn8.Concept;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.mn8RuntimeFlags;

public class ExecutionStack {
    private static ExecutionStack _reference = new ExecutionStack();
    private static Stack _conceptStack;
    private static Stack _methodStack;
    private static Stack _handlerStack;
    private static String _chart;

    public static ExecutionStack getReference() {
        return _reference;
    }

    public static void cleanAll() {
        _conceptStack.clear();
        _methodStack.clear();
        _handlerStack.clear();
        _chart = "";
    }

    public static void push(String conceptName, String methodName, Concept handler, int lineNr) {
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("new execution pushed in the stack");
        }
        _conceptStack.push(conceptName);
        _methodStack.push(methodName);
        _handlerStack.push(handler);
        ExecutionStack.getReference();
        ExecutionStack.addToChart(conceptName, methodName, lineNr);
    }

    public static void pop() {
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("new execution popped from the stack");
        }
        try {
            _conceptStack.pop();
            _methodStack.pop();
            _handlerStack.pop();
            ExecutionStack.getReference();
            ExecutionStack.removeFromChart();
        }
        catch (EmptyStackException ex) {
            System.err.println("Execution stack empty and you want to pop from it!?");
        }
    }

    public static String peekConcept() {
        return (String)_conceptStack.peek();
    }

    public static String peekMethod() {
        return (String)_methodStack.peek();
    }

    public static Concept peekHandler() {
        return (Concept)_handlerStack.peek();
    }

    public static Stack getHandlerStack() {
        return _handlerStack;
    }

    public static Stack getConceptStack() {
        return _conceptStack;
    }

    public static int size() {
        return _conceptStack.size() + 1;
    }

    public static String chart() {
        return mn8Interpreter.EOL + "\t" + _chart.trim();
    }

    public static void addToChart(String concept, String method, int lineNr) {
        _chart = _chart + mn8Interpreter.EOL + "\t" + concept + "." + method + (lineNr != -1 ? " (line: " + lineNr + ")" : "");
    }

    public static void removeFromChart() {
        if (_conceptStack.size() != 0) {
            int lastIdx = _chart.lastIndexOf("\n");
            _chart = _chart.substring(0, lastIdx).trim();
        } else {
            _chart = "";
        }
    }

    private ExecutionStack() {
        _conceptStack = new Stack();
        _methodStack = new Stack();
        _handlerStack = new Stack();
        _chart = "";
    }

    static {
        _chart = "";
    }
}

