/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.io.OutputStream;
import java.io.PrintStream;
import org.media.mn8.MessageFormatter;
import org.media.mn8.mn8RuntimeFlags;

public class LogManager {
    private static PrintStream _out = System.out;
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    public static final int ERROR = 3;

    public static void setOutputStream(PrintStream out) {
        if (out == null) {
            throw new RuntimeException("Please don't put a null in it !!");
        }
        _out = out;
    }

    public static OutputStream getOutputStream() {
        return _out;
    }

    public static void message(String type_id, String message_id) {
        LogManager.message(type_id, message_id, "");
    }

    public static void message(String type_id, String message_id, String optional) {
        LogManager.sysMessage(MessageFormatter.getReference().getMessage(type_id, message_id, optional, ""));
    }

    public static void message(String type_id, String message_id, String optional, String suplement) {
        LogManager.sysMessage(MessageFormatter.getReference().getMessage(type_id, message_id, optional, suplement));
    }

    public static void message(String message) {
        LogManager.sysMessage(message);
    }

    public static void message(int severity, String message) {
        if (severity <= 2 && mn8RuntimeFlags.isDebug()) {
            LogManager.message(message);
        } else if (severity == 1 && mn8RuntimeFlags.isVerbose()) {
            LogManager.message(message);
        }
        if (severity == 3) {
            LogManager.message(message);
        }
    }

    public static void message(Exception generatorException, String message) {
        LogManager.sysMessage(message, generatorException);
    }

    protected static void sysMessage(String message) {
        _out.println(message);
    }

    protected static void sysMessage(String message, Exception ex) {
        _out.println(message);
        if (LogManager.isVerbose() && ex != null) {
            _out.println(ex);
        }
        if (LogManager.isDebug() && ex != null) {
            ex.printStackTrace(_out);
        }
    }

    protected static boolean isVerbose() {
        return false;
    }

    protected static boolean isDebug() {
        return false;
    }
}

