/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.event.mn8ExitEvent;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.util.ArgParser;
import org.media.mn8.util.CLIHelper;

class Main
extends CLIHelper {
    protected final String usage = this.getUsage("conf/res/mn8Usage_EN.txt");
    protected String file = "";
    protected String command = "";
    protected boolean execCommand = false;
    protected boolean exec = false;
    protected boolean version = false;
    protected boolean help = false;
    protected String args = "-?;--help;-d;--debug;-v;--verbose;-V;--version;--trace;-c:;--showtree;";

    protected void setArgs(ArgParser parser) {
        super.setArgs(parser);
        String arg = "";
        if ("".equals(parser.getValue("-d")) || "".equals(parser.getValue("--debug"))) {
            mn8RuntimeFlags.setDebug(true);
        }
        if ("".equals(parser.getValue("-v")) || "".equals(parser.getValue("--verbose"))) {
            mn8RuntimeFlags.setVerbose(true);
        }
        if ("".equals(parser.getValue("--showtree"))) {
            mn8RuntimeFlags.setShowTree(true);
        }
        if ("".equals(parser.getValue("--trace"))) {
            mn8RuntimeFlags.setTrace(true);
        }
        if ("".equals(parser.getValue("-V")) || "".equals(parser.getValue("--version"))) {
            this.version = true;
        } else if (parser.getValue("-c:") != null) {
            this.execCommand = true;
            StringBuffer sb = new StringBuffer(parser.getValue("-c:") + " ");
            Enumeration e = parser.getUnparsedArg().elements();
            while (e.hasMoreElements()) {
                String uarg = (String)e.nextElement();
                if ("\\n".equals(uarg)) {
                    sb.append("\n");
                    continue;
                }
                sb.append(uarg + " ");
            }
            this.command = sb.toString();
        } else if (parser.getUnparsedArg().size() > 0) {
            this.exec = true;
            this.file = (String)parser.getUnparsedArg().elementAt(0);
            parser.getUnparsedArg().remove(0);
        }
    }

    protected String validate(ArgParser parser) {
        SeriesConcept args;
        SeriesConcept mn8Params;
        String ret;
        block13: {
            ret = "";
            ret = super.validate(this.usage);
            if (!ret.equals("")) {
                return ret;
            }
            if (!(this.execCommand || this.version || this.help || this.exec)) {
                return this.usage;
            }
            if (this.version) {
                return mn8Interpreter.VERSION;
            }
            if (this.execCommand && this.command == null) {
                return "You must suply a command to be executed! \n" + this.usage;
            }
            if (this.execCommand) {
                this.interpret(this.command);
            }
            if (this.exec && this.file == null) {
                return "You must suply a script file to be executed! \n" + this.usage;
            }
            Vector params = parser.getUnparsedArg();
            mn8Params = new SeriesConcept();
            args = new SeriesConcept();
            int i = 0;
            while (i < params.size()) {
                args.add(new StringConcept((String)params.elementAt(i)));
                ++i;
            }
            try {
                if (System.in.available() <= 0) break block13;
                BufferedReader inRead = new BufferedReader(new InputStreamReader(System.in));
                StringBuffer strbuf = null;
                try {
                    strbuf = new StringBuffer();
                    String line = null;
                    while ((line = inRead.readLine()) != null) {
                        strbuf.append(line);
                        strbuf.append("\n");
                    }
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                if (strbuf.length() > 0) {
                    args.add(new StringConcept(strbuf.toString()));
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        mn8Params.add(args);
        this.execute(this.file, mn8Params);
        return ret;
    }

    protected String parseArgs(String[] argv) {
        ArgParser parser = new ArgParser(this.args, ";");
        if (argv.length == 1) {
            argv = this.getArguments(argv[0]);
        }
        if (!parser.parse(argv)) {
            return "Invalid argument in command line !";
        }
        this.setArgs(parser);
        String ret = this.validate(parser).trim();
        if (ret.length() > 0) {
            return ret;
        }
        return "";
    }

    public void execute(String file, SeriesConcept arguments) {
        block6: {
            try {
                File f = new File(file);
                if (!f.exists()) {
                    String fileName = new mn8Loader().findConcept(file);
                    URL url = new URL(fileName);
                    fileName = url.getPath();
                    mn8Interpreter.executeURL(new File(fileName).toURL().toString(), file, arguments);
                } else {
                    mn8Interpreter.executeURL(new File(file).toURL().toString(), arguments);
                }
                System.exit(0);
            }
            catch (mn8ExitEvent ev) {
                if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                    System.err.println("Exit request received, exiting...");
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                if (!mn8RuntimeFlags.isDebug()) break block6;
                System.out.println("/---: The stack trace is :----------------------------------\\");
                ex.printStackTrace();
                System.out.println("\\------------------------------------------------------------/");
            }
        }
    }

    public void interpret(String command) {
        block5: {
            try {
                if (mn8RuntimeFlags.isDebug()) {
                    System.err.println("Executing command:" + command);
                }
                mn8Interpreter.interpret(command);
                System.exit(0);
            }
            catch (mn8ExitEvent ev) {
                if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                    System.err.println("Exit request received, exiting...");
                }
            }
            catch (RuntimeException ex) {
                System.err.println("exception: " + ex);
                if (!mn8RuntimeFlags.isDebug()) break block5;
                System.out.println("/---: The stack trace is :----------------------------------\\");
                ex.printStackTrace();
                System.out.println("\\------------------------------------------------------------/");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Vector scriptArgumens = new Vector();
        Main main = new Main();
        String[] arg = args;
        try {
            mn8Interpreter.initialize();
            StringBuffer sis = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            if (System.in.available() > 0) {
                String line;
                while ((line = in.readLine()) != null) {
                    void var6_7;
                    sis.append((String)var6_7 + "\n");
                }
            }
            if (sis.toString().length() != 0) {
                arg = new String[args.length + 1];
                int i = 0;
                while (i < args.length) {
                    arg[i] = args[i];
                    ++i;
                }
                arg[args.length] = sis.toString();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String argParseResult = main.parseArgs(arg);
        if (!argParseResult.equals("")) {
            System.err.println(argParseResult);
            System.exit(0);
        }
    }

    Main() {
    }
}

