/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.util.Properties;
import org.media.mn8.event.mn8SystemException;

public class MessageFormatter {
    private static final String _MESSAGES_RESOURCE_FILE = "conf/res/mn8messages.properties";
    private static Properties _prop;
    private static String _head;
    private static String _warning;
    private static String _error;
    private static String _info;
    private static MessageFormatter _formatter;

    public static MessageFormatter getReference() {
        return _formatter;
    }

    public String getMessage(String type_id, String message_id) {
        return this.getMessage(type_id, message_id, "", "");
    }

    public String getMessage(String type_id, String message_id, String optional) {
        return this.getMessage(type_id, message_id, optional, "");
    }

    public String getInterpMessage(String type_id, String message_id, String optional, int line) {
        if (optional == null) {
            optional = "";
        }
        return _head + this.getTypeInfo(type_id) + "Line: " + line + " " + this.getMessageInfo(message_id) + optional;
    }

    public String getMessage(String type_id, String message_id, String optional, String suplementary) {
        if (optional == null) {
            optional = "";
        }
        if (suplementary == null) {
            suplementary = "";
        }
        return _head + this.getTypeInfo(type_id) + this.getMessageInfo(message_id) + optional + "\n" + suplementary;
    }

    public String getMessageInfo(String message_id) {
        if (message_id == null || message_id.equals("")) {
            return "";
        }
        if (_prop.getProperty("mn8.messages." + message_id) == null) {
            this.sysError(_warning, "Unable to find mn8.messages." + message_id + " in resource bundle: " + _MESSAGES_RESOURCE_FILE);
            return "";
        }
        return _prop.getProperty("mn8.messages." + message_id);
    }

    public String getTypeInfo(String type_id) {
        if (type_id == null || type_id.equals("")) {
            return "";
        }
        if (_prop.getProperty("mn8.messages.type." + type_id) == null) {
            this.sysError(_warning, "Unable to find mn8.messages.type." + type_id + " in resource bundle: " + _MESSAGES_RESOURCE_FILE);
            return "";
        }
        return _prop.getProperty("mn8.messages.type." + type_id);
    }

    private final void sysError(String type, String message) {
        throw new mn8SystemException(_head + type + message);
    }

    private final void sysError(String type, String message, String optional) {
        throw new mn8SystemException(_head + type + message + optional);
    }

    private MessageFormatter() {
        try {
            _prop = new Properties();
            Class<?> c = Class.forName("org.media.mn8.LogManager");
            if (c.getResourceAsStream(_MESSAGES_RESOURCE_FILE) == null) {
                throw new RuntimeException("Unable to load resource file : conf/res/mn8messages.properties");
            }
            _prop.load(c.getResourceAsStream(_MESSAGES_RESOURCE_FILE));
            if (_prop.getProperty("mn8.messages.head") != null) {
                _head = _prop.getProperty("mn8.messages.head");
            }
            if (_prop.getProperty("mn8.messages.type.warning") != null) {
                _warning = _prop.getProperty("mn8.messages.type.warning");
            }
            if (_prop.getProperty("mn8.messages.type.error") != null) {
                _error = _prop.getProperty("mn8.messages.type.error");
            }
        }
        catch (Exception ex) {
            this.sysError(_warning, ex.getMessage());
            _prop = null;
        }
    }

    static {
        _head = "mn8 : ";
        _warning = "[WARNING] - ";
        _error = "[ERROR] - ";
        _info = "[INFO] - ";
        _formatter = new MessageFormatter();
    }
}

