/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.media.mn8.LogManager;
import org.media.mn8.conf.NamingConf;

public class NamingManager {
    public static final String ENV_ID = "env:";
    public static final String MEM_ID = "mem:";
    private static final String _ENV_CONTEXT_PATH = "env";
    private static final String _MEM_CONTEXT_PATH = "mem";
    private static NamingManager _nManagerInstance = new NamingManager();
    private static Context _initialContext;
    private static Context _envContext;
    private static Context _memContext;
    private static String _memMapping;
    private static String _envMapping;

    public static NamingManager getReference() {
        return _nManagerInstance;
    }

    public static void bind(String name, Object obj) throws NamingException {
        String bndName = name;
        Context context = _memContext;
        if (name == null || obj == null) {
            throw new RuntimeException();
        }
        if (name.startsWith(ENV_ID)) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (name.startsWith(MEM_ID)) {
            if ((name = name.substring(MEM_ID.length())).lastIndexOf("/") != -1 && name.substring(0, name.lastIndexOf("/")).length() != 0) {
                bndName = name.substring(name.lastIndexOf("/") + 1);
                context = NamingManager.testAndCreateContext(_memContext, name.substring(0, name.lastIndexOf("/")));
            }
        } else {
            throw new NameNotFoundException();
        }
        bndName = bndName.substring(bndName.lastIndexOf("/") + 1);
        context.bind(bndName, obj);
    }

    public static void rebind(String name, Object obj) throws NamingException {
        String bndName = name;
        Context context = _memContext;
        if (name == null || obj == null) {
            throw new RuntimeException();
        }
        if (name.startsWith(ENV_ID)) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (name.startsWith(MEM_ID)) {
            if ((name = name.substring(MEM_ID.length())).lastIndexOf("/") != -1 && name.substring(0, name.lastIndexOf("/")).length() != 0) {
                bndName = name.substring(name.lastIndexOf("/") + 1);
                context = NamingManager.testAndCreateContext(_memContext, name.substring(0, name.lastIndexOf("/")));
            }
        } else {
            throw new NameNotFoundException();
        }
        bndName = bndName.substring(bndName.lastIndexOf("/") + 1);
        context.rebind(bndName, obj);
    }

    public static void rename(String oldName, String newName) throws NamingException {
        if (oldName == null || newName == null || oldName == "" || newName == "") {
            throw new RuntimeException();
        }
        if (oldName.startsWith(ENV_ID) || newName.startsWith(ENV_ID)) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (!oldName.startsWith(MEM_ID) || !newName.startsWith(MEM_ID)) {
            throw new NameNotFoundException();
        }
        Object obj = NamingManager.lookup(oldName);
        NamingManager.bind(newName, obj);
        NamingManager.unbind(oldName);
    }

    public static void unbind(String name) throws NamingException {
        if (name == null || name == "") {
            throw new RuntimeException();
        }
        if (name.startsWith(ENV_ID)) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (!name.startsWith(MEM_ID)) {
            throw new NameNotFoundException();
        }
        name = name.substring(MEM_ID.length());
        _memContext.unbind(name);
    }

    public static NamingEnumeration list(String name) throws NamingException {
        if (name == null || name == "") {
            throw new RuntimeException();
        }
        if (name.startsWith(MEM_ID)) {
            name = name.substring(MEM_ID.length());
            return _memContext.list(name);
        }
        if (name.startsWith(ENV_ID)) {
            name = name.substring(ENV_ID.length());
            return _envContext.list(name);
        }
        throw new NameNotFoundException();
    }

    public static NamingEnumeration listBindings(String name) throws NamingException {
        if (name == null || name == "") {
            throw new RuntimeException();
        }
        if (name.startsWith(MEM_ID)) {
            name = name.substring(MEM_ID.length());
            return _memContext.listBindings(name);
        }
        if (name.startsWith(ENV_ID)) {
            name = name.substring(ENV_ID.length());
            return _envContext.listBindings(name);
        }
        throw new NameNotFoundException();
    }

    public static Context createSubcontext(String name) throws NamingException {
        if (name == null) {
            throw new RuntimeException();
        }
        if (name.startsWith(ENV_ID)) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (name.startsWith(MEM_ID)) {
            name = name.substring(MEM_ID.length());
            Context context = NamingManager.testAndCreateContext(_memContext, name);
            return context;
        }
        throw new NameNotFoundException();
    }

    public static void destroySubcontext(String name) throws NamingException {
        if (name == null) {
            throw new RuntimeException();
        }
        if (name.startsWith(ENV_ID)) {
            throw new OperationNotSupportedException("Context is read-only");
        }
        if (!name.startsWith(MEM_ID)) {
            throw new NameNotFoundException();
        }
        name = name.substring(MEM_ID.length());
        _memContext.destroySubcontext(name);
    }

    public static void close() throws NamingException {
        _memContext.close();
        _envContext.close();
        _memContext = null;
        _envContext = null;
    }

    public static Object lookup(String name) throws NamingException {
        if (name.startsWith(ENV_ID)) {
            name = name.substring(ENV_ID.length());
            return _envContext.lookup(name);
        }
        if (name.startsWith(MEM_ID)) {
            name = name.substring(MEM_ID.length());
            return _memContext.lookup(name);
        }
        return new NameNotFoundException();
    }

    public static void envBind(String name, Object obj) throws NamingException {
        String bndName = name;
        Context context = _envContext;
        if (name == null || obj == null) {
            throw new RuntimeException();
        }
        if (name.startsWith(ENV_ID)) {
            name = name.substring(ENV_ID.length());
        }
        if (name.startsWith(MEM_ID)) {
            throw new OperationNotSupportedException("mem: unsupported scheme!");
        }
        if (name.lastIndexOf("/") != -1 && name.substring(0, name.lastIndexOf("/")).length() != 0) {
            bndName = name.substring(name.lastIndexOf("/") + 1);
            context = NamingManager.testAndCreateContext(_envContext, name.substring(0, name.lastIndexOf("/")));
        }
        bndName = bndName.substring(bndName.lastIndexOf("/") + 1);
        context.rebind(bndName, obj);
    }

    private static final Context testAndCreateContext(Context startCtx, String subcontextPath) throws NamingException {
        Context subCtx = startCtx;
        StringTokenizer tokenizer = new StringTokenizer(subcontextPath, "/");
        int tokensNr = tokenizer.countTokens();
        String curToken = "";
        int i = 0;
        while (i < tokensNr) {
            curToken = tokenizer.nextToken();
            try {
                if (subCtx.lookup(curToken) != null) {
                    subCtx = (Context)subCtx.lookup(curToken);
                }
            }
            catch (NameNotFoundException nnex) {
                subCtx = subCtx.createSubcontext(curToken);
            }
            ++i;
        }
        return subCtx;
    }

    private static final void initializeEnvContext(Hashtable properties) throws NamingException {
        Enumeration en = properties.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            NamingManager.envBind(key, properties.get(key));
        }
    }

    private NamingManager() {
        try {
            NamingConf _config = NamingConf.getReference();
            _memMapping = _config.getMemMapping();
            _envMapping = _config.getEnvMapping();
            _initialContext = new InitialContext(_config.getInitialContextProperties());
            _memMapping = _memMapping + _MEM_CONTEXT_PATH;
            _envMapping = _envMapping + _ENV_CONTEXT_PATH;
            _envContext = NamingManager.testAndCreateContext(_initialContext, _envMapping);
            _memContext = NamingManager.testAndCreateContext(_initialContext, _memMapping);
            NamingManager.initializeEnvContext(_config.getEnvProperties());
        }
        catch (NamingException nex) {
            LogManager.message("error", "naming.create_exception", nex.getMessage());
            System.exit(0);
        }
    }

    static {
        _memMapping = "/";
        _envMapping = "/";
    }
}

