/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import java.util.EmptyStackException;
import java.util.Stack;
import org.media.mn8.Concept;
import org.media.mn8.GlobalScope;
import org.media.mn8.Scope;
import org.media.mn8.event.ForcedInstance;
import org.media.mn8.mn8ConceptDefinition;
import org.media.mn8.mn8RuntimeFlags;

public class ScopeStack
implements Cloneable {
    private mn8ConceptDefinition _conceptDef = null;
    private Stack _scopeStack = null;
    private GlobalScope _globalScope = GlobalScope.getReference();
    private String _conceptName = "";
    private Scope _conceptGlobalScope = null;

    public void clear() {
        this._conceptDef = null;
        this._scopeStack.clear();
        GlobalScope.cleanAll();
        this._conceptGlobalScope.clear();
    }

    public void pushScope(Scope newScope) {
        this._scopeStack.push(newScope);
    }

    public Scope getConceptGlobalScope() {
        return this._conceptGlobalScope;
    }

    public int scopeStackSize() {
        return this._scopeStack.size() + 1;
    }

    public Scope popScope() {
        try {
            return (Scope)this._scopeStack.pop();
        }
        catch (EmptyStackException ex) {
            return this._globalScope;
        }
    }

    public Scope getCurrentScope() {
        try {
            return (Scope)this._scopeStack.peek();
        }
        catch (EmptyStackException ex) {
            return this._globalScope;
        }
    }

    public Scope getGlobalScope() {
        return this._globalScope;
    }

    public void insertGlobalInstance(String name, Concept instance) {
        this._globalScope.insertInstance(this._conceptName + ":" + name, instance);
    }

    public void insertInstance(String name, Concept instance) {
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("  ->" + name + " of type " + instance.getConceptType().getValue() + " inserted in the stack");
        }
        if (this.isInstance(name)) {
            this.updateInstance(name, instance);
        } else {
            this.newInstance(name, instance);
        }
    }

    public Concept getInstance(String name) {
        Scope scope = null;
        scope = this.getInstanceScope(name);
        if (scope == null) {
            return null;
        }
        return scope.getInstance(name);
    }

    public boolean isInstance(String name) {
        return this.getInstanceScope(name) != null;
    }

    public void setForcedType(String name, String type) {
        this.getInstanceScope(name).setForcedType(name, type);
    }

    private final void newInstance(String name, Concept instance) {
        Scope scope = this.getCurrentScope();
        scope.insertInstance(name, instance);
    }

    private final void updateInstance(String name, Concept instance) {
        Scope scope = this.getInstanceScope(name);
        if (scope.isForcedInstance(name)) {
            String type = scope.getForcedType(name);
            if (!instance.getConceptType().getValue().equalsIgnoreCase(type)) {
                throw new ForcedInstance(name, type);
            }
        }
        scope.insertInstance(name, instance);
    }

    private final Scope getInstanceScope(String name) {
        Scope scope = this.getCurrentScope();
        boolean found = false;
        while (scope != null && !found) {
            if (scope.isInstance(name)) {
                return scope;
            }
            scope = scope.getPrevScope();
        }
        if (scope == null && this._globalScope.isInstance(this._conceptName + ":" + name)) {
            return this._globalScope;
        }
        return null;
    }

    public Object clone() {
        Stack<Object> newStack = new Stack<Object>();
        Scope curScope = null;
        int i = 0;
        while (i < this._scopeStack.size()) {
            curScope = (Scope)this._scopeStack.elementAt(i);
            newStack.push(curScope.clone());
            if (i > 0) {
                ((Scope)newStack.elementAt(i)).setPrevScope((Scope)newStack.elementAt(i - 1));
            }
            ++i;
        }
        return new ScopeStack(this._conceptDef, newStack);
    }

    public void printDebugInfo() {
        System.err.println("Stack:" + this._conceptDef.getConceptType().toString());
    }

    public ScopeStack(mn8ConceptDefinition conceptDef) {
        this._conceptDef = conceptDef;
        this._scopeStack = new Stack();
        this._conceptGlobalScope = new Scope(null);
        this._scopeStack.push(this._conceptGlobalScope);
        this._conceptName = this._conceptDef.getConceptType().getValue();
    }

    public ScopeStack(mn8ConceptDefinition conceptDef, Stack scopeStack) {
        this._conceptDef = conceptDef;
        this._scopeStack = scopeStack;
        this._conceptGlobalScope = (Scope)this._scopeStack.elementAt(0);
        this._conceptName = this._conceptDef.getConceptType().getValue();
    }
}

