/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.Attribute;
import org.media.mn8.concepts.AttributeDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.util.Normalizer;

public class AttributeConcept
extends JavaConcept
implements Attribute {
    Concept _value = null;
    private StringConcept _name = null;
    private StringConcept _label = null;

    public AttributeConcept create(StringConcept label, Concept value) {
        this._name = this._label = label;
        this._value = value;
        return this;
    }

    public String toString() {
        return this._value.toString();
    }

    public void setValue(Concept value) {
        this._value = value;
    }

    public Concept getValue() {
        if (this._value == null) {
            return new NilConcept();
        }
        return this._value;
    }

    public StringConcept getName() {
        return this._name;
    }

    public StringConcept getLabel() {
        return this._label;
    }

    public void setLabel(StringConcept label) {
        this._label = label;
        if (this._name == null || this._name.toString().trim() == "") {
            this._name = this._label;
        }
    }

    public StringConcept getValueType() {
        return this._value.getConceptType();
    }

    public String getAttributeName() {
        return this._name.getValue();
    }

    public void setAttributeName(String name) {
        this._name = new StringConcept(name);
    }

    public void setAttributeLabel(String label) {
        this._label = new StringConcept(label);
    }

    public String getAttributeLabel() {
        return this._label.getValue();
    }

    public void setAttributeValue(Concept concept) {
        this.setValue(concept);
    }

    public Concept getAttributeValue() {
        return this.getValue();
    }

    public String getAttributeType() {
        return this._value.getConceptType().getValue();
    }

    public StringConcept toTXT() {
        if (this.isHidden().getValue()) {
            return new StringConcept();
        }
        if (this._value != null) {
            if (!this.showEmpty().getValue() && this._value.toTXT().toString().trim().equals("")) {
                return new StringConcept();
            }
            return new StringConcept(this._label.toString() + ": " + this._value.toTXT());
        }
        return new StringConcept("");
    }

    public int hashCode() {
        return this._name.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeConcept) {
            return this.equals((AttributeConcept)obj).getValue();
        }
        return false;
    }

    public StringConcept toXML() {
        if (this.isHidden().getValue()) {
            return new StringConcept();
        }
        if (this._value != null) {
            if (!this.showEmpty().getValue() && this._value.toTXT().toString().trim().equals("")) {
                return new StringConcept();
            }
            String result = "";
            result = this._label != null ? result + this._label.toString() : result + this._name.toString();
            result = result + "=\"";
            result = result + Normalizer.normalize(this._value.toTXT().toString()) + "\"";
            return new StringConcept(result);
        }
        return new StringConcept();
    }

    public ConceptDefinition getConceptDefinition() {
        return AttributeDefinition.getReference();
    }

    public Object clone() {
        AttributeConcept attr = new AttributeConcept(this._name.toString(), this._label.toString(), (Concept)this._value.clone());
        attr.setShowEmpty(this.showEmpty());
        attr.setHidden(this.isHidden());
        return attr;
    }

    public LogicalConcept opEquals(AttributeConcept attr) {
        return this.equals(attr);
    }

    public LogicalConcept equals(AttributeConcept attr) {
        return new LogicalConcept(this._label.toString().equalsIgnoreCase(attr.getAttributeLabel()) && this._value.equals(attr.getAttributeValue()));
    }

    public AttributeConcept() {
        this._value = new NilConcept();
        this._name = new StringConcept("");
        this._label = new StringConcept("");
        this._value = new NilConcept();
        this._showEmpty = false;
    }

    public AttributeConcept(String name, String label, Concept value) {
        this._value = value == null ? new NilConcept() : value;
        this._label = label == null ? new StringConcept(name) : new StringConcept(label);
        this._name = new StringConcept(name);
        this._showEmpty = false;
    }
}

