/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.media.datastore.sepengine.driver.SepStoreConnection;
import org.media.datastore.sepengine.driver.SepStoreDriverManager;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.BEEPClientConceptDefinition;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.StringConcept;

public class BEEPClientConcept
extends JavaConcept {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 10288;
    private static final String DEFAULT_USER = "guest";
    private static final String DEFAULT_PASSWD = "guest";
    protected URL _url;
    protected SepStoreConnection _con;

    public BEEPClientConcept create(StringConcept url) {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this.initialize(url);
        return this;
    }

    protected boolean initialize(StringConcept url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url.toString());
            if (givenURL == null || givenURL.getProtocol().equalsIgnoreCase("beep")) {
                if (givenURL != null) {
                    String _host = givenURL.getHost();
                    int _port = givenURL.getPort();
                    String ui = givenURL.getUserInfo();
                    String _dbName = givenURL.getFile();
                    String _ref = givenURL.getRef() == null ? "" : "#" + givenURL.getRef();
                    String _user = null;
                    String _pwd = null;
                    this._url = givenURL;
                    if (_dbName.trim().equals("/") || _dbName.trim().length() < 1) {
                        new ErrorConcept("error", "badURL", "XML DataBase name is missing. It is mandatory.");
                    }
                    if (ui != null) {
                        if (ui.indexOf(":") != -1) {
                            _user = ui.substring(0, ui.indexOf(":"));
                            _pwd = ui.substring(ui.indexOf(":") + 1);
                        } else {
                            _user = ui;
                        }
                    }
                    if (_host == null || _host.length() < 1) {
                        _host = DEFAULT_HOST;
                    }
                    if (_port == -1) {
                        _port = 10288;
                    }
                    if (_user != null && _user.length() < 1) {
                        _user = "guest";
                    }
                    if (_pwd != null && _pwd.length() < 1) {
                        _pwd = "guest";
                    }
                    String myURL = "sep:beep://" + _host + ":" + _port + _dbName + _ref;
                    this._con = SepStoreDriverManager.getConnection((String)myURL, (String)_user, (String)_pwd);
                }
            } else if (givenURL != null) {
                new ErrorConcept("error", "unsupportedProtocol", "'" + givenURL.getProtocol() + "' protocol not supported by BEEPClient");
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return false;
        }
        return true;
    }

    public StringConcept execute(StringConcept sep) {
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this._con.executeSEP(sep.toString())));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            return new StringConcept(sb.toString());
        }
        catch (Exception ex) {
            new ErrorConcept("error", "executeFailed", ex.getMessage());
            return new StringConcept("");
        }
    }

    public ConceptDefinition getConceptDefinition() {
        return BEEPClientConceptDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    public BEEPClientConcept() {
    }

    public BEEPClientConcept(StringConcept url) {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this.initialize(url);
    }
}

