/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.URL;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.BEEPClientConcept;
import org.media.mn8.concepts.BEEPHandlerDefinition;
import org.media.mn8.concepts.DSResponseConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandler;
import org.media.mn8.concepts.URIHandlerDefinition;

public class BEEPHandler
extends URIHandler {
    private String _url = null;
    private String _uname = null;
    private String _pwd = null;
    private MapConcept _options;
    private BEEPClientConcept _client;

    public URIHandler create(StringConcept url) {
        this._url = url.toString();
        return this;
    }

    public LogicalConcept acceptsURI(StringConcept uri) {
        return ((URIHandlerDefinition)this.getConceptDefinition()).acceptsURI(uri);
    }

    public LogicalConcept initialize(MapConcept options) {
        URL givenURL = null;
        this._options = options;
        if (options.containsKey(new StringConcept("user")).getValue()) {
            this._uname = options.getValue(new StringConcept("user")).toTXT().toString();
        }
        if (options.containsKey(new StringConcept("pwd")).getValue()) {
            this._pwd = options.getValue(new StringConcept("pwd")).toTXT().toString();
        }
        try {
            givenURL = new URL(this._url);
            if (givenURL != null && givenURL.getProtocol().equalsIgnoreCase("beep") && this._uname != null && this._uname.trim().length() > 0 && this._pwd != null && this._pwd.trim().length() > 0) {
                this._url = givenURL.getProtocol() + "://";
                this._url = this._url + this._uname + ":" + this._pwd + "@";
                if (givenURL.getHost() != null) {
                    this._url = this._url + givenURL.getHost();
                }
                if (givenURL.getPort() != -1) {
                    this._url = this._url + ":" + givenURL.getPort();
                }
                if (givenURL.getPath() != null) {
                    this._url = this._url + givenURL.getPath();
                }
                if (givenURL.getQuery() != null) {
                    this._url = this._url + "?" + givenURL.getQuery();
                }
                if (givenURL.getRef() != null) {
                    this._url = this._url + "#" + givenURL.getRef();
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept closeConnection() {
        return new LogicalConcept(true);
    }

    public LogicalConcept openConnection() {
        this._client = new BEEPClientConcept(new StringConcept(this._url));
        return new LogicalConcept(true);
    }

    public Concept getContent() {
        try {
            URL url = new URL(this._url);
            String qu = url.getQuery();
            if (qu.trim().length() != 0) {
                return DSResponseConcept.getResponse(this._client.execute(new StringConcept(qu.substring(qu.indexOf("=") + 1))).toString());
            }
            return new StringConcept("");
        }
        catch (Exception ex) {
            new ErrorConcept("error", "executeFailed", ex.getMessage());
            return new StringConcept("");
        }
    }

    public LogicalConcept setContent(Concept value) {
        return new LogicalConcept(false);
    }

    public ConceptDefinition getConceptDefinition() {
        return BEEPHandlerDefinition.getReference();
    }

    public Object clone() {
        if (this._url != null) {
            return new BEEPHandler(new StringConcept(this._url));
        }
        return new URIHandler();
    }

    public BEEPHandler() {
    }

    public BEEPHandler(StringConcept url) {
        this._url = url.toString();
    }
}

