/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.File;
import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.Helper;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.CookieDefinition;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.protocol.http.Cookie;

public class CookieConcept
extends JavaConcept {
    public static String COOKIE_DB = Helper.getUserHome().getValue() + ".mn8" + File.separatorChar + "http" + File.separatorChar + "cookies" + File.separatorChar;
    private Cookie _cookie = new Cookie();
    public AttributeConcept name = new AttributeConcept("name", "name", new StringConcept());
    public AttributeConcept value = new AttributeConcept("value", "value", new StringConcept());
    public AttributeConcept domain = new AttributeConcept("domain", "domain", new StringConcept());
    public AttributeConcept path = new AttributeConcept("path", "path", new StringConcept());
    public AttributeConcept expires = new AttributeConcept("expires", "expires", new StringConcept());
    public AttributeConcept secure = new AttributeConcept("secure", "secure", new StringConcept());

    public Concept create() {
        return this;
    }

    public CookieConcept create(StringConcept cookieContent, StringConcept domain) {
        this.setCookie(new Cookie(cookieContent.toString(), domain.toString()));
        return this;
    }

    public void setName(StringConcept name) {
        this._cookie.setName(name.toString());
        this.setCookie();
    }

    public void setValue(StringConcept value) {
        this._cookie.setValue(value.toString());
        this.setCookie();
    }

    public void setDomain(StringConcept domain) {
        this._cookie.setDomain(domain.toString());
        this.setCookie();
    }

    public void setPath(StringConcept path) {
        this._cookie.setPath(path.toString());
        this.setCookie();
    }

    public void setExpires(StringConcept expires) {
        this._cookie.setExpires(expires.toString());
        this.setCookie();
    }

    public void setSecure(StringConcept secure) {
        this._cookie.setSecure(secure.toString());
        this.setCookie();
    }

    public void setCookie(Cookie cookie) {
        if (cookie != null) {
            this._cookie = cookie;
            this.setCookie();
        }
    }

    public void setCookie() {
        this.name.setAttributeValue(new StringConcept(this._cookie.getName()));
        this.value.setAttributeValue(new StringConcept(this._cookie.getValue()));
        this.domain.setAttributeValue(new StringConcept(this._cookie.getDomain()));
        this.path.setAttributeValue(new StringConcept(this._cookie.getPath()));
        this.expires.setAttributeValue(new StringConcept(this._cookie.getExpires()));
        this.secure.setAttributeValue(new StringConcept(this._cookie.getSecure()));
    }

    public Cookie getCookie() {
        return this._cookie;
    }

    public boolean equals(Object obj) {
        return obj instanceof CookieConcept && ((CookieConcept)obj).getCookie().equals(this._cookie);
    }

    public Object clone() {
        return new CookieConcept(this._cookie);
    }

    public StringConcept toTXT() {
        return this.toStringConcept();
    }

    public StringConcept toStringConcept() {
        if (this._cookie != null) {
            return new StringConcept(this._cookie.toString());
        }
        return new StringConcept();
    }

    public StringConcept toXML() {
        if (this._cookie != null) {
            return new StringConcept(this._cookie.toXMLString());
        }
        return new StringConcept();
    }

    public ConceptDefinition getConceptDefinition() {
        return CookieDefinition.getReference();
    }

    public void saveCookie(StringConcept dir) {
        String cookiedb = dir.toString();
        if (cookiedb.charAt(cookiedb.length() - 1) != File.separatorChar) {
            cookiedb = cookiedb + File.separatorChar;
        }
        if (this._cookie == null) {
            return;
        }
        Vector<Cookie> cookies = new Vector<Cookie>();
        cookies.add(this._cookie);
        this._cookie.writeCookiesToXML(this._cookie.getDomain(), cookies, cookiedb);
    }

    public void storeCookie() {
        if (this._cookie == null) {
            return;
        }
        Vector<Cookie> cookies = new Vector<Cookie>();
        cookies.add(this._cookie);
        this._cookie.writeCookiesToXML(this._cookie.getDomain(), cookies, COOKIE_DB);
    }

    public CookieConcept() {
    }

    public CookieConcept(StringConcept cookieContent, StringConcept domain) {
        this.setCookie(new Cookie(cookieContent.toString(), domain.toString()));
    }

    public CookieConcept(Cookie cookie) {
        this.setCookie(cookie);
    }
}

