/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptConceptDefinition;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.FieldConcept;
import org.media.mn8.concepts.CookieConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8JavaMethod;
import org.media.mn8.protocol.http.Cookie;
import org.media.mn8.protocol.http.DefaultCookie;
import org.media.mn8.protocol.http.ExplorerCookie;
import org.media.mn8.protocol.http.KonquerorCookie;
import org.media.mn8.protocol.http.NetscapeCookie;
import org.media.mn8.protocol.http.OperaCookie;

public class CookieDefinition
extends ConceptConceptDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static CookieDefinition _reference = new CookieDefinition();

    public static void convertNetscapeCookies(StringConcept cookieFile, StringConcept cookieDir) {
        NetscapeCookie cook = new NetscapeCookie();
        ((DefaultCookie)cook).writeCookiesToXML(cookieFile.toString(), cookieDir.toString());
    }

    public static void convertExplorerCookies(StringConcept cookieFile, StringConcept cookieDir) {
        ExplorerCookie cook = new ExplorerCookie();
        ((DefaultCookie)cook).writeCookiesToXML(cookieFile.toString(), cookieDir.toString());
    }

    public static void convertOperaCookies(StringConcept cookieFile, StringConcept cookieDir) {
        OperaCookie cook = new OperaCookie();
        ((DefaultCookie)cook).writeCookiesToXML(cookieFile.toString(), cookieDir.toString());
    }

    public static void convertKonquerorCookies(StringConcept cookieFile, StringConcept cookieDir) {
        KonquerorCookie cook = new KonquerorCookie();
        ((DefaultCookie)cook).writeCookiesToXML(cookieFile.toString(), cookieDir.toString());
    }

    public SeriesConcept getCookiesFromDB(StringConcept uri) {
        if (uri == null || uri.toString() == null) {
            return new SeriesConcept();
        }
        String cookiedb = CookieConcept.COOKIE_DB;
        SeriesConcept result = new SeriesConcept();
        Vector cook = new Cookie().readCookiesFromXML(uri.toString(), cookiedb, false);
        int i = 0;
        while (i < cook.size()) {
            result.add(new CookieConcept((Cookie)cook.elementAt(i)));
            ++i;
        }
        return result;
    }

    public StringConcept getCookieString(StringConcept uri) {
        String cookiedb = CookieConcept.COOKIE_DB;
        return new StringConcept(new Cookie().getCookieString(uri.toString(), cookiedb, false));
    }

    public static ConceptDefinition getReference() {
        return _reference;
    }

    public Concept getConceptInstance() {
        return new CookieConcept();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("Cookie");
    }

    public StringConcept getConceptType() {
        return new StringConcept("Cookie");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    private CookieDefinition() {
        try {
            Class<?> _class = Class.forName("org.media.mn8.concepts.CookieConcept");
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "toXML:", "toXML:", "Cookie", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "setName:org.media.mn8.concepts.StringConcept", "setName:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "setValue:org.media.mn8.concepts.StringConcept", "setValue:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "setDomain:org.media.mn8.concepts.StringConcept", "setDomain:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "setPath:org.media.mn8.concepts.StringConcept", "setPath:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "setExpires:org.media.mn8.concepts.StringConcept", "setExpires:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "setSecure:org.media.mn8.concepts.StringConcept", "setSecure:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "toTXT:", "toTXT:", "Cookie", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "storeCookie:", "storeCookie:", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "saveCookie:org.media.mn8.concepts.StringConcept", "saveCookie:String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "create:", "create:", "Cookie", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieConcept", "create:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "create:String,String", "Cookie", "Cookie"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieDefinition", true, "convertNetscapeCookies:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "convertNetscapeCookies:String,String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieDefinition", true, "convertExplorerCookies:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "convertExplorerCookies:String,String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieDefinition", true, "convertOperaCookies:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "convertOperaCookies:String,String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieDefinition", true, "convertKonquerorCookies:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "convertKonquerorCookies:String,String", "Cookie", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieDefinition", true, "getCookiesFromDB:org.media.mn8.concepts.StringConcept", "getCookiesFromDB:String", "Cookie", "Series"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.CookieDefinition", true, "getCookieString:org.media.mn8.concepts.StringConcept", "getCookieString:String", "Cookie", "String"));
            this.putAttribute(new FieldConcept("domain", _class.getDeclaredField("domain"), false, "domain", "String", null));
            this.putAttribute(new FieldConcept("name", _class.getDeclaredField("name"), false, "name", "String", null));
            this.putAttribute(new FieldConcept("value", _class.getDeclaredField("value"), false, "value", "String", null));
            this.putAttribute(new FieldConcept("path", _class.getDeclaredField("path"), false, "path", "String", null));
            this.putAttribute(new FieldConcept("expires", _class.getDeclaredField("expires"), false, "expires", "String", null));
            this.putAttribute(new FieldConcept("secure", _class.getDeclaredField("secure"), false, "secure", "String", null));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

