/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.NoSuchElementException;
import java.util.Vector;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.CronDefinition;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TypedSeries;
import org.media.mn8.util.Cron;
import org.media.mn8.util.CronCollector;
import org.media.mn8.util.CronMultiplier;
import org.media.mn8.util.CronTimeScheduler;

public class CronConcept
extends JavaConcept {
    private static int id = 0;
    private static TypedSeries tasks = new TypedSeries("task", "task");
    public static ElementConcept task = new ElementConcept("tasks", "tasks", tasks, null);
    private static Vector repository = new Vector();
    private static CronTimeScheduler timeScheduler = new CronTimeScheduler();
    private static CronConcept _instance = null;

    public static CronConcept getInstance() {
        if (_instance == null) {
            _instance = new CronConcept();
        }
        return _instance;
    }

    public static IntegerConcept addTask(StringConcept cron, StringConcept target) {
        CronCollector collector = new CronCollector();
        collector.targetName = target.getValue();
        collector.cronString = cron.getValue();
        repository.add(++id - 1, collector);
        String _id = "" + id;
        ElementConcept ec = new ElementConcept("task", "task", null, null);
        ec.addAttribute(new AttributeConcept("id", "id", new StringConcept(_id)));
        ec.addAttribute(new AttributeConcept("timeString", "timeString", cron));
        ec.addAttribute(new AttributeConcept("commandString", "CommandString", target));
        tasks.add(ec);
        CronConcept.initialize();
        return new IntegerConcept(id);
    }

    public static TypedSeries getTasks() {
        return tasks;
    }

    public static void removeTask(IntegerConcept rid) {
        repository.remove(rid.getInt() - 1);
        tasks.remove(rid);
        int sec_id = 0;
        boolean loop = true;
        while (loop) {
            String _id = "" + rid.getInt() + "." + sec_id;
            try {
                timeScheduler.getEntry(_id);
                timeScheduler.resetTrigger(_id);
                timeScheduler.removeTrigger(_id);
            }
            catch (NoSuchElementException e) {
                loop = false;
            }
            ++sec_id;
        }
    }

    public static void start() {
        try {
            timeScheduler.start();
        }
        catch (Exception e) {
            new ErrorConcept("error", "errOnStart", "Error on starting the Cron: " + e.getMessage());
        }
    }

    public static void stop() {
        timeScheduler.stop();
    }

    private static final void initialize() {
        int cy = 0;
        while (cy < repository.size()) {
            CronCollector collector = (CronCollector)repository.get(cy);
            String target = collector.targetName;
            CronMultiplier cronMaker = new CronMultiplier();
            cronMaker.setMaker(collector.cronString);
            if (!cronMaker.ignored) {
                int cx = 0;
                while (cx < cronMaker.getSize()) {
                    cronMaker.setCurrent(cx);
                    Cron trigger = new Cron(cronMaker.getMin(), cronMaker.getHour(), cronMaker.getDay(), cronMaker.getMonth(), -1, cronMaker.getIsDayOfWeek());
                    String tid = "" + (cy + 1) + "." + cx;
                    try {
                        timeScheduler.addTrigger(tid, trigger, target);
                    }
                    catch (Exception e) {
                        new ErrorConcept("error", "errAddTrigger", e.getMessage());
                    }
                    ++cx;
                }
            } else {
                new ErrorConcept("error", "invalidCronString", "Invalid Cron String: " + collector.cronString + "\n\t\t\t   " + cronMaker.getErrMsg());
            }
            ++cy;
        }
    }

    public ConceptDefinition getConceptDefinition() {
        return CronDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    private CronConcept() {
    }
}

