/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.media.datastore.sepengine.driver.SepStoreConnection;
import org.media.datastore.sepengine.driver.SepStoreDriverManager;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.DSClientDefinition;
import org.media.mn8.concepts.DSResponseConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.StringConcept;

public class DSClientConcept
extends JavaConcept {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 10288;
    private static final String DEFAULT_USER = "guest";
    private static final String DEFAULT_PASSWD = "guest";
    protected String _host;
    protected String _port;
    protected SepStoreConnection _con;

    public DSClientConcept create(StringConcept host, StringConcept port) {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this._host = host.toString();
        this._port = port.toString();
        return this;
    }

    public DSClientConcept create(StringConcept host) {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this._host = host.toString();
        this._port = "10288";
        return this;
    }

    public Concept create() {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this._host = DEFAULT_HOST;
        this._port = "10288";
        return this;
    }

    public LogicalConcept login(StringConcept dbName, StringConcept user, StringConcept pwd) {
        String myURL = "sep:beep://" + this._host + ":" + this._port + "/" + dbName.toString();
        try {
            this._con = SepStoreDriverManager.getConnection((String)myURL, (String)user.toString(), (String)pwd.toString());
        }
        catch (Exception ex) {
            new ErrorConcept("error", "loginFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept login(StringConcept dbName) {
        String myURL = "sep:beep://" + this._host + ":" + this._port + "/" + dbName.toString();
        try {
            this._con = SepStoreDriverManager.getConnection((String)myURL, (String)"guest", (String)"guest");
        }
        catch (Exception ex) {
            new ErrorConcept("error", "loginFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept logout() {
        try {
            this._con.close();
        }
        catch (Exception ex) {
            new ErrorConcept("error", "logoutFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public DSResponseConcept chmod(StringConcept mode, StringConcept subtree, LogicalConcept recursive) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.trees.mode"));
        xml.append("<chmod recursive='");
        if (recursive.getValue()) {
            xml.append("true");
        } else {
            xml.append("false");
        }
        xml.append("' verbose='false'>\n");
        xml.append("  <mode>" + mode.toString() + "</mode>\n");
        xml.append("  <doc>" + subtree.toString() + "</doc>\n");
        xml.append("</chmod>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept chown(StringConcept owner, StringConcept subtree, LogicalConcept recursive) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.trees.owner"));
        xml.append("<chown recursive='");
        if (recursive.getValue()) {
            xml.append("true");
        } else {
            xml.append("false");
        }
        xml.append("' verbose='false'>\n");
        xml.append("  <owner>" + owner.toString() + "</owner>\n");
        xml.append("  <doc>" + subtree.toString() + "</doc>\n");
        xml.append("</chown>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept makeSubtree(StringConcept subtree) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.trees"));
        xml.append("<tree action='create'>\n");
        xml.append("  <subtree>" + subtree.toString() + "</subtree>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept removeSubtree(StringConcept subtree, LogicalConcept force) {
        StringBuffer xml = new StringBuffer(this.getHeader("delete", "_admin.trees"));
        xml.append("<tree action='delete' force='" + new Boolean(force.getValue()).toString() + "'>\n");
        xml.append("  <subtree>" + subtree.toString() + "</subtree>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept list(StringConcept subtree) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.trees"));
        xml.append("<tree action='list' long='true' tree='false'>\n");
        xml.append("  <subtree>" + subtree.toString() + "</subtree>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept copy(StringConcept src, StringConcept dest, LogicalConcept recursive) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.trees"));
        xml.append("<tree action='copy' recursive='" + new Boolean(recursive.getValue()).toString() + "'" + " verbose='false'>\n");
        xml.append("  <src>" + src.toString() + "</src>\n");
        xml.append("  <dest>" + dest.toString() + "</dest>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept move(StringConcept src, StringConcept dest) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.trees"));
        xml.append("<tree action='move' verbose='false'>\n");
        xml.append("  <src>" + src.toString() + "</src>\n");
        xml.append("  <dest>" + dest.toString() + "</dest>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept changeStoreType(StringConcept subtree, StringConcept mode, LogicalConcept recursive) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.trees"));
        xml.append("<tree action='chtype' recursive='" + new Boolean(recursive.getValue()).toString() + "'" + " verbose='false'>\n");
        xml.append("  <subtree>" + subtree.toString() + "</subtree>\n");
        xml.append("  <src>" + mode.toString() + "</src>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept setNamingFlag(StringConcept subtree, StringConcept flag, LogicalConcept recursive) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.trees"));
        xml.append("<tree action='naming' recursive='" + new Boolean(recursive.getValue()).toString() + "'" + " verbose='false'>\n");
        xml.append("  <subtree>" + subtree.toString() + "</subtree>\n");
        xml.append("  <src>" + flag.toString() + "</src>\n");
        xml.append("</tree>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept addGroup(StringConcept gname) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.groups"));
        xml.append("<group action='add'>\n");
        xml.append("  <name>" + gname.toString() + "</name>\n");
        xml.append("</group>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept modGroup(StringConcept oldName, StringConcept newName) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.groups"));
        xml.append("<group action='mod'>\n");
        xml.append("  <name>" + oldName.toString() + "</name>\n");
        xml.append("  <newname>" + newName.toString() + "</newname>\n");
        xml.append("</group>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept delGroup(StringConcept group) {
        StringBuffer xml = new StringBuffer(this.getHeader("delete", "_admin.groups"));
        xml.append("<group action='del'>\n");
        xml.append("  <name>" + group.toString() + "</name>\n");
        xml.append("</group>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept listGroup(StringConcept group, StringConcept user) {
        StringBuffer xml = new StringBuffer("<request reqno='1'><fetch><union><intersect>");
        xml.append("  <compare subtree='_admin.groups");
        if (user.trim().getLength().getInt() > 0) {
            xml.append(".user." + user.toString());
        } else if (group.trim().getLength().getInt() > 0) {
            xml.append(".group." + group.toString());
        }
        xml.append("'><path /><value></value></compare>");
        xml.append("</intersect></union></fetch></request>");
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept addUser(StringConcept uname, StringConcept upwd, StringConcept home, StringConcept group, StringConcept groups) {
        StringBuffer xml = new StringBuffer(this.getHeader("write", "_admin.users"));
        if (group.trim().getLength().getInt() < 1) {
            group = uname;
        }
        xml.append("<user action='add'>\n");
        xml.append("  <username>" + uname.toString() + "</username>\n");
        if (upwd.trim().getLength().getInt() > 0) {
            xml.append("  <password>" + upwd.toString() + "</password>\n");
        }
        if (home.trim().getLength().getInt() > 0) {
            xml.append("  <homedir>" + home.toString() + "</homedir>\n");
        }
        xml.append("  <group>" + group.toString() + "</group>\n");
        if (groups.trim().getLength().getInt() > 0) {
            xml.append("  <groups>\n");
            StringTokenizer st = new StringTokenizer(groups.toString(), ",");
            while (st.hasMoreTokens()) {
                xml.append("    <group name='" + st.nextToken() + "' />\n");
            }
            xml.append("  </groups>\n");
        }
        xml.append("</user>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept modUser(StringConcept oldName, StringConcept uname, StringConcept upwd, StringConcept home, StringConcept group, StringConcept groups) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.users"));
        xml.append("<user action='mod'>\n");
        xml.append("  <loginname>" + oldName.toString() + "</loginname>\n");
        if (uname.trim().getLength().getInt() > 0) {
            xml.append("  <username>" + uname.toString() + "</username>\n");
        }
        if (upwd.trim().getLength().getInt() > 0) {
            xml.append("  <password>" + upwd.toString() + "</password>\n");
        }
        if (home.trim().getLength().getInt() > 0) {
            xml.append("  <homedir>" + home.toString() + "</homedir>\n");
        }
        if (group.trim().getLength().getInt() > 0) {
            xml.append("  <group>" + group.toString() + "</group>\n");
        }
        if (groups.trim().getLength().getInt() > 0) {
            xml.append("  <groups>\n");
            StringTokenizer st = new StringTokenizer(groups.toString(), ",");
            while (st.hasMoreTokens()) {
                xml.append("    <group name='" + st.nextToken() + "' />\n");
            }
            xml.append("  </groups>\n");
        }
        xml.append("</user>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept delUser(StringConcept uname) {
        StringBuffer xml = new StringBuffer(this.getHeader("delete", "_admin.users"));
        xml.append("<user action='del'>\n");
        xml.append("  <username>" + uname.toString() + "</username>\n");
        xml.append("</user>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept listUser(StringConcept uname) {
        StringBuffer xml = new StringBuffer("<request reqno='1'><fetch><union><intersect>\n");
        xml.append("  <compare subtree='_admin.users");
        if (uname.trim().getLength().getInt() > 0) {
            xml.append("." + uname.toString());
        }
        xml.append("'><path /><value></value></compare>\n");
        xml.append("</intersect></union></fetch></request>\n");
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept blockUser(StringConcept uname) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.users"));
        xml.append("<user action='block'>\n");
        xml.append("  <username>" + uname.toString() + "</username>\n");
        xml.append("</user>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept unblockUser(StringConcept uname) {
        StringBuffer xml = new StringBuffer(this.getHeader("update", "_admin.users"));
        xml.append("<user action='ublock'>\n");
        xml.append("  <username>" + uname.toString() + "</username>\n");
        xml.append("</user>\n" + this.getFooter());
        return this.executeSEP(xml.toString());
    }

    public DSResponseConcept fetch(StringConcept subtree, StringConcept path, StringConcept value) {
        String elem = "";
        String attrib = "";
        int index = 0;
        if (path.trim().getLength().getInt() > 0) {
            index = path.toString().indexOf("@");
            if (index >= 0) {
                attrib = path.toString().substring(index + 1);
            }
            if (index >= 0) {
                path = new StringConcept(path.toString().substring(0, index));
            }
            StringTokenizer t = new StringTokenizer(path.toString(), "/");
            while (t.hasMoreTokens()) {
                elem = elem + "<element property='" + t.nextToken() + "'/>";
            }
        }
        attrib = attrib.length() > 0 ? "<path attribute='" + attrib + "'>" + elem + "</path>" : (elem.length() > 0 ? "<path>" + elem + "</path>" : "<path />");
        if (subtree.trim().getLength().getInt() < 1) {
            value = new StringConcept("");
        }
        StringBuffer _fetch = new StringBuffer("<request reqno='1'><fetch><union><intersect>");
        _fetch.append("<compare subtree='" + subtree.trim().toString() + "' operator='contains'>" + attrib);
        _fetch.append("<value>" + value.toString() + "</value>");
        _fetch.append("</compare></intersect></union></fetch></request>");
        return this.executeSEP(_fetch.toString());
    }

    public DSResponseConcept store(StringConcept action, StringConcept path, StringConcept block) {
        String header = "<request reqno='1'><store action='" + action.toString() + "'>\n<block name='" + path.toString() + "'>\n";
        String footer = "</block>\n</store></request>";
        if (action.toString().equalsIgnoreCase("delete")) {
            return this.executeSEP(header + footer);
        }
        return this.executeSEP(header + block.toString() + footer);
    }

    public ConceptDefinition getConceptDefinition() {
        return DSClientDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    private final String getHeader(String action, String subtree) {
        return "<request reqno='1'>\n<store action='" + action + "'>\n<block name='" + subtree + "'>\n";
    }

    private final String getFooter() {
        return "</block>\n</store>\n</request>";
    }

    /*
     * WARNING - void declaration
     */
    private final DSResponseConcept executeSEP(String xml) {
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this._con.executeSEP(xml)));
            while ((line = reader.readLine()) != null) {
                void var3_5;
                buffer.append((String)var3_5 + "\n");
            }
            reader.close();
        }
        catch (Exception ex) {
            new ErrorConcept("error", "executeFailed", ex.getMessage());
        }
        return DSResponseConcept.getResponse(buffer.toString());
    }

    public DSClientConcept() {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this._host = DEFAULT_HOST;
        this._port = "10288";
    }

    public DSClientConcept(StringConcept host, StringConcept port) {
        System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
        this._host = host.toString();
        this._port = port.toString();
    }
}

