/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.DateDefinition;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.StringConcept;

public class DateConcept
extends JavaConcept {
    private long _value;

    public Concept create(StringConcept format, StringConcept input_date) {
        this.setDate(format, input_date);
        return this;
    }

    public Concept create(IntegerConcept input_date) {
        this.setDate(input_date);
        return this;
    }

    public Concept create() {
        this._value = System.currentTimeMillis();
        return this;
    }

    public LogicalConcept opEQ(DateConcept value) {
        return new LogicalConcept(this.getValue() == value.getValue());
    }

    public LogicalConcept opGT(DateConcept value) {
        return new LogicalConcept(this.getValue() > value.getValue());
    }

    public LogicalConcept opLT(DateConcept value) {
        return new LogicalConcept(this.getValue() < value.getValue());
    }

    public StringConcept getDate() {
        return new StringConcept(new Date(this._value).toString());
    }

    public IntegerConcept getTime() {
        return new IntegerConcept(this._value);
    }

    public StringConcept getDate(StringConcept format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format.toString());
        return new StringConcept(formatter.format(new Date(this._value)));
    }

    public void setDate(StringConcept format, StringConcept input_date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format.toString());
        Date myDate = formatter.parse(input_date.toString(), new ParsePosition(0));
        this._value = myDate.getTime();
    }

    public void setDate(IntegerConcept input_date) {
        this._value = input_date.getLong();
    }

    public ConceptDefinition getConceptDefinition() {
        return DateDefinition.getReference();
    }

    public StringConcept toTXT() {
        return new StringConcept(new Date(this._value).toString());
    }

    public StringConcept toXML() {
        return this.toTXT();
    }

    public long getValue() {
        return this._value;
    }

    public boolean equals(Object obj) {
        return obj instanceof DateConcept && ((DateConcept)obj).getValue() == this._value;
    }

    public Object clone() {
        return new DateConcept(new IntegerConcept(this._value));
    }

    public DateConcept() {
        this._value = System.currentTimeMillis();
    }

    public DateConcept(long date) {
        this._value = date;
    }

    public DateConcept(StringConcept format, StringConcept input_date) {
        this.setDate(format, input_date);
    }

    public DateConcept(IntegerConcept input_date) {
        this.setDate(input_date);
    }
}

