/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.DummyFieldConcept;
import org.media.mn8.FieldConcept;
import org.media.mn8.FieldDefinition;
import org.media.mn8.Helper;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.Attribute;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.AttributeSeries;
import org.media.mn8.concepts.Element;
import org.media.mn8.concepts.ElementDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TransparentElement;
import org.media.mn8.concepts.TypedSeries;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.mn8RuntimeFlags;

public class ElementConcept
extends JavaConcept
implements Element {
    Concept _value = null;
    protected StringConcept _name = null;
    protected StringConcept _label = null;
    protected AttributeSeries _attribs = new AttributeSeries();
    protected boolean _multi = false;

    public ElementConcept create(StringConcept label, Concept value) {
        this._name = this._label = label;
        this._multi = false;
        this._value = value;
        return this;
    }

    public String toString() {
        return this._value.toString();
    }

    public void addValue(Concept value) {
        if (this._value != null && this._value instanceof TypedSeries) {
            ((TypedSeries)this._value).add(value);
            if (!this._multi && ((TypedSeries)this._value).getVector().size() > 1) {
                this._multi = true;
            }
        } else if (this._value == null || this._value instanceof NilConcept) {
            this.setValue(value);
        } else {
            TypedSeries newValue = new TypedSeries();
            newValue.setConceptLabel(this._label);
            newValue.add(this._value);
            newValue.add(value);
            this.setValue(newValue);
            this._multi = true;
        }
    }

    public void setValue(Concept value) {
        this._value = value;
    }

    public Concept getValue() {
        return this._value;
    }

    public StringConcept getName() {
        return this._name;
    }

    public SeriesConcept getAttributes() {
        return this._attribs;
    }

    public void setAttributes(SeriesConcept attributes) {
        this._attribs = new AttributeSeries(attributes.getVector());
    }

    public void addAttribute(AttributeConcept attr) {
        if (attr != null) {
            this._attribs.add(attr);
        }
    }

    public void addAttribute(StringConcept name, StringConcept label, Concept value) {
        this._attribs.add(new AttributeConcept(name.toString(), label.toString(), value));
    }

    public StringConcept getLabel() {
        return this._label;
    }

    public int hashCode() {
        return this._name.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementConcept) {
            return this.equals((ElementConcept)obj).getValue();
        }
        return false;
    }

    public void setLabel(StringConcept label) {
        this._label = label;
        if (this._name != null && this._name.toString().trim().equals("")) {
            this._name = label;
        }
    }

    public StringConcept getValueType() {
        return this._value.getConceptType();
    }

    public String getElementName() {
        return this._name.getValue();
    }

    public void setElementName(String name) {
        this._name = new StringConcept(name);
    }

    public String getElementLabel() {
        return this._label.getValue();
    }

    public void setElementLabel(String label) {
        this._label = new StringConcept(label);
    }

    public void setElementValue(Concept concept) {
        this.setValue(concept);
    }

    public Concept getElementValue() {
        return this.getValue();
    }

    public String getElementType() {
        return this._value.getConceptType().getValue();
    }

    public void setConceptLabel(StringConcept label) {
        this.setLabel(label);
    }

    public StringConcept getConceptLabel() {
        return this.getLabel();
    }

    public StringConcept toTXT() {
        if (this._value == null || this.isHidden().getValue()) {
            return new StringConcept();
        }
        StringBuffer value = new StringBuffer();
        Vector elements = this._value.getConceptElements().getVector();
        if (elements.size() <= 0) {
            value.append("\t" + this.getValue().toTXT().toString());
        } else {
            int i = 0;
            while (i < elements.size()) {
                value.append(((Concept)elements.elementAt(i)).toTXT());
                ++i;
            }
        }
        if (!this.showEmpty().getValue() && value.toString().trim().equals("") && this.getAttributes().toXML().toString().trim().equals("")) {
            return new StringConcept();
        }
        String result = "";
        result = this._attribs.getVector().size() > 0 ? this._label.toString() + mn8Interpreter.EOL + this._attribs.toTXT().toString() + mn8Interpreter.EOL : this._label.toString() + mn8Interpreter.EOL;
        result = result + value.toString();
        return new StringConcept(result);
    }

    public StringConcept toXML() {
        if (this._value == null || this.isHidden().getValue()) {
            return new StringConcept();
        }
        StringBuffer result = new StringBuffer();
        String value = this._value.toXML().toString();
        if (!this.showEmpty().getValue() && value.trim().equals("") && this.getAttributes().toXML().toString().trim().equals("")) {
            return new StringConcept();
        }
        result.append("<");
        result.append(this.getConceptLabel().toString());
        result.append(this.getAttributes().toXML().toString());
        result.append(">");
        if (!Helper.startsWithEOL(value) && value.trim().startsWith("<") && Helper.hasEOL(value)) {
            result.append(mn8Interpreter.EOL);
        }
        result.append(value);
        if (Helper.hasEOL(value) && !Helper.endsWithEOL(value) && value.trim().endsWith(">")) {
            result.append(mn8Interpreter.EOL);
        }
        result.append("</" + this.getConceptLabel().toString() + ">");
        return new StringConcept(result.toString());
    }

    public ConceptDefinition getConceptDefinition() {
        return ElementDefinition.getReference();
    }

    public LogicalConcept hasConceptElement(StringConcept name) {
        return new LogicalConcept(this.hasConceptElement(name.toString()));
    }

    public boolean hasConceptElement(String name) {
        if (this._value != null && this._value instanceof Element && ((ElementConcept)this._value).getName().toString().equalsIgnoreCase(name)) {
            return true;
        }
        if (this._value.hasConceptElement(name)) {
            return true;
        }
        return super.hasConceptElement(name);
    }

    public boolean hasConceptAttribute(String name) {
        if (this._attribs.hasConceptElement(name)) {
            return true;
        }
        return super.hasConceptAttribute(name);
    }

    public void setShowEmpty(LogicalConcept showEmpty) {
        this._showEmpty = showEmpty.getValue();
        this._value.setShowEmpty(showEmpty);
        int i = 0;
        while (i < this._attribs.getVector().size()) {
            ((Concept)this._attribs.getVector().elementAt(i)).setShowEmpty(showEmpty);
            ++i;
        }
    }

    public SeriesConcept getConceptElements() {
        if (this._value != null && !this._multi) {
            if (this._value instanceof TypedSeries) {
                this._multi = true;
                return this._value.getConceptElements();
            }
            TypedSeries result = new TypedSeries();
            ((SeriesConcept)result).add(new TransparentElement(Helper.extractName(this._value).toString(), this._value.getConceptLabel().toString(), this._value, null));
            return result;
        }
        return this._value.getConceptElements();
    }

    public Concept getConceptElement(StringConcept name) {
        return this.getConceptElement(name.toString());
    }

    public Concept getConceptElement(String name) {
        if (this._value != null && Helper.isElement(this._value) && ((ElementConcept)this._value).getName().toString().equalsIgnoreCase(name)) {
            return this._value;
        }
        return this._value.getConceptElement(name);
    }

    public FieldDefinition getConceptElementField(StringConcept name) {
        return this.getConceptElementField(name.toString());
    }

    public FieldDefinition getConceptElementField(String name) {
        if (this._value != null && Helper.isElement(this._value)) {
            return new DummyFieldConcept(((Element)((Object)this._value)).getElementName(), this._value, false, ((Element)((Object)this._value)).getElementLabel(), this._value.getConceptType().toString());
        }
        return this._value.getConceptElementField(name);
    }

    public LogicalConcept isMulti() {
        return new LogicalConcept(this._multi);
    }

    public SeriesConcept getConceptElementFields() {
        if (this._value != null && this._value instanceof Element) {
            TypedSeries result = new TypedSeries();
            ((SeriesConcept)result).add((FieldConcept)this.getConceptElementField(""));
            return result;
        }
        return this._value.getConceptElementFields();
    }

    public SeriesConcept getConceptAttributeFields() {
        SeriesConcept result = new SeriesConcept();
        int i = 0;
        while (i < this._attribs.getVector().size()) {
            if (this._attribs.getVector().elementAt(i) instanceof Attribute) {
                result.add(new DummyFieldConcept(((Attribute)this._attribs.getVector().elementAt(i)).getAttributeName(), (AttributeConcept)this._attribs.getVector().elementAt(i), false, ((Attribute)this._attribs.getVector().elementAt(i)).getAttributeLabel(), ((Attribute)this._attribs.getVector().elementAt(i)).getAttributeType(), false));
            }
            ++i;
        }
        return result;
    }

    public FieldDefinition getConceptAttributeField(String name) {
        Element hidenElem = (Element)((Object)this._attribs.getConceptElement(new StringConcept(name)));
        AttributeConcept attr = null;
        if (hidenElem.getElementValue() instanceof Attribute) {
            attr = (AttributeConcept)hidenElem.getElementValue();
        }
        return new DummyFieldConcept(attr.getAttributeName(), attr, false, attr.getAttributeLabel(), attr.getAttributeType(), false);
    }

    public Concept getConceptAttribute(String name) {
        return ((TransparentElement)this._attribs.getConceptElement(name)).getValue();
    }

    public SeriesConcept getConceptAttributes() {
        SeriesConcept result = new SeriesConcept();
        int i = 0;
        while (i < this._attribs.getVector().size()) {
            if (this._attribs.getVector().elementAt(i) instanceof Attribute) {
                result.add((AttributeConcept)this._attribs.getVector().elementAt(i));
            }
            ++i;
        }
        return result;
    }

    public Object clone() {
        ElementConcept result = new ElementConcept(this._name.toString(), this._label.toString(), this._value == null ? null : (Concept)this._value.clone(), (SeriesConcept)this._attribs.clone(), this._multi, this._value instanceof TypedSeries ? ((TypedSeries)this._value).getType().toString() : "Nil");
        result.setShowEmpty(this.showEmpty());
        result.setHidden(this.isHidden());
        return result;
    }

    public void loadContent(Concept from) {
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("--> in element:" + Helper.getConceptInfo(this) + "->" + Helper.getConceptInfo(from));
        }
        if (from instanceof TransparentElement) {
            ElementConcept el = (ElementConcept)from;
            if (this.getLabel().toString().equalsIgnoreCase(el.getLabel().toString())) {
                if (!this._multi && !el.isMulti().getValue()) {
                    if (el.getValue() instanceof ElementConcept) {
                        this.loadContent(el.getValue());
                    } else {
                        this.setValue(((ElementConcept)from).getValue());
                        Concept conc = Helper.loadAttributes(from, this);
                        this.setAttributes(conc.getConceptAttributes());
                    }
                } else if (this._value instanceof NilConcept) {
                    this.setValue(el.getElementValue());
                } else {
                    this._value.loadContent(el.getValue());
                }
            }
        } else if (from instanceof ElementConcept && this.getLabel().toString().equalsIgnoreCase(((ElementConcept)from).getLabel().toString())) {
            if (!this._multi && !((ElementConcept)from).isMulti().getValue()) {
                this.setValue(((ElementConcept)from).getValue());
                Concept conc = Helper.loadAttributes(from, this);
                this.setAttributes(conc.getConceptAttributes());
            } else if (this._value instanceof NilConcept) {
                this.setValue(((ElementConcept)from).getElementValue());
            } else {
                this._value.loadContent(from);
            }
        }
    }

    public LogicalConcept opEquals(ElementConcept elem) {
        return this.equals(elem);
    }

    public LogicalConcept equals(ElementConcept elem) {
        Vector targetAttrs;
        Vector myAttrs = this.getAttributes().getVector();
        if (!myAttrs.equals(targetAttrs = elem.getAttributes().getVector())) {
            return new LogicalConcept(false);
        }
        if (!this._label.toString().equals(elem.getElementLabel())) {
            return new LogicalConcept(false);
        }
        if (!this._value.equals(elem.getElementValue())) {
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept subElementHasPath(String elementName, String subPath) {
        if (!(this._value instanceof TransparentElement) && this._value instanceof Element && (((ElementConcept)this._value).getName().toString().equalsIgnoreCase(elementName) || ((ElementConcept)this._value).getLabel().toString().equalsIgnoreCase(elementName))) {
            return this._value.hasPath(subPath);
        }
        return this._value.subElementHasPath(elementName, subPath);
    }

    public boolean areThereMoreElemenents(String path) {
        if (!(this._value instanceof TransparentElement) && this._value instanceof Element) {
            return this._value.getConceptLabel().equals((Object)new StringConcept(path));
        }
        return this._value.areThereMoreElemenents(path);
    }

    public SeriesConcept searchDeeperForPath(SeriesConcept holder, String path) {
        if (!(this._value instanceof TransparentElement) && this._value instanceof Element) {
            return this._value.getConceptsAtPath(holder, path);
        }
        return this._value.searchDeeperForPath(holder, path);
    }

    public Vector getMeAllElements(String path) {
        if (!(this._value instanceof TransparentElement) && this._value instanceof Element) {
            Vector<Concept> result = new Vector<Concept>();
            result.add(this._value);
            return result;
        }
        return this._value.getMeAllElements(path);
    }

    public ElementConcept() {
        this._label = this._name = new StringConcept("");
        this._value = new NilConcept();
    }

    public ElementConcept(String name, String label, Concept value, SeriesConcept attributes) {
        this._value = value == null ? new NilConcept() : value;
        this._label = label == null ? new StringConcept(name) : new StringConcept(label);
        this._label = label.trim().equals("") ? new StringConcept(name) : new StringConcept(label);
        this._name = new StringConcept(name);
        this._attribs = attributes == null ? new AttributeSeries(this._value.getConceptAttributes().getVector()) : new AttributeSeries(attributes.getVector());
    }

    public ElementConcept(String name, String label, Concept value, SeriesConcept attributes, boolean multi, String multiType) {
        this._label = label == null ? new StringConcept(name) : new StringConcept(label);
        this._name = new StringConcept(name);
        if (attributes != null) {
            this._attribs = new AttributeSeries(attributes.getVector());
        }
        this._multi = multi;
        if (this._multi) {
            this._value = new TypedSeries(multiType, this._label.toString());
            this._value.setConceptLabel(this._label);
            if (value != null && !(value instanceof NilConcept)) {
                ((SeriesConcept)this._value).add(value);
            }
        } else {
            this._value = value != null ? value : new NilConcept();
        }
        if (this._multi && value instanceof SeriesConcept) {
            this._value = value;
        }
    }
}

