/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import com.oroinc.net.ProtocolCommandListener;
import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPConnectionClosedException;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.FTPClientConceptDefinition;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.PrintCommandListener;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;

public class FTPClientConcept
extends JavaConcept {
    protected FTPClient _client = null;
    protected URL _url;
    public AttributeConcept errorMessage = new AttributeConcept("errorMessage", "errorMessage", new NilConcept());
    public AttributeConcept errorCode = new AttributeConcept("errorCode", "errorCode", new NilConcept());

    public LogicalConcept openConnection(StringConcept url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url.toString());
            if (givenURL == null || givenURL.getProtocol().toLowerCase().equals("ftp")) {
                if (givenURL != null) {
                    this._url = givenURL;
                    this._client = new FTPClient();
                    this._client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
                    if (givenURL.getHost() == null || givenURL.getHost().trim().length() < 1) {
                        new ErrorConcept("error", "missingHost", "Missing host name for FTP connection.");
                        return new LogicalConcept(false);
                    }
                    if (givenURL.getHost() != null && givenURL.getPort() == -1) {
                        this._client.connect(givenURL.getHost());
                    }
                    if (givenURL.getHost() != null && givenURL.getPort() != -1) {
                        this._client.connect(givenURL.getHost(), givenURL.getPort());
                    }
                    this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
                    this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
                    if (!FTPReply.isPositiveCompletion((int)this._client.getReplyCode())) {
                        this._client.disconnect();
                        new ErrorConcept("error", "connectionRefuzed", "FTP server (" + givenURL.getHost() + ") refuzed connection, the reply code is:" + this._client.getReplyCode());
                        return new LogicalConcept(false);
                    }
                }
            } else if (givenURL != null) {
                new ErrorConcept("error", "unsupportedProtocol", "'" + givenURL.getProtocol() + "' protocol not supported by FTPClient");
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public void closeConnection() {
        try {
            this._client.disconnect();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "closeConnection", ex.getMessage());
        }
    }

    public LogicalConcept login(StringConcept uname, StringConcept pwd) {
        try {
            boolean logined = this._client.login(uname.toString(), pwd.toString());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (logined) {
                String _path = this._url.getFile();
                while (!this._client.changeWorkingDirectory(_path)) {
                    _path = _path.substring(0, _path.lastIndexOf("/"));
                }
                return new LogicalConcept(true);
            }
            new ErrorConcept("warning", "loginWarning", this._client.getReplyString());
            return new LogicalConcept(false);
        }
        catch (FTPConnectionClosedException e) {
            new ErrorConcept("error", "loginFailed", e.getMessage());
            return new LogicalConcept(false);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "loginFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept logout() {
        try {
            boolean status = this._client.logout();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "logoutFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public StringConcept getWorkingDirectory() {
        try {
            String pwd = this._client.printWorkingDirectory();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            return new StringConcept(pwd);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new StringConcept("");
        }
    }

    public LogicalConcept changeWorkingDirectory(StringConcept path) {
        try {
            boolean status = this._client.changeWorkingDirectory(path.toString());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (!status) {
                new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
            }
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept mkdir(StringConcept _path) {
        try {
            boolean status = this._client.makeDirectory(_path.toString());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (!status) {
                new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
            }
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept delete(StringConcept _path) {
        try {
            boolean status = false;
            status = this._client.deleteFile(_path.toString());
            if (!status) {
                status = this._client.removeDirectory(_path.toString());
            }
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (!status) {
                new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
            }
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept rename(StringConcept from, StringConcept to) {
        try {
            boolean status = this._client.rename(from.toString(), to.toString());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (!status) {
                new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
            }
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept setBinaryMode(LogicalConcept isBinary) {
        try {
            boolean status = false;
            status = isBinary.getValue() ? this._client.setFileType(2) : this._client.setFileType(0);
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (!status) {
                new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
            }
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept isPositiveCompletion() {
        return new LogicalConcept(FTPReply.isPositiveCompletion((int)this._client.getReplyCode()));
    }

    public ConceptDefinition getConceptDefinition() {
        return FTPClientConceptDefinition.getReference();
    }

    public SeriesConcept getLinks() {
        SeriesConcept result = new SeriesConcept();
        try {
            FTPFile[] fileNames = this._client.listFiles();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    result.add(new StringConcept(fileNames[i].getRawListing()));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
        }
        return result;
    }

    public SeriesConcept getLinks(StringConcept path) {
        SeriesConcept result = new SeriesConcept();
        String _path = path.toString().startsWith("./") ? path.toString().substring(2) : path.toString();
        try {
            FTPFile[] fileNames = this._client.listFiles(_path);
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    result.add(new StringConcept(fileNames[i].getRawListing()));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public StringConcept getFile(StringConcept fileName) {
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this._client.retrieveFileStream(fileName.toString())));
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            while ((ch = reader.read()) != -1) {
                void var4_5;
                sb.append((char)var4_5);
            }
            reader.close();
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
        }
        return new StringConcept(sb.toString());
    }

    public LogicalConcept putFile(StringConcept fName, StringConcept content) {
        OutputStream out = null;
        try {
            this._client.allocate(content.toString().getBytes().length);
            out = this._client.storeFileStream(fName.toString());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            this.errorCode.setAttributeValue(new IntegerConcept(this._client.getReplyCode()));
            out.write(content.toString().getBytes(), 0, content.toString().getBytes().length);
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public FTPClient getClient() {
        return this._client;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FTPClientConcept) {
            FTPClient _obj_client = ((FTPClientConcept)obj).getClient();
            if (_obj_client == null && this._client == null) {
                return true;
            }
            if (this._client.equals(_obj_client)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return this;
    }
}

