/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import com.oroinc.net.ProtocolCommandListener;
import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.UnknownHostException;
import javax.activation.MimetypesFileTypeMap;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.FTPFileConceptDefinition;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.PrintCommandListener;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.event.FTPOperationFailure;

public class FTPFileConcept
extends JavaConcept {
    protected FTPClient _client = null;
    protected FTPFile _file = null;
    protected URL _url = null;
    protected boolean _exists = true;
    public AttributeConcept url = new AttributeConcept("url", "url", new NilConcept());
    public AttributeConcept length = new AttributeConcept("length", "length", new NilConcept());
    public AttributeConcept contentType = new AttributeConcept("contentType", "contentType", new NilConcept());
    public ElementConcept content = new ElementConcept("content", "content", new NilConcept(), null);

    public FTPFileConcept create(StringConcept url) {
        this.initialize(url.toString());
        return this;
    }

    public boolean initialize(String url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url);
            if (givenURL == null || givenURL.getProtocol().toLowerCase().equals("ftp")) {
                if (givenURL != null) {
                    this._url = givenURL;
                    this._client = new FTPClient();
                    this._client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
                    this._client.connect(givenURL.getHost());
                    if (!FTPReply.isPositiveCompletion((int)this._client.getReplyCode())) {
                        this._client.disconnect();
                        new ErrorConcept("error", "connectionRefuzed", "FTP server (" + givenURL.getHost() + ") refuzed connection, the reply code is:" + this._client.getReplyCode());
                        return false;
                    }
                    this._client.login(givenURL.getUserInfo().substring(0, givenURL.getUserInfo().indexOf(":")), givenURL.getUserInfo().substring(givenURL.getUserInfo().indexOf(":") + 1));
                    FTPFile[] files = this._client.listFiles(givenURL.getFile());
                    if (files != null && files.length == 1) {
                        this._file = files[0];
                    } else if (files == null) {
                        this._exists = false;
                        if (givenURL.getFile() != null && this._file == null) {
                            this._file = new FTPFile();
                            this._file.setType(0);
                            this._file.setName(givenURL.getFile().substring(givenURL.getFile().lastIndexOf("/") + 1));
                        }
                    } else if (files.length > 1) {
                        this._file = new FTPFile();
                        this._file.setType(1);
                        this._file.setName(givenURL.getFile());
                    }
                    this.url.setAttributeValue(new StringConcept(this._url.getProtocol() + "://" + this._url.getAuthority() + this._url.getPath() + this._file.getName()));
                    this.length.setAttributeValue(new IntegerConcept(this._file.getSize()));
                    this.contentType.setAttributeValue(new StringConcept(new MimetypesFileTypeMap().getContentType(this._file.getName())));
                    this.url.setAttributeValue(new StringConcept(givenURL.toString()));
                }
            } else if (givenURL != null) {
                new ErrorConcept("error", "unsupportedProtocol", "'" + givenURL.getProtocol() + "' protocol not supported by FTPFile");
            }
        }
        catch (UnknownHostException ex) {
            throw new FTPOperationFailure("Unknown host: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new ErrorConcept("error", "badURL", ex.getMessage());
            return false;
        }
        return true;
    }

    public ConceptDefinition getConceptDefinition() {
        return FTPFileConceptDefinition.getReference();
    }

    public LogicalConcept exists() {
        return new LogicalConcept(this._exists);
    }

    public LogicalConcept isFile() {
        return new LogicalConcept(this._file != null && !this._file.isDirectory());
    }

    public SeriesConcept getLinks() {
        SeriesConcept result = new SeriesConcept();
        if (this.isFile().getValue() || !this.exists().getValue()) {
            return result;
        }
        try {
            this._client.changeWorkingDirectory(this._url.getPath() != null ? this._url.getPath() : "./");
            FTPFile[] files = this._client.listFiles();
            FTPFile tmpFile = null;
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    tmpFile = files[i];
                    result.add(new StringConcept(this._url.getProtocol() + "://" + this._url.getAuthority() + this._url.getPath() + tmpFile.getName()));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
        }
        return result;
    }

    public Concept getContent() {
        this.readContent();
        return this.content.getElementValue();
    }

    public LogicalConcept setContent(Concept value) {
        this.content.setElementValue(value.toTXT());
        return this.writeContent();
    }

    /*
     * WARNING - void declaration
     */
    protected LogicalConcept readContent() {
        if (this._file != null && this.exists().getValue() && this.isFile().getValue()) {
            this.length.setAttributeValue(new IntegerConcept(this._file.getSize()));
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this._client.retrieveFileStream(this._url.getPath())));
                try {
                    int character;
                    while ((character = reader.read()) != -1) {
                        void var3_5;
                        buffer.append((char)var3_5);
                    }
                }
                catch (IOException ex) {
                    new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
                    return new LogicalConcept(false);
                }
            }
            catch (FileNotFoundException fnfex) {
            }
            catch (Exception ex) {
                new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
                return new LogicalConcept(false);
            }
            this.content.setElementValue(new StringConcept(buffer.toString()));
        } else if (this._file != null && !this.isFile().getValue()) {
            this.content.setElementValue(new StringConcept());
        }
        return new LogicalConcept(true);
    }

    /*
     * Loose catch block
     */
    protected LogicalConcept writeContent() {
        block13: {
            block12: {
                if (this._file == null || !this.isFile().getValue()) break block12;
                OutputStream writter = null;
                this._client.changeWorkingDirectory(this._url.getPath() != null ? this._url.getPath() : "./");
                String contentString = this.content.getElementValue().toTXT().toString();
                this._client.allocate(contentString.getBytes().length);
                writter = this._client.storeFileStream(this._url.getPath());
                writter.write(contentString.getBytes(), 0, contentString.getBytes().length);
                writter.flush();
                Object var3_4 = null;
                try {
                    writter.close();
                    if (!this._client.completePendingCommand()) {
                        new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
                    }
                    this._client.logout();
                    this._client.disconnect();
                }
                catch (IOException ioex) {
                    new ErrorConcept("warning", "FTPOperationWarning", ioex.getMessage());
                }
                break block13;
                {
                    catch (IOException ex) {
                        new ErrorConcept("error", "FTPOperationFailed", ex.getMessage());
                        LogicalConcept logicalConcept = new LogicalConcept(false);
                        Object var3_5 = null;
                        try {
                            writter.close();
                            if (!this._client.completePendingCommand()) {
                                new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
                            }
                            this._client.logout();
                            this._client.disconnect();
                        }
                        catch (IOException ioex) {
                            new ErrorConcept("warning", "FTPOperationWarning", ioex.getMessage());
                        }
                        return logicalConcept;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    try {
                        writter.close();
                        if (!this._client.completePendingCommand()) {
                            new ErrorConcept("warning", "FTPOperationWarning", this._client.getReplyString());
                        }
                        this._client.logout();
                        this._client.disconnect();
                    }
                    catch (IOException ioex) {
                        new ErrorConcept("warning", "FTPOperationWarning", ioex.getMessage());
                    }
                    throw throwable;
                }
            }
            return new LogicalConcept(false);
        }
        this.initialize(this._url.toString());
        this.readContent();
        return new LogicalConcept(true);
    }

    public FTPFile getFTPFile() {
        return this._file;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FTPFileConcept) {
            FTPFile _obj_client = ((FTPFileConcept)obj).getFTPFile();
            if (_obj_client == null && this._file == null) {
                return true;
            }
            if (this._file.equals(_obj_client)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        return this;
    }

    public FTPFileConcept() {
    }

    public FTPFileConcept(String url) {
        this.initialize(url);
    }
}

